import QtQuick 2.3

Item {
    property string actionFileEnd
    property string fileNameForAction: model.modelData.details
    width: 50
    height: 20

    clip: true

    Rectangle {
        anchors.fill:parent
        anchors.margins: 2
        border.width: 2
        border.color: "grey"
        Text {
            anchors.fill: parent
            text: actionFileEnd
            color: "white"
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
        }
        color: "black"
        MouseArea {
            anchors.fill: parent
            onPressedChanged: {
                if (pressed) {
                    console.log("Mouse press ButtonEffectAction:"+model.modelData.rocketNameStack)
                    rocket.findTrack(model.modelData.rocketNameStack);
                    if (fileNameForAction !== "") {
                        console.log("ButtonEffectAction clicked with details:"+fileNameForAction+"."+actionFileEnd)
                        rocket.openFile(model.modelData.name,
                                        fileNameForAction+"."+actionFileEnd)
                    }
                }
            }
        }
    }

}
