#version 430

in vec2 uv;

layout(location = 0) out vec4 frag;


uniform float g_time;
uniform float g_timeStep;

/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
*/
uniform float flip=1.0;

uniform float overlayAlpha=1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texPrev;

uniform vec4 g_prevAmount = vec4(0.5, 0.5, 0.5, 1.0); // RGB and A for all
uniform vec4 g_prevPow = vec4(1.0, 1.0, 1.0, 1.0); // RGB powers and A is for all

uniform float delayHeight;

vec3 tonemapUC2(vec3 x) {
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

void main() {

    vec2 uvS = uv;
    uvS.y = 1.0-uvS.y;

    vec4 fftIn = texelFetch(tex, ivec2(gl_FragCoord.x, 0), 0);

    ivec2 kk = ivec2(gl_FragCoord.xy);

    if (kk.y == 0) {
        frag.rgb = fftIn.rgb;
    } else {
        uvS = vec2(gl_FragCoord.x, gl_FragCoord.y-1.0*g_timeStep/0.0167);
        uvS.x /= 1024;
        uvS.y /= delayHeight;
        uvS = clamp(uvS, 0.0, 1.0);
        vec4 prev = texture2D(texPrev, uvS);
        frag.rgb = prev.rgb;
    }
  //  frag.rgb = vec3(1.0, 0.0, 0.0);
    frag.a = 1.0;
}

