import QtQuick 2.3

Row {
    id: openRow
    height:  20

//    visible: model.modelData.name.indexOf("Shader")!==-1 ? true : false
    property real shaderOpenButtonsWidth:  model.modelData.name.indexOf("Shader")!==-1 ? 50.0 : 0.0

    property real qmlOpenButtonsWidth: (model.modelData.origName.indexOf("Group")!==-1) ? 50.0 : 0.0

    ButtonEffectAction {
        width: openRow.shaderOpenButtonsWidth
        actionFileEnd: "vert"
        fileNameForAction: kols.resolvedFilePath
    }
    ButtonEffectAction {
        width: openRow.shaderOpenButtonsWidth
        actionFileEnd: "geom"
        fileNameForAction: kols.resolvedFilePath
    }
    ButtonEffectAction {
        width: openRow.shaderOpenButtonsWidth
        actionFileEnd: "frag"
        fileNameForAction: kols.resolvedFilePath
    }


    ButtonEffectAction {
        id: bea
        property real filesFound: 1.0
        width: openRow.qmlOpenButtonsWidth*filesFound
        actionFileEnd: "qml"
        fileNameForAction: "fx/_SharedQML/"+model.modelData.name

        onFileNameForActionChanged: {
            filesFound = rocket.fileExists(bea.fileNameForAction+".qml") ? 1.0 : 0.0;
//            console.log("fileNameForAction QML set to:"+fileNameForAction)
        }
    }
}
