import QtQuick 2.4
import Qt.WebSockets 1.1

Item {

  property int nextClientId: -1
  property int numClients: 0

  property var webSockets: []
  property var clientIds: []
  property var webSocketId: []


  function genId() {
      nextClientId++;
      return nextClientId;
  }

  function sendJSON(ws, js) {
    ws.sendTextMessage(JSON.stringify(js));
  }

  function shareDemoTime(t) {
    for (var i=0; i<numClients; i++) {
      sendJSON(webSockets[i], { action: "setTime", time: t });
    }
  }

  function trackFocused(trackName, trackValue) {
    for (var i=0; i<numClients; i++) {
      sendJSON(webSockets[i], { action: "trackFocused", track: trackName, value: trackValue });
    }
  }

  function focusedTrackValueChanged(trackName, trackValue) {
    for (var i=0; i<numClients; i++) {
      sendJSON(webSockets[i], { action: "focusedTrackValueChanged", track: trackName, value: trackValue });
    }
  }


  WebSocketServer {
      id: server
      listen: true
      host: "127.0.0.1"
      port: 7788

      Component.onCompleted: {
          // msg("adapt XiON communication server")
          // msg("listening to:"+host+":"+port);
      }

      onClientConnected: {
          // msg("New client connected to:"+webSocket.url)
          var clientId = genId();
          clientIds[numClients] = clientId;
          webSockets[numClients] = webSocket;
          webSocketId[webSocket] = clientId;
          numClients++;
          sendJSON(webSocket, { text: "Hello client; id:"+clientId });
          webSocket.onTextMessageReceived.connect(function(message) {
          //    msg(qsTr("Server received message: %1").arg(message));

          });
      }
      onErrorStringChanged: {
        //  msg(qsTr("server error: %1").arg(errorString));
      }
  }


}
