import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "godray"
  effectName: "GodRay"
  property GodRayImpl impl
  Component {
    id: ec
    GodRayImpl {}
  }
  property real godRayX: 0.0
  property real godRayY: 0.0


  enabled: syncRootOn(effect.name, effectName);
  onEffectRender: {
    if (sceneName !== "") {
      if (enabled && !impl) {
        impl = ec.createObject(effect,
                               { name: effect.name,
                                 effectName: effect.effectName,
                                 godRayX: effect.godRayX,
                                 godRayY: effect.godRayY
                               });
      }
      if (!enabled && impl) {
        impl.destroy();
        impl = undefined;
      }
    }
  }
}
