import QtQuick 2.4

import AdaptDemoSystem 1.0

GroupBase {
    id: groupBase

    property string effectBaseName: effectName


    property var valMap: []

    Component {
        id: sb
        SyncBlock {

        }
    }

    function getEffectNameFromTrack(trackName) {
      var s = trackName;
      var sa = s.split(".");
      if (sa.length > 1) {
        return sa[1];
      }
      return "";
    }

    Connections {
      target: getRootRocket()
      onTrackFocused: {
        if (effectName !== "Group") {
          var effectTrackName = groupBase.name

          var rocketEffectTrackName = getEffectNameFromTrack(trackName);

          console.log("track focused in scene, effectTrackName:"+effectTrackName+" rocketEffectTrackName:"+rocketEffectTrackName+ " effectName:"+effectName)

          if (effectTrackName === rocketEffectTrackName) {
            root.focusedToEffectBaseName(effectName);
          }
        }
      }

    }



    function syncWithBlockFixed(track, i) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
        return sbu.getFixedValue(i);
    }

    function writeBlockFixedValue(track, i, value) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
        sbu.setFixedValue(i, value);
    }


    function syncWithBlock(track, defaultValue) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
        if (!root.bReleaseVer) {
            if (defaultValue !== undefined && defaultValue !== "" && sbu.value===0.0) {
                var trackKeys = getRootRocket().getTrackNumKeys(sk);
             //   console.log("track num keys:"+trackKeys+" for track:"+track);
                if (trackKeys === 0) {
                    // console.log("setting track first value to:"+defaultValue);
                    getRootRocket().setTrackFirstValue(sk, defaultValue);
                    return defaultValue;
                }
            }
        }
        return sbu.value;
    }

    function syncWithBlockTrigger(track, defaultValue) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
//        if (!root.bReleaseVer) {
//            if (defaultValue !== undefined && defaultValue !== "" && sbu.valueTrigger===0.0) {
//                var trackKeys = getRootRocket().getTrackNumKeys(track);
//                if (trackKeys === 0) {
//                    getRootRocket().setTrackFirstValue(track, defaultValue);
//                    return defaultValue;
//                }
//            }
//        }
        return sbu.valueTrigger;
    }


    function sync(track, defaultValue) {
        if (sceneName === "") return 1.0;
        return syncWithBlock(track, defaultValue);
    }

    function syncGroup(track, defaultValue) {
        if (sceneName == "") return 1.0;
        return syncWithBlock(track, defaultValue);
    }

    function syncTrigger(track) {
        if (sceneName == "") return 1.0;
        if (!demoLoadedAndInitReady) {
            return 1.0;
        }
        var a = getRootRocket().syncTrigger(sceneName+"."+track);
        var b = groupBase.effectSyncUpdate;
        // console.log("syncTrigger for track:"+track, "gives:"+a);
        return a;
       // return syncWithBlockTrigger(track, 0.0);
    }


    function syncTime(track, t) {
        if (sceneName == "") return 1.0;
        if (!demoLoadedAndInitReady) {
            return 1.0;
        }
        var a = getRootRocket().syncTime(sceneName+"."+track, t);
    //    var b = groupBase.effectSyncUpdate;
        return a;
    }

    function syncTriggerTime(track, t) {
        if (sceneName == "") return 1.0;
        if (!demoLoadedAndInitReady) {
            return 1.0;
        }
        var a = getRootRocket().syncTrigger(sceneName+"."+track, t);
        var b = groupBase.effectSyncUpdate;
        // console.log("syncTrigger for track:"+track, "gives:"+a);
        return a;
       // return syncWithBlockTrigger(track, 0.0);
    }


    function syncOsc(track, defaultValue) {
        return syncOscBase(track, "-osc", defaultValue, syncGroup);
    }
    function syncFFT(track, defaultValue) {
      // return syncFFTBase(track, "-fft", defaultValue, syncGroup);
      return syncFFTBaseImage(track, "-fft", defaultValue, syncGroup);
    }
    function getTexImageFFT(track) {
      return getFFTBaseTexImage(track, "-fft", syncGroup)
    }

    function syncOscFFT(track, defaultValue) {
        return syncOscBase(track, "-osc", defaultValue, syncGroup)+syncFFTBaseImage(track, "-fft", defaultValue, syncGroup)-syncGroup(track, defaultValue);
    }


}
