import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    property int div

    property string efName

    RenderTarget { // calculate the triangle normal
        Shader { file: "mesherCalcNorm" }
        RenderTargetLayer {
            textureRT: "mesherTriangles"+efName; format: "RGBA32F"; width: 2048; height: 1024
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles"+efName } // read
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos"+efName } // read
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "mesherTriNorm"+efName } // write
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            ShaderParam { paramName: "div"; paramValue: div }
        }
    }

    RenderTarget { // calculate the vertex normal
        Shader { file: "mesherCalcNormVert" }
        RenderTargetLayer {
            textureRT: "mesherTemp1"; format: "R32F"; width: 2048; height: 1024/2
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles"+efName } // read
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos"+efName } // read
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "mesherTriNorm"+efName } // read
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "mesherTriAdjLeft"+efName } // read
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "mesherTriAdjRight"+efName } // read
        Texture { textureUnit: 5; imageUnit: 5; textureRT: "mesherVertNorm"+efName } // write
        Texture { textureUnit: 6; imageUnit: 6; textureRT: "mesherVertPriTri"+efName } // read
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            ShaderParam { paramName: "div"; paramValue: div }
        }
    }

}
