import QtQuick 2.3

import AdaptDemoSystem 1.0

Effect {
    id: group
    name: "ovl"
    effectName: "Overlay"

    property string file
    property string textureRT
    property int shaderSel: sync(group.name+".blendMode")
    property string shader: {
        if (shaderSel===0) return "fx/_SharedQML/overlay";
        if (shaderSel===1) return "fx/_SharedQML/overlayMul";
        if (shaderSel===2) return "fx/_SharedQML/overlayAdd";
        if (shaderSel===3) return "fx/_SharedQML/overlaySub";
        if (shaderSel===4) return "fx/_SharedQML/overlayScreen";
        return "fx/_SharedQML/overlay";
    }

    property real posX: sync(group.name+".x", 0.0)
    property real posY: sync(group.name+".y", 0.0)
    property real flip: sync(group.name+".flip", 0.0)
    property real overlayAlpha: syncFFT(group.name+".alpha", 1.0)
    property real overlayScale: syncFFT(group.name+".scale", 1.0)

    property string textureWrap: "clamp"

    Blit {
        textureRT: "colorBuffer"
    }
    Shader {
        file: group.shader
    }
    Texture {
        textureUnit: 0
        textureRT: "colorBuffer"
    }

//    Texture {
//        textureUnit: 1
//        textureItem: kuvakuva
//        Image {
//            id: kuvakuva
//            visible: false
//            source: "../../images/"+group.file
//        }
//        textureWrap: group.textureWrap
//    }

    TextureSel { id: ovlTex; textureUnit: 1; name: group.name; textureWrap: sync(group.name+".texClamp", 1.0) > 0.5 ? "clamp" : "repeat" }
    TextureSel { textureUnit: 2; name: group.name; textureWrap: sync(group.name+".thr.texClamp", 0.0) > 0.5 ? "clamp" : "repeat" }
    TextureSel { textureUnit: 3; nameOverride: group.name+".palette.texInd"; textureWrap: sync(group.name+".palette.texClamp", 0.0) > 0.5 ? "clamp" : "repeat" }

    Texture {
        enabled: group.textureRT !== ""
        textureUnit: 1
        textureRT: group.textureRT
    }

    property real palaAmount: sync(group.name+".palaEmitAmp", 0.0)*overlayAlpha

    property real ovlSX: sync(group.name+".scaleX", 1.0)
    property real ovlSY0: sync(group.name+".scaleY", 1.0)
    property real ovlSY: (ovlSY0 == 0.0) ? ovlSX*ovlTex.texHeight/ovlTex.texWidth : ovlSY0



    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: group.flip
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: overlayAlpha
        }
        ShaderParam {
            paramName: "g_overlayScale"
            paramValue: overlayScale
        }
        ShaderParam {
            paramName: "g_posX"
            paramValue: group.posX
        }
        ShaderParam {
            paramName: "g_posY"
            paramValue: group.posY
        }

        ShaderParam { paramName: "g_scaleCX"; paramValue: sync(group.name+".scaleCX", 0.5) }
        ShaderParam { paramName: "g_scaleCY"; paramValue: sync(group.name+".scaleCY", 0.5) }
        ShaderParam { paramName: "g_scaleX"; paramValue: ovlSX }
        ShaderParam { paramName: "g_scaleY"; paramValue: ovlSY }
        ShaderParam { paramName: "g_rot"; syncFFTName: ns("rot"); syncDefault: 0.0 }

        ShaderParam { paramName: "g_thrAmount"; paramValue: sync(group.name+".thrAmount", 0.0) }
        ShaderParam { paramName: "g_thrGain"; paramValue: sync(group.name+".thrGain", 0.0) }
        ShaderParam { paramName: "g_thrWidth"; paramValue: sync(group.name+".thrWidth", 0.0) }
        ShaderParam { paramName: "g_thrBias"; paramValue: syncFFT(group.name+".thrBias", 0.0) }
        ShaderParam { paramName: "g_thrAboveGain"; paramValue: sync(group.name+".thrAboveGain", 0.0) }
        ShaderParam { paramName: "g_thrBelowGain"; paramValue: sync(group.name+".thrBelowGain", 0.0) }

        ShaderParam { paramName: "g_paletteOn"; paramValue: sync(group.name+".palette.ON", 0.0) }
        ShaderParam { paramName: "g_paletteFade"; paramValue: syncFFT(group.name+".palette.fade", 0.0) }
        ShaderParam { paramName: "g_paletteThrFade"; paramValue: syncFFT(group.name+".palette.thrFade", 0.0) }
        ShaderParam { paramName: "g_paletteScale"; paramValue: syncFFT(group.name+".palette.scale", 1.0) }

        ShaderParam { paramName: "g_emitAmp"; paramValue: palaAmount }
        ShaderParam { paramName: "g_emitThr"; paramValue: sync(group.name+".palaEmitThr", 0.0) }

        type: "quad"
        depthTest: false
        depthWrite: false
        drawBuffers: (Math.abs(palaAmount) > 0.001) ? 2 : 1
        drawBufferRT2: "emitBuf"
       //  drawBuffers: 3
        blendMode: "off"
    }


}

