import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "pardex"
  effectName: "Pardex"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;

  property PardexImpl impl: undefined
  Component {
    id: ec
    PardexImpl {}
  }

  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      //log("pardex removed:"+effect.name)
      impl = undefined;
    }
  }
  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        var effectSettings = {
          name: effect.name
        };
        // log("created pardex:"+effect.name)
        impl = ec.createObject(effect, effectSettings);
      }
    }
  }

//  PardexImpl {
//    id: impl
//    name: effect.name
//    enabledIn: effect.enabledIn
//  }
//  Component.onCompleted: {
//    processEnabled(enabled);
//  }
}
