import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: effect
    name: "pixelator"
    enabled: syncRoot(effect.name+".ON");

    Blit { textureRT: "current" }
    Shader { file: "pixelator" }
    Texture { textureUnit: 0; textureRT: "current" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "pixelSize"; paramValue: sync(effect.name+".pixelSize") }
        ShaderParam { paramName: "pixSizeVarAmp"; paramValue: syncFFT(effect.name+".pixelSize.var.amp") }
        ShaderParam { paramName: "pixSizeVarFreqX"; paramValue: sync(effect.name+".pixelSize.var.freqX") }
        ShaderParam { paramName: "pixSizeVarFreqY"; paramValue: sync(effect.name+".pixelSize.var.freqY") }
        ShaderParam { paramName: "pixSizeVarOfsX"; paramValue: sync(effect.name+".pixelSize.var.ofsX") }
        ShaderParam { paramName: "pixSizeVarOfsY"; paramValue: sync(effect.name+".pixelSize.var.ofsY") }

        ShaderParam { paramName: "smoothEnabled"; paramValue: sync(effect.name+".smoothEnabled") }
   }
}
