import QtQuick 2.4

Item {
    property string effectName
    property var presetArrays: []

    property int presetNumber: Math.min(Math.max(0, syncRoot(effectName+"._presetIndex", 0)), presetArrays.length-1)

    function get(track) {
        var pa = presetArrays[presetNumber][track];
        if (pa !== undefined) {
            var staticValue = pa[0];
            if (pa.length === 1) return staticValue;
            if (pa[1] === sync) {
                return sync(effectName+"."+track, staticValue);
            }
            if (pa[1] === syncOsc) {
                return syncOsc(effectName+"."+track, staticValue);
            }
            if (pa[1] === syncFFT) {
                return syncFFT(effectName+"."+track, staticValue);
            }
            if (pa[1] === syncOscFFT) {
                return syncOscFFT(effectName+"."+track, staticValue);
            }
            return staticValue;
        }
        return 0.0;
    }
}
