#version 430

in vec2 uv;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

uniform float g_time;

/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
*/

uniform float flip=1.0;

uniform float overlayAlpha=1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texPrev;

uniform float g_currentAmount = 1.0;
uniform float g_prevAmount = 1.0;

uniform float thr = 0.50;
uniform float loops = 16.0;
uniform float len = 16.0;
uniform float rot = 0.0;
uniform float fallOffExp = 0.0;

uniform float bright = 0.0;
uniform float origBright = 0.0;


vec2 rotateXY(vec2 p, float a) {
    vec2 r = p;
    r.x = cos(a)*p.x - sin(a)*p.y;
    r.y = sin(a)*p.x + cos(a)*p.y;
    return r;
}

void main() {

    vec2 uvS = uv;
    uvS.y = 1.0-uvS.y;

    vec4 screen = texelFetch(tex, ivec2(gl_FragCoord.xy), 0)*origBright;

    vec2 uvo;

    float sx = 1.0/1280.0;


    for (int i=0; i<loops; i++) {
        uvo = vec2(-len*sx*0.5+len*sx*float(i)/loops, 0.0);
        uvo = rotateXY(uvo, rot);
        vec3 s = clamp(texture2D(tex, uvS+uvo).rgb-vec3(thr), 0.0, 128.0);

        float fo = 1.0-abs(float(i)/loops-0.5)*2.0;
        fo = pow(fo, fallOffExp);

        screen.rgb += s*fo*bright/loops;
    }


    screen.a = 1.0;
    frag = screen;
}

