/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.Minim;
import java.util.ArrayList;
import processing.core.PApplet;

public class AliensFix
extends PApplet {
    int rad = 60;
    float xpos;
    float ypos;
    float xspeed = 2.8f;
    float yspeed = 2.2f;
    int xdirection = 1;
    int ydirection = 1;
    int treeAmount = 2000;
    float scale;
    float alienPosX;
    float alienPosY;
    float alienSpeedX;
    float alienSpeedY;
    boolean beamMeUp = false;
    int beamOniter = 42;
    int beamOffIter = 102;
    int iter = 0;
    float alienSpeedboost = 0.0f;
    long startMillis;
    float alienComes = 12.0f;
    float beam1 = 17.6f;
    float beam2 = 26.0f;
    float beam3 = 34.0f;
    float warp = 35.5f;
    float end = 42.0f;
    boolean no1Beam = true;
    boolean no2Beam = true;
    boolean no3Beam = true;
    Minim minim;
    ArrayList<Float> starXs = new ArrayList();
    ArrayList<Float> starYs = new ArrayList();
    ArrayList<Float> starSizes = new ArrayList();
    ArrayList<Float> starHues = new ArrayList();
    int starCount = 1500;

    public void setup() {
        this.randomSeed(0L);
        this.noCursor();
        this.noStroke();
        this.frameRate(60.0f);
        this.ellipseMode(2);
        this.xpos = (float)this.width * 0.7f;
        this.ypos = (float)this.height * 0.2f;
        this.rad = (int)((float)this.width * 0.06f);
        this.setupStars();
        this.scale = (float)this.height / 768.0f;
        this.alienPosX = -100.0f;
        this.alienPosY = (float)this.height / 10.0f;
        this.alienSpeedX = 5.0f;
        this.alienSpeedY = this.random(-5.0f, 20.0f);
        this.minim = new Minim((Object)this);
        this.minim.loadFile("alienNight.mp3").play();
        this.startMillis = this.millis();
    }

    public void draw() {
        this.background(0.0f, 25.0f - AliensFix.min((float)this.timeFromStart(), (float)10.0f), 70.0f - AliensFix.min((float)this.timeFromStart(), (float)15.0f));
        float starAlpha = AliensFix.min((float)1.0f, (float)((this.timeFromStart() - 1.0f) / 10.0f));
        this.drawStars(starAlpha);
        this.xpos = (float)this.width * 0.7f + ((float)(this.width / 4) - (float)(this.width / 4) * AliensFix.min((float)1.0f, (float)(this.timeFromStart() / 10.0f)));
        this.ypos = (float)this.height * 0.2f + ((float)this.height - (float)this.height * AliensFix.min((float)1.0f, (float)(this.timeFromStart() / 10.0f))) / 1.5f;
        float i = 1.0f;
        while (i < 1.3f) {
            int hazeColor = this.color(255.0f, 255.0f, 150.0f + AliensFix.min((float)80.0f, (float)(10.0f * this.timeFromStart())), 7.6499996f);
            this.fill(hazeColor);
            this.ellipse(this.xpos, this.ypos, (float)this.rad * i, (float)this.rad * i);
            i += 0.01f;
        }
        this.randomSeed(0L);
        this.fill(this.color(250.0f, 255.0f, 150.0f + AliensFix.min((float)80.0f, (float)(10.0f * this.timeFromStart()))));
        this.ellipse(this.xpos, this.ypos, this.rad, this.rad);
        int i2 = 0;
        while (i2 < 100) {
            float s = (float)this.rad / this.random(5.0f, 10.0f);
            float an = this.random(0.0f, 360.0f);
            this.fill(this.color(150.0f, 155.0f, 40.0f + AliensFix.min((float)80.0f, (float)(10.0f * this.timeFromStart()))), 12.75f);
            this.ellipse(this.xpos + this.radialCoordX(this.random(10.0f, (float)this.rad / 1.1f), an), this.ypos + this.radialCoordY(this.random(0.0f, (float)this.rad / 1.1f), an), s, s);
            ++i2;
        }
        this.fill(this.color(10.0f, 55.0f - AliensFix.min((float)15.0f, (float)(this.timeFromStart() * 2.0f)), 10.0f));
        this.ellipse(this.width / 2, (float)this.height * 5.7f, this.height * 5, this.height * 5);
        this.fill(this.color(0.0f, 0.0f, 0.0f, 25.5f));
        this.ellipse(this.width / 2, (float)this.height * 5.7f, (float)this.height * 5.05f, (float)this.height * 5.05f);
        float startHeight = (float)this.height / 1.62f;
        float endHeight = this.height + 10;
        float stepsize = (endHeight - startHeight) / (float)this.treeAmount;
        float j = startHeight;
        while (j < endHeight) {
            float crand = this.random(20.0f, 30.0f);
            this.fill(this.color(0.0f, crand, 5.0f));
            float x = this.random(0.0f, this.width);
            float y = j + this.scale * 60.0f * (AliensFix.max((float)x, (float)((float)this.width - x)) / (float)(this.width / 2));
            float size = 10.0f * this.scale + this.random(0.0f, 3.0f);
            this.beginShape();
            int i3 = 90;
            while (i3 < 360) {
                this.vertex(x + this.radialCoordX(size, i3), y + this.radialCoordY(size, i3));
                i3 += 120;
            }
            this.endShape(2);
            this.fill(this.color(0.0f, crand + 1.0f, 0.0f));
            this.beginShape();
            i3 = 90;
            while (i3 < 360) {
                this.vertex(x + this.radialCoordX(size - 1.0f, i3), y - size + this.radialCoordY(size - 1.0f, i3));
                i3 += 120;
            }
            this.endShape(2);
            j += stepsize;
        }
        if (this.timeFromStart() > this.warp) {
            this.alienSpeedboost -= 1.2f;
        }
        if (this.timeFromStart() > this.alienComes) {
            ++this.iter;
            this.alienSpeedX += this.random(-1.0f, 1.0f) + this.alienSpeedboost;
            this.alienSpeedY += this.random(-1.0f, 1.0f);
            if (this.alienSpeedX > 20.0f) {
                this.alienSpeedX = 20.0f + this.alienSpeedboost;
            }
            if (this.alienSpeedX < -20.0f) {
                this.alienSpeedX = -20.0f + this.alienSpeedboost;
            }
            if (this.alienSpeedY > 10.0f) {
                this.alienSpeedY = 10.0f;
            }
            if (this.alienSpeedY < -10.0f) {
                this.alienSpeedY = -10.0f;
            }
            if (this.beamMeUp) {
                this.alienPosX += this.alienSpeedX * this.scale / 10.0f;
                this.alienPosY += this.alienSpeedY * this.scale / 10.0f;
                this.drawAlien(this.alienPosX, this.alienPosY, true, 1.0f);
                if (this.iter >= this.beamOniter) {
                    this.iter = 0;
                    this.beamMeUp = false;
                    if (this.beamOniter < 30 || this.beamOniter > 150) {
                        this.beamOniter = 50;
                    }
                }
            } else {
                this.alienPosX += this.alienSpeedX;
                this.alienPosY += this.alienSpeedY;
                this.drawAlien(this.alienPosX, this.alienPosY, false, 1.0f);
                if (this.timeFromStart() > this.beam1 && this.no1Beam) {
                    this.no1Beam = false;
                    this.iter = 0;
                    this.beamMeUp = true;
                    if (this.beamOffIter < 60 || this.beamOffIter > 450) {
                        this.beamOffIter = 150;
                    }
                }
                if (this.timeFromStart() > this.beam2 && this.no2Beam) {
                    this.no2Beam = false;
                    this.iter = 0;
                    this.beamMeUp = true;
                    if (this.beamOffIter < 60 || this.beamOffIter > 450) {
                        this.beamOffIter = 150;
                    }
                }
                if (this.timeFromStart() > this.beam3 && this.no3Beam) {
                    this.no3Beam = false;
                    this.iter = 0;
                    this.beamMeUp = true;
                    if (this.beamOffIter < 60 || this.beamOffIter > 450) {
                        this.beamOffIter = 150;
                    }
                }
            }
            if (this.alienPosY < 0.0f) {
                AliensFix.abs((float)this.alienPosY);
                this.alienSpeedY += 2.0f;
            }
            if (this.alienPosX < 0.0f) {
                this.alienSpeedX += 5.0f;
            }
            if (this.alienPosY > (float)(this.height / 4)) {
                this.alienSpeedY -= 2.0f;
            }
            if (this.alienPosX > (float)this.width / 4.0f * 3.0f) {
                this.alienSpeedX = -5.0f;
            }
        }
        if (this.timeFromStart() > this.end) {
            this.exit();
        }
    }

    public void drawAlien(float xpos, float ypos, boolean beam, float alpha) {
        int size = this.width / 20;
        if (beam) {
            this.fill(this.color(255.0f, 255.0f, 100.0f + this.random(-30.0f, 30.0f)));
            this.triangle(xpos, ypos, xpos - (float)(size / 5), this.height, xpos + (float)(size / 5), this.height);
            this.fill(this.color(255.0f, 255.0f, 100.0f + this.random(-30.0f, 30.0f)), 102.0f);
            this.triangle(xpos, ypos, xpos - (float)(size / 4), this.height, xpos + (float)(size / 4), this.height);
            this.fill(this.color(255.0f, 255.0f, 100.0f + this.random(-30.0f, 30.0f)), 25.5f);
            this.triangle(xpos - 1.0f, ypos, xpos - (float)(size / 3), this.height, xpos + (float)(size / 5), this.height);
            this.triangle(xpos + 1.0f, ypos, xpos - (float)(size / 5), this.height, xpos + (float)(size / 3), this.height);
            this.fill(this.color(0, 0, 0));
            float osuus = ((float)this.beamOniter - (float)this.iter) / (float)this.beamOniter;
            float matka = (float)this.height - ypos;
            this.ellipse(xpos, ypos + osuus * matka, size / 15, size / 15);
        }
        this.fill(this.color(0, 0, 0), alpha * 255.0f);
        this.ellipse(xpos, ypos, size, size / 2);
        this.ellipse(xpos, ypos, size * 2, size / 4);
        int i = -3;
        while (i < 4) {
            this.fill(this.color(230.0f + 20.0f * AliensFix.sin((float)((float)this.millis() / 100.0f - (float)i)), 230.0f + 20.0f * AliensFix.sin((float)((float)this.millis() / 500.0f + (float)i)), 0.0f));
            this.ellipse(xpos + (float)(size / 3 * i), ypos + (float)(size / 20) * AliensFix.sin((float)((float)this.millis() / 100.0f + (float)i)), size / 10, size / 10);
            ++i;
        }
    }

    public float timeFromStart() {
        return (float)((long)this.millis() - this.startMillis) / 1000.0f;
    }

    public void setupStars() {
        int i = 0;
        while (i < this.starCount / 10 * 9) {
            this.starXs.add(Float.valueOf(this.random(-20.0f, this.width)));
            this.starYs.add(Float.valueOf(this.random(0.0f, this.height)));
            this.starSizes.add(Float.valueOf(AliensFix.max((float)1.0f, (float)(this.randomGaussian() * 3.0f))));
            this.starHues.add(Float.valueOf(this.random(10.0f, 25.0f)));
            ++i;
        }
        i = 0;
        while ((float)i < (float)this.starCount / 10.0f) {
            this.starXs.add(Float.valueOf(this.random(-20.0f, this.width)));
            this.starYs.add(Float.valueOf(this.random(0.0f, this.height)));
            this.starSizes.add(Float.valueOf(AliensFix.max((float)1.0f, (float)(this.randomGaussian() * 5.0f))));
            this.starHues.add(Float.valueOf(this.random(10.0f, 25.0f)));
            ++i;
        }
    }

    public void drawStars(float alphaMult) {
        int i = 0;
        while (i < this.starCount) {
            float x = this.starXs.get(i).floatValue();
            float y = this.starYs.get(i).floatValue();
            float size = this.starSizes.get(i).floatValue();
            float hue = this.starHues.get(i).floatValue();
            this.drawStar(x, y, size, hue, alphaMult);
            x += size * 0.05f;
            if (x > (float)(this.width + 5)) {
                x = -20.0f + this.random(0.0f, 5.0f);
            }
            this.starXs.set(i, Float.valueOf(x));
            ++i;
        }
    }

    public void drawStar(float x, float y, float size, float hue, float alphaMult) {
        this.colorMode(3, 100.0f, 100.0f, 100.0f, 1.0f);
        int starColor = this.color(hue, 50.0f, 100.0f * size, 1.0f * alphaMult);
        this.noStroke();
        if (size > 1.0f) {
            float i = 0.0f;
            while (i < 1.2f) {
                int hazeColor = this.color(0.0f, 0.0f, 100.0f, AliensFix.max((float)0.0f, (float)0.01f) * alphaMult);
                this.fill(hazeColor);
                this.ellipse(x, y, size + size * i, size + size * i);
                i += 0.1f;
            }
        }
        this.fill(starColor);
        this.beginShape();
        int i = 0;
        while (i < 360) {
            this.vertex(x + this.radialCoordX(size, i), y + this.radialCoordY(size, i));
            this.vertex(x + this.radialCoordX(size / 2.0f, i), y + this.radialCoordY(size / 2.0f, i));
            i += 60;
        }
        this.endShape(2);
        this.colorMode(1, 255.0f, 255.0f, 255.0f, 255.0f);
    }

    public float radialCoordX(float radius, float angle) {
        return radius * AliensFix.cos((float)(angle / 360.0f * 2.0f * (float)Math.PI));
    }

    public float radialCoordY(float radius, float angle) {
        return radius * -AliensFix.sin((float)(angle / 360.0f * 2.0f * (float)Math.PI));
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AliensFix"};
        if (passedArgs != null) {
            PApplet.main((String[])AliensFix.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

