/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.sound.SoundFile;

public class sketch_190731a
extends PApplet {
    PGraphics buffer0;
    PGraphics buffer1;
    PGraphics buffer2;
    PGraphics buffer3;
    PImage flameBackground;
    PGraphics canvas;
    int w = 896;
    int h = 504;
    SoundFile music;
    float ystart = 0.0f;
    Metaball[] blobs = new Metaball[8];
    static int radius = 20;
    int startTime;
    ArrayList<Integer> timings;
    ArrayList<Integer> timings2;
    int timer = 0;
    boolean mode = true;
    int lastMillis = 0;

    public void setup() {
        this.init();
        this.buffer0 = this.createGraphics(this.w, this.h);
        this.buffer1 = this.createGraphics(this.w, this.h);
        this.buffer2 = this.createGraphics(this.w, this.h);
        this.buffer3 = this.createGraphics(this.w, this.h);
        this.buffer3.noSmooth();
        this.canvas = this.createGraphics(this.w, this.h, "processing.opengl.PGraphics3D");
        this.flameBackground = this.createImage(this.w, this.h, 1);
        this.colorMode(1);
        int i = 0;
        while (i < this.blobs.length) {
            this.blobs[i] = new Metaball(this.random(this.w), this.random(this.h));
            ++i;
        }
        this.canvas.beginDraw();
        this.canvas.noSmooth();
        this.canvas.background(0);
        this.canvas.endDraw();
        this.music = new SoundFile((PApplet)this, "beat.mp3");
        this.thread("playMusic");
        if (this.startTime == 0) {
            this.delay(1);
        }
    }

    public void playMusic() {
        this.music.play();
        this.startTime = this.millis();
    }

    public void cool() {
        this.flameBackground.loadPixels();
        float xoff = 0.0f;
        float increment = 0.2f;
        int x = 0;
        while (x < this.w) {
            xoff += increment;
            float yoff = this.ystart;
            int y = 0;
            while (y < this.h) {
                float n = this.noise(xoff, yoff += increment);
                float bright = sketch_190731a.pow((float)n, (float)2.0f) * 255.0f;
                this.flameBackground.pixels[x + y * this.w] = this.color(bright);
                ++y;
            }
            ++x;
        }
        this.flameBackground.updatePixels();
    }

    public void metaballsFire(boolean centersOnly) {
        if (centersOnly) {
            this.buffer1.beginDraw();
            this.buffer1.loadPixels();
        } else {
            this.buffer0.beginDraw();
            this.buffer0.loadPixels();
        }
        int x = 0;
        while (x < this.w) {
            int y = 0;
            while (y < this.h) {
                int index = x + y * this.w;
                float sum = 0.0f;
                Metaball[] metaballArray = this.blobs;
                int n = this.blobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Metaball b = metaballArray[n2];
                    float d = sketch_190731a.dist((float)x, (float)y, (float)b.pos.x, (float)b.pos.y);
                    sum += 128.0f * b.r / (d * d / 2.0f);
                    ++n2;
                }
                if (centersOnly && sum > 245.0f) {
                    this.buffer1.pixels[index] = this.color(sum, sum / 2.0f, sum / 4.0f);
                } else if (!centersOnly) {
                    this.buffer0.pixels[index] = this.color(sum * 2.0f, sum, sum / 2.0f);
                }
                ++y;
            }
            ++x;
        }
        if (centersOnly) {
            this.buffer1.updatePixels();
            this.buffer1.endDraw();
        } else {
            this.buffer0.updatePixels();
            this.buffer0.endDraw();
        }
    }

    public void fireballs() {
        this.metaballsFire(true);
        this.metaballsFire(false);
        this.cool();
        this.canvas.beginDraw();
        this.canvas.background(0);
        this.buffer2.beginDraw();
        this.buffer1.loadPixels();
        this.buffer2.loadPixels();
        float newC = 0.0f;
        int x = 1;
        while (x < this.w - 1) {
            int y = 1;
            while (y < this.h - 1) {
                int c1 = this.buffer1.pixels[x + 1 + y * this.w];
                int c2 = this.buffer1.pixels[x - 1 + y * this.w];
                int c3 = this.buffer1.pixels[x + (y + 1) * this.w];
                int c4 = this.buffer1.pixels[x + (y - 1) * this.w];
                int c5 = this.flameBackground.pixels[x + y * this.w];
                newC = this.brightness(c1) + this.brightness(c2) + this.brightness(c3) + this.brightness(c4);
                newC = newC * 0.25f - this.brightness(c5);
                this.buffer2.pixels[x + (y - 1) * this.w] = this.color(newC, newC, newC);
                if (x < 4 || x > this.w - 4 || y < 4 || y > this.h - 4) {
                    this.buffer1.pixels[x + y * this.w] = this.color(0);
                    this.buffer2.pixels[x + y * this.w] = this.color(0);
                }
                ++y;
            }
            ++x;
        }
        this.buffer2.updatePixels();
        this.buffer2.endDraw();
        PGraphics temp = this.buffer1;
        this.buffer1 = this.buffer2;
        this.buffer2 = temp;
        this.canvas.blendMode(256);
        this.canvas.image((PImage)this.buffer0, -1.0f, -1.0f, (float)(this.w + 2), (float)(this.h + 2));
        this.canvas.image((PImage)this.buffer1, -1.0f, -1.0f, (float)(this.w + 2), (float)(this.h + 2));
        this.canvas.blendMode(1);
        this.canvas.endDraw();
    }

    public void metaballsElectric(float r, float g, float b, boolean centersOnly) {
        if (centersOnly) {
            this.buffer1.beginDraw();
            this.buffer1.loadPixels();
            this.buffer1.background(0);
        } else {
            this.buffer0.beginDraw();
            this.buffer0.loadPixels();
        }
        int x = 0;
        while (x < this.w) {
            int y = 0;
            while (y < this.h) {
                int index = x + y * this.w;
                float sum = 0.0f;
                Metaball[] metaballArray = this.blobs;
                int n = this.blobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Metaball blob = metaballArray[n2];
                    float d = sketch_190731a.dist((float)x, (float)y, (float)blob.pos.x, (float)blob.pos.y);
                    sum += 128.0f * blob.r / (d * d / 2.0f);
                    ++n2;
                }
                if (centersOnly && sum > 240.0f) {
                    this.buffer1.pixels[index] = this.color(sum * 4.55f * r, sum * 2.55f / 2.0f * g, sum * 2.55f / 4.0f * b);
                } else if (!centersOnly) {
                    this.buffer0.pixels[index] = this.color(sum * 2.55f * r, sum * 2.55f * g, sum * 2.55f * b);
                } else {
                    this.buffer1.pixels[index] = this.color(0, 0, 0, 0);
                }
                ++y;
            }
            ++x;
        }
        if (centersOnly) {
            this.buffer1.updatePixels();
            this.buffer1.endDraw();
        } else {
            this.buffer0.updatePixels();
            this.buffer0.endDraw();
        }
    }

    public void electricballs() {
        this.buffer3.beginDraw();
        this.metaballsElectric(0.1f, 0.1f, 0.1f, true);
        this.colorMode(1);
        if (this.millis() - this.startTime > 38000 && this.millis() - this.startTime < 42000) {
            this.metaballsElectric(0.6f, 0.4f, 0.7f, false);
        } else {
            this.metaballsElectric(0.0f, 0.6f, 0.7f, false);
        }
        this.buffer3.background(0);
        Metaball[] metaballArray = this.blobs;
        int n = this.blobs.length;
        int n2 = 0;
        while (n2 < n) {
            Metaball b = metaballArray[n2];
            Metaball[] metaballArray2 = this.blobs;
            int n3 = this.blobs.length;
            int n4 = 0;
            while (n4 < n3) {
                Metaball b2 = metaballArray2[n4];
                if (b != b2) {
                    PVector point2;
                    PVector point1;
                    ArrayList<PVector> path = new ArrayList<PVector>();
                    float dist = b.pos.dist(b2.pos);
                    int i = 0;
                    while (i < (int)(3.0f - dist / 120.0f)) {
                        for (PVector v : this.drawJumpingLine(this.getRandomPointsInsideBall(b), this.getRandomPointsInsideBall(b2))) {
                            path.add(v);
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < path.size()) {
                        point1 = (PVector)path.get(i - 1);
                        point2 = (PVector)path.get(i);
                        if (Math.max(400.0f - dist, 0.0f) > 0.0f) {
                            this.buffer3.strokeWeight(12.0f);
                            this.buffer3.stroke(0.0f, 150.0f, 200.0f, sketch_190731a.map((float)Math.max(400.0f - dist, 0.0f), (float)0.0f, (float)400.0f, (float)0.0f, (float)50.0f));
                            this.buffer3.line(point1.x, point1.y, point2.x, point2.y);
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < path.size()) {
                        point1 = (PVector)path.get(i - 1);
                        point2 = (PVector)path.get(i);
                        if (Math.max(350.0f - dist, 0.0f) > 0.0f) {
                            this.buffer3.strokeWeight(6.0f);
                            this.buffer3.stroke(50.0f, 200.0f, 200.0f, sketch_190731a.map((float)Math.max(350.0f - dist, 0.0f), (float)0.0f, (float)400.0f, (float)0.0f, (float)150.0f));
                            this.buffer3.line(point1.x, point1.y, point2.x, point2.y);
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < path.size()) {
                        point1 = (PVector)path.get(i - 1);
                        point2 = (PVector)path.get(i);
                        if (Math.max(350.0f - dist, 0.0f) > 0.0f) {
                            this.buffer3.strokeWeight(2.0f);
                            this.buffer3.stroke(50.0f, 200.0f, 200.0f, sketch_190731a.map((float)Math.max(350.0f - dist, 0.0f), (float)0.0f, (float)400.0f, (float)0.0f, (float)150.0f));
                            this.buffer3.line(point1.x, point1.y, point2.x, point2.y);
                        }
                        ++i;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.buffer3.blendMode(2);
        this.buffer3.image((PImage)this.buffer0, 0.0f, 0.0f);
        this.buffer3.image((PImage)this.buffer1, 0.0f, 0.0f);
        this.buffer3.blendMode(1);
        this.buffer3.endDraw();
        this.canvas.beginDraw();
        this.canvas.image((PImage)this.buffer3, 0.0f, 0.0f);
        this.canvas.endDraw();
    }

    public void draw() {
        this.update();
        this.blendMode(0);
        this.image((PImage)this.canvas, 0.0f, 0.0f, this.width, this.height);
        this.lastMillis = this.millis();
        if (this.lastMillis > 66500) {
            this.exit();
        }
    }

    public void update() {
        int n;
        if (this.timings.size() > 0 && this.timings.get(0) / 1000 * 1000 + this.timings.get(0) / 100 % 10 * 100 <= this.millis() - this.startTime) {
            this.timings.remove(0);
            int i = 0;
            Metaball[] metaballArray = this.blobs;
            int n2 = this.blobs.length;
            n = 0;
            while (n < n2) {
                Metaball b = metaballArray[n];
                if (!this.mode && ++i > this.blobs.length / 2) break;
                ++this.timer;
                if (this.timer % 3 == 0) {
                    b.randomize();
                }
                ++n;
            }
        }
        if (this.timings2.size() > 0 && this.timings2.get(0) <= this.millis() - this.startTime + 200) {
            this.timings2.remove(0);
            this.mode = !this.mode;
            Metaball[] metaballArray = this.blobs;
            n = this.blobs.length;
            int n3 = 0;
            while (n3 < n) {
                Metaball b = metaballArray[n3];
                ++this.timer;
                if (this.timer % 2 == 0) {
                    b.randomize();
                }
                ++n3;
            }
        }
        if (this.millis() - this.startTime > 45000) {
            Metaball[] metaballArray = this.blobs;
            n = this.blobs.length;
            int n4 = 0;
            while (n4 < n) {
                Metaball b = metaballArray[n4];
                b.r -= (float)((this.millis() - this.lastMillis) * 40);
                ++n4;
            }
        }
        if (this.millis() - this.startTime < 7000) {
            Metaball[] metaballArray = this.blobs;
            n = this.blobs.length;
            int n5 = 0;
            while (n5 < n) {
                Metaball b = metaballArray[n5];
                b.r += this.random(2.0f, 10.0f);
                ++n5;
            }
        }
        if (!this.mode) {
            this.fireballs();
        } else {
            this.electricballs();
        }
        Metaball[] metaballArray = this.blobs;
        n = this.blobs.length;
        int n6 = 0;
        while (n6 < n) {
            Metaball b = metaballArray[n6];
            b.update();
            ++n6;
        }
    }

    public float deltaTime() {
        return ((float)this.millis() - (float)this.lastMillis) / 100.0f;
    }

    public ArrayList<PVector> drawJumpingLine(PVector original1, PVector original2) {
        ArrayList<PVector> newPath = new ArrayList<PVector>();
        PVector midPoint = original1.copy().add(original2).mult(0.5f);
        PVector midPoint2 = original1.copy().add(midPoint).mult(0.5f);
        PVector midPoint3 = midPoint.copy().add(original2).mult(0.5f);
        float distance = original1.dist(original2);
        float standardDeviation = 0.06f * distance;
        PVector v = new PVector(this.randomGaussian() * standardDeviation + midPoint.x, this.randomGaussian() * standardDeviation + midPoint.y);
        PVector v3 = new PVector(this.randomGaussian() * standardDeviation + midPoint2.x, this.randomGaussian() * standardDeviation + midPoint2.y);
        PVector v4 = new PVector(this.randomGaussian() * standardDeviation + midPoint3.x, this.randomGaussian() * standardDeviation + midPoint3.y);
        newPath.add(original1);
        newPath.add(v3);
        newPath.add(v);
        newPath.add(v4);
        newPath.add(original2);
        return newPath;
    }

    public PVector getRandomPointsInsideBall(Metaball b) {
        float r = b.r / 500.0f;
        float theta1 = this.randomGaussian() * (float)Math.PI / 4.0f;
        PVector v1 = new PVector(b.pos.x + r * sketch_190731a.cos((float)theta1), b.pos.y + r * sketch_190731a.sin((float)theta1));
        return v1;
    }

    public void init() {
        this.timings = new ArrayList();
        this.timings2 = new ArrayList();
        this.timings.add(4582);
        this.timings.add(5332);
        this.timings.add(6061);
        this.timings.add(6819);
        this.timings.add(7497);
        this.timings.add(8250);
        this.timings.add(8966);
        this.timings.add(9689);
        this.timings.add(10412);
        this.timings.add(11177);
        this.timings.add(11863);
        this.timings.add(12621);
        this.timings.add(13304);
        this.timings.add(14066);
        this.timings.add(14778);
        this.timings.add(15534);
        this.timings.add(16210);
        this.timings.add(16963);
        this.timings.add(17639);
        this.timings.add(18431);
        this.timings.add(19108);
        this.timings.add(19859);
        this.timings.add(20612);
        this.timings.add(21287);
        this.timings.add(22043);
        this.timings.add(22838);
        this.timings.add(23519);
        this.timings.add(24238);
        this.timings.add(24951);
        this.timings.add(25702);
        this.timings.add(26382);
        this.timings.add(27138);
        this.timings.add(27855);
        this.timings.add(28571);
        this.timings.add(29324);
        this.timings.add(30073);
        this.timings.add(30748);
        this.timings.add(31542);
        this.timings.add(32223);
        this.timings.add(32937);
        this.timings.add(33725);
        this.timings.add(34481);
        this.timings.add(35199);
        this.timings.add(35875);
        this.timings.add(36561);
        this.timings.add(37383);
        this.timings.add(38056);
        this.timings.add(38775);
        this.timings.add(39494);
        this.timings.add(40242);
        this.timings.add(40953);
        this.timings.add(41669);
        this.timings.add(42383);
        this.timings.add(43143);
        this.timings.add(43899);
        this.timings.add(44577);
        this.timings.add(45331);
        this.timings.add(46091);
        this.timings.add(46853);
        this.timings.add(47526);
        this.timings.add(48270);
        this.timings.add(49052);
        this.timings.add(49823);
        this.timings.add(50595);
        this.timings.add(51367);
        this.timings.add(52176);
        this.timings.add(52943);
        this.timings.add(53744);
        this.timings.add(54543);
        this.timings.add(55382);
        this.timings.add(56157);
        this.timings.add(57007);
        this.timings.add(57848);
        this.timings.add(58689);
        this.timings.add(59529);
        this.timings2.add(7450);
        this.timings2.add(13331);
        this.timings2.add(17770);
        this.timings2.add(17917);
        this.timings2.add(18103);
        this.timings2.add(18250);
        this.timings2.add(18476);
        this.timings2.add(18625);
        this.timings2.add(18810);
        this.timings2.add(18969);
        this.timings2.add(19158);
        this.timings2.add(19359);
        this.timings2.add(19520);
        this.timings2.add(19729);
        this.timings2.add(19914);
        this.timings2.add(20100);
        this.timings2.add(20249);
        this.timings2.add(20452);
        this.timings2.add(20634);
        this.timings2.add(23552);
        this.timings2.add(23740);
        this.timings2.add(23890);
        this.timings2.add(24076);
        this.timings2.add(24283);
        this.timings2.add(24439);
        this.timings2.add(24628);
        this.timings2.add(24795);
        this.timings2.add(24981);
        this.timings2.add(25170);
        this.timings2.add(25356);
        this.timings2.add(25543);
        this.timings2.add(25702);
        this.timings2.add(25877);
        this.timings2.add(26057);
        this.timings2.add(26241);
        this.timings2.add(26441);
        this.timings2.add(29367);
        this.timings2.add(29521);
        this.timings2.add(29703);
        this.timings2.add(29896);
        this.timings2.add(30080);
        this.timings2.add(30273);
        this.timings2.add(30463);
        this.timings2.add(30599);
        this.timings2.add(30786);
        this.timings2.add(30976);
        this.timings2.add(31159);
        this.timings2.add(31351);
        this.timings2.add(31502);
        this.timings2.add(31691);
        this.timings2.add(31877);
        this.timings2.add(32075);
        this.timings2.add(32275);
        this.timings2.add(35137);
        this.timings2.add(35361);
        this.timings2.add(35510);
        this.timings2.add(35706);
        this.timings2.add(35915);
        this.timings2.add(36097);
        this.timings2.add(36281);
        this.timings2.add(36458);
        this.timings2.add(36645);
        this.timings2.add(36830);
        this.timings2.add(37017);
        this.timings2.add(37173);
        this.timings2.add(37335);
        this.timings2.add(37503);
        this.timings2.add(37670);
        this.timings2.add(37862);
        this.timings2.add(38062);
        this.timings2.add(40958);
        this.timings2.add(41162);
        this.timings2.add(41327);
        this.timings2.add(41507);
        this.timings2.add(41694);
        this.timings2.add(41882);
        this.timings2.add(42067);
        this.timings2.add(42239);
        this.timings2.add(42442);
        this.timings2.add(42622);
        this.timings2.add(42804);
        this.timings2.add(42966);
        this.timings2.add(43151);
        this.timings2.add(43340);
        this.timings2.add(43526);
        this.timings2.add(43684);
        this.timings2.add(43884);
        this.timings2.add(50000);
        this.timings2.add(53000);
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"sketch_190731a"};
        if (passedArgs != null) {
            PApplet.main((String[])sketch_190731a.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Metaball {
        PVector pos;
        float r;
        PVector vel;

        Metaball(float x, float y) {
            this.pos = new PVector(x, y);
            this.vel = PVector.random2D();
            this.vel.mult(sketch_190731a.this.random(1.0f, 3.0f));
            this.r = sketch_190731a.this.random(0.0f, 0.0f);
        }

        public void randomize() {
            float size = sketch_190731a.this.millis() <= 30000 ? sketch_190731a.map((float)sketch_190731a.this.millis(), (float)0.0f, (float)30000.0f, (float)500.0f, (float)1500.0f) : sketch_190731a.map((float)sketch_190731a.this.millis(), (float)30000.0f, (float)60000.0f, (float)1500.0f, (float)500.0f);
            if (sketch_190731a.this.mode) {
                size /= 4.0f;
            }
            this.r = sketch_190731a.this.random(size, size + 3000.0f);
            this.vel = PVector.random2D();
            float speed = sketch_190731a.this.millis() <= 30000 ? sketch_190731a.map((float)sketch_190731a.this.millis(), (float)0.0f, (float)30000.0f, (float)3.0f, (float)20.0f) : sketch_190731a.map((float)sketch_190731a.this.millis(), (float)30000.0f, (float)60000.0f, (float)20.0f, (float)10.0f);
            this.vel.mult(sketch_190731a.this.random(speed, speed * 1.3f));
        }

        public void update() {
            this.pos.add(this.vel.copy().mult(sketch_190731a.this.deltaTime()));
            if (this.pos.x > (float)sketch_190731a.this.w || this.pos.x < 0.0f) {
                this.vel.x *= -1.0f;
                this.pos.x = this.pos.x > (float)sketch_190731a.this.w ? (float)sketch_190731a.this.w : 0.0f;
            }
            if (this.pos.y > (float)sketch_190731a.this.h || this.pos.y < 0.0f) {
                this.vel.y *= -1.0f;
                this.pos.y = this.pos.y > (float)sketch_190731a.this.h ? (float)sketch_190731a.this.h : 0.0f;
            }
        }

        public void show() {
            sketch_190731a.this.canvas.noFill();
            sketch_190731a.this.canvas.stroke(0);
            sketch_190731a.this.canvas.strokeWeight(4.0f);
            sketch_190731a.this.canvas.ellipse(this.pos.x, this.pos.y, this.r * 2.0f, this.r * 2.0f);
        }
    }
}

