#version 430 core

uniform float aspect;
uniform float time;
uniform float time_max;

in vec2 uv;
out vec4 out_color;

void main()
{
	float density = 0;


	for (int i = 0; i < 24; ++i)
	{
		float it = float(i) / 24.0 * 10.0;

		vec2 p = vec2(uv.x * aspect, uv.y);
		p.x = p.x + sin(time * 2 + it) * 0.25 + cos(time * 3);
		p.y = p.y + cos(time * 5 + it) * 0.25 + sin(time * 4);
	
		float distance = length(p);
		if (distance < 0.25)
			density += 1.0/24.0;
	}

	out_color = vec4(density, density, density, 1);
}
