import moonlander.library.*;

import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;

int CANVAS_WIDTH = 640;
int CANVAS_HEIGHT = 360;


int BPM = 140;

boolean ENTRY_MODE = true;

Moonlander moonlander;

void settings() {
  if (ENTRY_MODE) {
    fullScreen(P2D);
  } else {
    size(CANVAS_WIDTH, CANVAS_HEIGHT, P2D);
  }
}

void setup() {
  frameRate(60);
  moonlander = Moonlander.initWithSoundtrack(this, "assembly-2019-one-scene-compo.mp3", BPM, 8);


  if (ENTRY_MODE) {
    noCursor();
    moonlander.start("localhost", 1338, "data/assembly-2019-one-scene-compo.rocket");
  } else {
    moonlander.start("localhost", 1338, "data/assembly-2019-one-scene-compo.rocket");
  }
}

void xboxes() {
  stroke(255);
  strokeWeight(5);
  float leftX = -100;
  float rightX = 0;
  float bottomY = 450;  
  int numberOfCross = 10;
  float crossHeight = 100;

  //line(leftX,topY,leftX,bottomY);
  //line(rightX,topY,rightX,bottomY);
  for (int i = 0; i <numberOfCross; i++) {
    rectMode(CORNERS);
    noFill();
    rect(leftX, bottomY-i*crossHeight, rightX, bottomY);


    line(leftX, bottomY-i*crossHeight, rightX, bottomY-(i+1)*crossHeight);
    line(leftX, bottomY-i*crossHeight, rightX, bottomY-i*crossHeight);
    line(rightX, bottomY-i*crossHeight, leftX, bottomY-(i+1)*crossHeight);
    line(leftX, bottomY-(i+1)*crossHeight, rightX, bottomY-(i+1)*crossHeight);
  }
}

void kurki(float x, float y) {
  pushMatrix();
  translate(x, y);
  scale(1.4);
  stroke(255);
  strokeWeight(3);
  ellipse(0, 0, 100, 80);
  line(-10, 10, 50, 80);
  line(10, 10, -50, 80);

  line(-30, 0, -80, -40); 
  line(-30, -30, -80, -40);
  stroke(0);
  circle(-10, -10, 20);
  popMatrix();
}

void scene3() {
  float pos = (float)moonlander.getValue("change");

  strokeWeight(5);
  stroke(100);
  line(500, pos, 500, -250);

  noStroke();
  fill(255);
  kurki(500,pos);
  //circle(500, pos, 100);
}

void scene2() {
  float pos = (float)moonlander.getValue("change");

  strokeWeight(5);
  stroke(100);
  line(500, pos, 500, -250);
}

void scene1() {
  xboxes();
  pushMatrix();

  rotate(0.5*PI);
  translate(-200, 0);

  xboxes();
  popMatrix();

  //hide extra triangle (was faster just this way :D)
  fill(0);
  noStroke();
  rect(500, -500, 600, 400);
}

void draw() {
  background(0);
  moonlander.update();
  float time = (float) moonlander.getCurrentTime();

  //resolution independent scaling
  translate(width/2, height/2);
  scale(height / 1000.0);

  int scene = moonlander.getIntValue("scene");


  if (scene == 1) {
    scene1();
    float change = (float) moonlander.getValue("change");
    noStroke();
    fill(0);
    rect(-800, change, 800, -800);
  }

  if (scene == 2) {
    scene1();
    scene2();
  }

  if (scene == 3) {
    scene1();
    scene3();
  }

  //if (scene == 4) {
  //}


  if (scene == 100) {
    exit();
  }

  println(time);
}
