//import moonlander.library.*;

//import ddf.minim.*;

import processing.sound.*;

SoundFile file;
String audioName = "2.mp3";
String path;

int opac = 0;
int index1 = 0;

void setup() {
  background(255);
  fullScreen();
  smooth();
  noStroke();
  frameRate(60);
  path = sketchPath(audioName);
  file = new SoundFile(this, path);
  file.play();
}

void quitter() {
  if (frameCount >= 1800) {
    System.exit(0);
  }
}  

void spinner() {
  if (frameCount % 10 == 0) {
    
    if (frameCount > 90) {
      opac = opac + 20;
      if (opac > 255) {
        opac = 255;
      }
    }
    
    float r = (frameCount * 3 % 255);
    float g = (frameCount * 5 % 255);
    float b = (frameCount * 7 % 255);
    
    fill(r, g, b, opac);
    
    pushMatrix();
    translate(width/2, height/2);
    rotate(radians(frameCount * 2  % 360));
    rect(0, 0, (width*0.15), (height*0.03));
    popMatrix();
  }
}

void texterCols() {
  float r = (height/2-(height*0.175));
  String msg1 = "Magnificent coder colors!!!";
  fill(0);
  textSize((width*0.03));
  textAlign(CENTER);
  
  float arcLen = 0;
  
  if (frameCount % 30 == 0) {
    translate(width/2, height/2);
    for (int i = 0; i < msg1.length(); i++) {
      char j = msg1.charAt(i);
      float w = textWidth(j);
      arcLen += w;
      float theta = PI + arcLen / r;
      
      pushMatrix();
      translate(r*cos(theta), r*sin(theta));
      rotate(theta+PI/2); // rotation is offset by 90 degrees
      fill(0);
      text(j,0,0);
      popMatrix();
      arcLen += w/2;
    }
  }
}
  

void draw(){
  spinner();
  quitter();
  texterCols();
}
