/*
 * This is a stripped down starter code for the
 * Assembly Summer 2019 Demo Coding Workshop
 * The original invitation code is very educational:
 * https://github.com/mrautio/graffathon19-demo-one-scene 
 */

// We suggest you use these libraries (and no others):
// Moonlander is a library for integrating Processing with GNU Rocket, https://github.com/anttihirvonen/moonlander
// GNURocket is a tool for synchronizing music and visuals in demoscene productions: https://github.com/rocket/rocket
import moonlander.library.*;
// Audio library for playing sound, http://code.compartmental.net/minim/
import ddf.minim.*;

// Some demo global variables 

// the time in seconds (will be taken from Moonlander / GNURocket every frame)
float now = 0.0;

// These control how big the opened window is.
// But you don't need not change these to develop in a smaller window!
// In fact, DON'T CHANGE THESE. They are optimal for Assembly 2019 Compo.
// ref. https://www.assembly.org/summer19/demoscene/rules
float CANVAS_WIDTH = 1920;
float CANVAS_HEIGHT = 1080;
PImage manda;

float rotx = PI/4;
float roty = PI/4;

int pal []=new int [128];
int[] cls;

PFont font;

String[] texts = {
 "Be primitive",
 "Vote for your great entry",
 "(not this one hopefully)"
};

Moonlander moonlander;

/*
 * Initialize the window
 */
void settings() {
  boolean fullscreen = true;
  
  if (fullscreen) {
    //Set the window fullscreen in desktop's native resolution
    fullScreen(P3D);
  } else {
    //open in a smaller window
    //Put some 16:9 aspect ratio resolution
    //like 800x450... do not edit CANVAS_WIDTH or CANVAS_HEIGHT
    size((int)800,(int)450, P3D);
  }
}

/*
 * Set up, and load all assets in the demo.
 * Make sure you include everything in the "data/" directory 
 * with your entry, and that the license of each asset allows
 * you to use it in this compo!
 */
void setup() {
  // Font
  font = createFont("Inter-ExtraLight-BETA.ttf", 200);

  
  
    // Plasma
  float s1,s2;
  for (int i=0;i<128;i++) {
    s1=sin(i*PI/25);
    s2=sin(i*PI/50+PI/4);
    pal[i]=color(128+s1*128,32+s2*64,s1*128);
  }

  cls = new int[width*height];
  for (int x = 0; x < width; x++)
  {
    for (int y = 0; y < height; y++)
    {
      cls[x+y*width] = (int)((127.5 + +(127.5 * sin(x / 32.0)))+ (127.5 + +(127.5 * cos(y / 32.0))) + (127.5 + +(127.5 * sin(sqrt((x * x + y * y)) / 32.0)))  ) / 4;
    }
  }

  
  
  
  // hide mouse cursor; you want to do this.
  noCursor();

  
  // Assembly has 60Hz maximum projector framerate, ref. https://www.assembly.org/summer19/demoscene/rules
  int fps = 60;
  frameRate(fps);  
  
  manda = loadImage("data/Manda_Texture.png");
  
  textureMode(NORMAL);
  fill(255);
  stroke(color(44,48,32));
  
  
   // Init & start moonlander
  int bpm = 93; // Tune's beats per minute
  int rowsPerBeat = 4; // How many rows one beat consists of in the sync editor (GNURocket or so)
  moonlander = Moonlander.initWithSoundtrack(this, "combined.wav", bpm, rowsPerBeat);
  moonlander.start();  
}


void drawPlasma()
{
  if ((int)moonlander.getValue("bg:plasma") == 1) {
    loadPixels();
    for (int pixelCount = 0; pixelCount < cls.length; pixelCount++)
    {                    
      pixels[pixelCount] =  pal[(cls[pixelCount] + (int)(now*60))&127];
    }
    updatePixels();
  }
}








void drawManda() {
  pushMatrix();
  fill(255);
  noStroke();
  // strokeWeight(1);
  translate((float)moonlander.getValue("cube:x"), (float)moonlander.getValue("cube:y"));
  rotateX((float)moonlander.getValue("cube:rot_x"));
  rotateY((float)moonlander.getValue("cube:rot_y"));
  scale((float)moonlander.getValue("cube:scale"));
  TexturedCube(manda);
  popMatrix();
}

void TexturedCube(PImage tex) {
  beginShape(QUADS);
  texture(tex);

  // Given one texture and six faces, we can easily set up the uv coordinates
  // such that four of the faces tile "perfectly" along either u or v, but the other
  // two faces cannot be so aligned.  This code tiles "along" u, "around" the X/Z faces
  // and fudges the Y faces - the Y faces are arbitrarily aligned such that a
  // rotation along the X axis will put the "top" of either texture at the "top"
  // of the screen, but is not otherwised aligned with the X/Z faces. (This
  // just affects what type of symmetry is required if you need seamless
  // tiling all the way around the cube)
  
  // +Z "front" face
  vertex(-1, -1,  1, 0, 0);
  vertex( 1, -1,  1, 1, 0);
  vertex( 1,  1,  1, 1, 1);
  vertex(-1,  1,  1, 0, 1);

  // -Z "back" face
  vertex( 1, -1, -1, 0, 0);
  vertex(-1, -1, -1, 1, 0);
  vertex(-1,  1, -1, 1, 1);
  vertex( 1,  1, -1, 0, 1);

  // +Y "bottom" face
  vertex(-1,  1,  1, 0, 0);
  vertex( 1,  1,  1, 1, 0);
  vertex( 1,  1, -1, 1, 1);
  vertex(-1,  1, -1, 0, 1);

  // -Y "top" face
  vertex(-1, -1, -1, 0, 0);
  vertex( 1, -1, -1, 1, 0);
  vertex( 1, -1,  1, 1, 1);
  vertex(-1, -1,  1, 0, 1);

  // +X "right" face
  vertex( 1, -1,  1, 0, 0);
  vertex( 1, -1, -1, 1, 0);
  vertex( 1,  1, -1, 1, 1);
  vertex( 1,  1,  1, 0, 1);

  // -X "left" face
  vertex(-1, -1, -1, 0, 0);
  vertex(-1, -1,  1, 1, 0);
  vertex(-1,  1,  1, 1, 1);
  vertex(-1,  1, -1, 0, 1);

  endShape();
}








/*
 * Draw compo information and greetings texts
 */
void drawText() {
  if (moonlander.getValue("font:text") >= 0) {
    pushMatrix();
    scale((float)moonlander.getValue("font:scale"));
    textAlign(CENTER, CENTER);
    textFont(font);
    fill((int)(moonlander.getValue("font:r") * 255),(int)(moonlander.getValue("font:g") * 255),(int)(moonlander.getValue("font:b") * 255),(int)(moonlander.getValue("font:a") * 255));
    text(texts[(int)moonlander.getValue("font:text")%texts.length], (int)moonlander.getValue("font:x"), (int)moonlander.getValue("font:y"));
    popMatrix();
  }
}

/*
 * This function is called every time a screen is drawn, ideally that would be 60 times per second
 */
void draw() {
  // update Rocket sync data  
  moonlander.update();

  now = (float)moonlander.getCurrentTime();
  float end = 60.0; //end production after 60 secs which is the maximum time allowed by the One Scene Compo
  // ((int)moonlander.getValue("exit:exit") == 1)
  if (now > end || (((int)moonlander.getValue("exit:exit") == 1)) && true) {
    exit();
  }
  
  // Set the background color
  background((int)(moonlander.getValue("bg:r") * 255),
             (int)(moonlander.getValue("bg:g") * 255),
             (int)(moonlander.getValue("bg:b") * 255),
             (int)(moonlander.getValue("bg:a") * 255));
  
  /*
   * Center coordinates to screen and make the window and canvas resolution independent
   * This is because actual window in full screen on a 4K monitor has more pixels than FullHD resolution
   * so scaling is needed to ensure that all objects (3D and 2D) are in correct places regardless of the desktop resolution
   */
  translate(width/2, height/2, 0);
  scale(width/CANVAS_WIDTH,height/CANVAS_HEIGHT,width/CANVAS_WIDTH);

  // Enable lights and depth testing to ensure that 3D meshes are drawn in correct order
  lights();
  hint(ENABLE_DEPTH_TEST);

  rotx = (now / 2) * PI;
  
  drawPlasma();
  drawManda();
  drawText();
}
