// Set the scene size.
const WIDTH = window.innerWidth;
const HEIGHT = window.innerHeight;

// Set some camera attributes.
const VIEW_ANGLE = 45;
const ASPECT = WIDTH / HEIGHT;
const NEAR = 0.1;
const FAR = 10000;

// Get the DOM element to attach to
const container =
    document.querySelector('#container');

// Create a WebGL renderer, camera
// and a scene
const renderer = new THREE.WebGLRenderer();
const camera =
    new THREE.PerspectiveCamera(
        VIEW_ANGLE,
        ASPECT,
        NEAR,
        FAR
    );

const scene = new THREE.Scene();

// Add the camera to the scene.
scene.add(camera);

// Start the renderer.
renderer.setSize(WIDTH, HEIGHT);

// Attach the renderer-supplied
// DOM element.
container.appendChild(renderer.domElement);

// create a point light
const pointLight =
  new THREE.PointLight(0xFFFFFF);

// set its position
pointLight.position.x = 10;
pointLight.position.y = 50;
pointLight.position.z = 130;

// add to the scene
scene.add(pointLight);

scene.background = new THREE.Color( 0x000000 );
scene.fog = new THREE.Fog( 0x000000, 250, 1400 );

const textMaterial = new THREE.MeshLambertMaterial( { color: 0x282828 });

const fragmentShader = `
uniform float time;
// uniform out vec4 fragColor;

void main(void) {
{
  float s = sin(time);
  gl_FragColor = vec4(s,s,s,1.0);
}
`;

const uniforms = {
  time: { type: "f", value: 1.0 }
};

const shaderMaterial = new THREE.ShaderMaterial({
  fragmentShader: fragmentShader
});

const loader = new THREE.FontLoader();
let mesh;

loader.load('helvetiker_bold.typeface.json', function ( font ) {
	const geometry = new THREE.TextGeometry('V', {
		font: font,
		size: 160,
		height: 50,
	} );

  geometry.computeBoundingBox();
  geometry.computeVertexNormals();

  mesh = new THREE.Mesh(geometry,textMaterial);
  //mesh = new THREE.Mesh(geometry,shaderMaterial);

  //mesh.position.x = window.innerWidth
  //mesh.position.y = 0;
  mesh.position.x = -100;
  mesh.position.y = -90;
  mesh.position.z = -300;
  
  scene.add(mesh);

  requestAnimationFrame(update);
} );

const multiplier = 0.8;

function update () {
  textMaterial.color.setScalar(Math.cos(new Date()) * multiplier)
  renderer.render(scene,camera);
  requestAnimationFrame(update);
}

function onWindowResize() {
  windowHalfX = window.innerWidth / 2;
  camera.aspect = window.innerWidth / window.innerHeight;
  camera.updateProjectionMatrix();
  renderer.setSize( window.innerWidth, window.innerHeight );
}
