#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat) + 2.;
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

void main()
{
float audio1 = max(0.0, (0.1 - fract(((beats * 4.0) + 0.04))));
float audio2 = max(0.0, (0.1 - fract((((beats * 4.0) + 0.05) - 0.4))));
float audio3 = (step(1.5, (fract((beats / 2.0)) * 2.0)) - step(8.0, (fract((beats / 2.0)) * 2.0)));
vec2 uv = fsin_Position;
uv = vec2((uv.x + (audio1 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio2 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio3 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = ((uv / 2.0) - Offset);
uv = (uv * (1.0 + (Zoom * Zoom)));
vec3 c = vec3(0.0);
vec3 r = vec3(0.68, 0.18, 0.14);
vec3 g = vec3(0.87, 0.89, 0.78);
vec3 b = vec3(0.0, 0.6, 0.96);
float l = clamp(pR((uv * 1.5), (round((max((tan(length(vec2((max((tan((((-(-length(vec2((floor((smoothstep((pR((uv * 1.5), (floor((length(vec2(((-max((round((cos(smoothstep(sin(((floor((length(vec2(pR((uv * 1.5), length(vec2(cos((-max(smoothstep(max((length(vec2((pR((uv * 1.5), (round((pR((uv * 1.5), pR((uv * 1.5), ((-(pR((uv * 1.5), (tan(pR((uv * 1.5), smoothstep(pR((uv * 1.5), (-smoothstep(length(vec2(max(smoothstep(smoothstep(sin(((-max(length(vec2((floor((((-((max(max((pR((uv * 1.5), (tan((((sin(length(vec2(cos(sin((round((((length(vec2((tan((floor((pR((uv * 1.5), ((cos(((floor((cos(cos((round((max((length(vec2(smoothstep(length(vec2((smoothstep(((length(vec2(((-smoothstep(max(max((floor(((round((cos(max(pR((uv * 1.5), (tan((round((max(length(vec2(pR((uv * 1.5), (round((((cos((-(-(((-pR((uv * 1.5), (round((max(length(vec2(cos((length(vec2(pR((uv * 1.5), (pR((uv * 1.5), pR((uv * 1.5), (tan((tan((round((sin((sin((floor((smoothstep(pR((uv * 1.5), cos((((floor(((sin((sin(max(max((tan(pR((uv * 1.5), length(vec2(max(pR((uv * 1.5), (cos(cos(length(vec2((round(((length(vec2((tan(pR((uv * 1.5), pR((uv * 1.5), (max(max(length(vec2(((length(vec2(max(max((length(vec2(((-(((tan(length(vec2(cos(length(vec2((smoothstep((cos(length(vec2((floor((cos(max((max(length(vec2(pR((uv * 1.5), max(smoothstep(max(length(vec2(cos((round(((round(((pR((uv * 1.5), sin((-sin((max(sin(length(vec2(length(vec2((max(length(vec2(length(vec2((round((((floor(((floor(((tan(((length(vec2(pR((uv * 1.5), max(max(((smoothstep((sin(length(vec2((-(-((floor((((round((((cos(((floor((max((pR((uv * 1.5), cos((round((max(sin((-length(vec2((round((sin(smoothstep((tan((cos(max((floor((smoothstep((tan(pR((uv * 1.5), max(smoothstep((floor((cos((tan(max(((length(vec2((round(((pR((uv * 1.5), (tan((tan(cos((tan(pR((uv * 1.5), ((pR((uv * 1.5), (pR((uv * 1.5), (smoothstep(length(vec2(length(vec2(pR((uv * 1.5), (max((floor((max((tan((round((cos((pR((uv * 1.5), smoothstep((floor(((length(vec2((((round((length(vec2((round((smoothstep(max(length(vec2((-(tan((cos(max(((((round((((tan(((max(((floor(((smoothstep((tan((((floor((length(vec2(max((-smoothstep(((round(((pR((uv * 1.5), length(vec2((floor((length(vec2(sin((floor((smoothstep(max(cos(cos((-pR((uv * 1.5), sin(length(vec2(max((floor(((round((max(pR((uv * 1.5), pR((uv * 1.5), (pR((uv * 1.5), max(length(vec2((pR((uv * 1.5), ((tan(length(vec2((tan(((floor(((sin((cos(cos(((round((length(vec2((sin(max(((max(smoothstep(length(vec2((sin(max((cos((max((-(length(vec2(max(max((pR((uv * 1.5), (floor(((round((smoothstep(pR((uv * 1.5), pR((uv * 1.5), max(cos(((smoothstep(((floor((((((smoothstep(smoothstep(max(length(vec2(max(length(vec2((floor(((floor((max(smoothstep(sin(sin((-(max((pR((uv * 1.5), ((tan(cos((round((max(max(length(vec2((floor((((max((length(vec2(audio2, (uv.x * 10.0))) - audio2), (uv.y * 8.0)) + 3.1416) - 4.0) * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25)))), (uv.x * 2.0)), (uv.y * 1.5)) * 7.0)) / 7.0))) / 2.0) + 3.1416)).x + (length(uv) * 10.0)), (uv.x * 2.0)) - (uv.x * 2.0))))), 0.0, 0.1), audio2) * 7.0)) / 7.0) * 7.0)) / 7.0), (uv.x * 2.0))), audio2), (sin(((beats * 1.57) * 0.5)) * 4.0))), (tan(((beats * 3.14) * 0.5)) / 2.0)), 0.0, 0.1), 0.0, 0.1) + audio1) + (sin(((beats * 1.57) * 0.5)) * 4.0)) - 3.1416) - audio2) * 7.0)) / 7.0) + (uv.x * 2.0)), 0.0, 0.1) + audio1) - sin(((beats * 1.57) * 0.25)))), (uv.y * 8.0))).x).x, 0.0, 0.1) * 7.0)) / 7.0) * 7.0)) / 7.0)).x - (uv.y * 1.5)), 4.0), (length(uv) * 10.0)), 4.0)) + (uv.y * 1.5))), (tan(((beats * 3.14) * 0.5)) / 2.0)) + audio2)) - (uv.y * 8.0)), sin(((beats * 1.57) * 0.25)))) + sin(((beats * 1.57) * 0.25))), audio3)), 0.0, 0.1), (uv.x * 10.0)) - (length(uv) * 10.0)) - sin(((beats * 1.57) * 0.25))), sin(((beats * 1.57) * 0.25)))) - sin(((beats * 1.57) * 0.25))), (sin(((beats * 1.57) * 0.5)) * 4.0))) * 7.0)) / 7.0) + (uv.x * 2.0)))) - sin(((beats * 1.57) * 0.25)))) - (uv.x * 10.0)) * 7.0)) / 7.0) - 4.0)) / 2.0), (uv.y * 1.5)))) / 2.0) + (length(uv) * 10.0))).x - 3.1416), audio2)), (length(uv) * 10.0))).y + (tan(((beats * 3.14) * 0.5)) / 2.0))).x).x, audio1) * 7.0)) / 7.0) * 7.0)) / 7.0), audio3), audio2)))).y))), audio2), 0.0, 0.1) * 7.0)) / 7.0)), sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0), (uv.y * 1.5)))).y - (uv.y * 8.0)) * 7.0)) / 7.0) - 3.1416), 0.0, 0.1)), (length(uv) * 10.0)), sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0) - 3.1416) + audio3)) / 2.0), 0.0, 0.1) + audio2) * 7.0)) / 7.0) + (uv.x * 10.0)), audio2) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + (uv.x * 2.0))) / 2.0) - 3.1416) * 7.0)) / 7.0) + audio1) - (uv.x * 2.0)) + (uv.x * 10.0)), (length(uv) * 10.0))) - (sin(((beats * 1.57) * 0.5)) * 4.0))) / 2.0)), (length(uv) * 10.0))), 4.0), 0.0, 0.1) * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0) + audio3) + audio3), (uv.y * 8.0))) - audio1) * 7.0)) / 7.0), 0.0, 0.1)).y + audio2)) * 7.0)) / 7.0)) / 2.0), sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0), (length(uv) * 10.0)) + (sin(((beats * 1.57) * 0.5)) * 4.0))).y, (tan(((beats * 3.14) * 0.5)) / 2.0))), audio1)), 0.0, 0.1) - 4.0)).y - 4.0)).x - (uv.x * 2.0)) - audio1)).x) / 2.0))) / 2.0)) / 2.0)).y - audio3) * 7.0)) / 7.0), (uv.x * 10.0))) - (sin(((beats * 1.57) * 0.5)) * 4.0)) - (length(uv) * 10.0)), audio3)) / 2.0)) * 7.0)) / 7.0), 0.0, 0.1), audio2)).y) / 2.0), 0.0, 0.1) * 7.0)) / 7.0), (uv.y * 8.0))) + audio3)) / 2.0), 0.0, 0.1)) * 7.0)) / 7.0), (uv.y * 8.0))))), (uv.x * 2.0)) * 7.0)) / 7.0))).x - (tan(((beats * 3.14) * 0.5)) / 2.0)), (length(uv) * 10.0)) * 7.0)) / 7.0) + (uv.x * 2.0))) - (uv.x * 10.0)) - (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0) - (length(uv) * 10.0)) * 7.0)) / 7.0) + audio1))), audio3))) + audio3), 0.0, 0.1) + (uv.x * 2.0)) + audio2), 4.0), (uv.y * 8.0))).x, audio3)) - 4.0) + 4.0)) / 2.0) * 7.0)) / 7.0) * 7.0)) / 7.0) - audio1) * 7.0)) / 7.0), (uv.x * 10.0))), (sin(((beats * 1.57) * 0.5)) * 4.0))), audio3) + 4.0), (sin(((beats * 1.57) * 0.5)) * 4.0))), 4.0))), (uv.x * 2.0)) + (uv.x * 10.0)))))).x + (uv.y * 1.5)) * 7.0)) / 7.0) * 7.0)) / 7.0)), (uv.y * 1.5))), sin(((beats * 1.57) * 0.25))), 0.0, 0.1), (uv.x * 2.0))).y, (sin(((beats * 1.57) * 0.5)) * 4.0))), audio3) + audio2), audio1)) * 7.0)) / 7.0), audio2))) + (uv.y * 1.5)), 0.0, 0.1) - audio2), (uv.x * 10.0)))), sin(((beats * 1.57) * 0.25))))) / 2.0) - audio1) + (uv.x * 2.0))) - 3.1416), audio2)) + 4.0), audio1), 3.1416), (tan(((beats * 3.14) * 0.5)) / 2.0))) + (uv.x * 2.0)) - (sin(((beats * 1.57) * 0.5)) * 4.0)), (sin(((beats * 1.57) * 0.5)) * 4.0))), audio2), audio2) + audio3)).x).x) / 2.0), (length(uv) * 10.0))) + (length(uv) * 10.0)) * 7.0)) / 7.0), (uv.y * 8.0))))) + (uv.y * 1.5))).y, (uv.y * 1.5)), (uv.y * 1.5)))).x) / 2.0), (uv.y * 8.0)), (sin(((beats * 1.57) * 0.5)) * 4.0))) + (uv.x * 2.0))) - sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0) - (uv.x * 2.0)) + (uv.x * 2.0)))).x, 0.0, 0.1) * 7.0)) / 7.0)) - audio1)) * 7.0)) / 7.0)) / 2.0)) / 2.0)).x).x - audio2)).x, 3.1416)) + audio1)), (tan(((beats * 3.14) * 0.5)) / 2.0))), (length(uv) * 10.0)) * 7.0)) / 7.0)).y) + 3.1416) - (length(uv) * 10.0))))) + audio3) - 4.0) * 7.0)) / 7.0)).y, (uv.y * 8.0))), (uv.x * 10.0)) * 7.0)) / 7.0)) / 2.0)).y, (length(uv) * 10.0))) * 7.0)) / 7.0) * 7.0)) / 7.0), (uv.x * 10.0)), audio1), 0.0, 0.1)) + 4.0), audio2)) - (tan(((beats * 3.14) * 0.5)) / 2.0)) - 3.1416), 0.0, 0.1) + (uv.x * 10.0)), audio1)), 0.0, 0.1), audio2)) + sin(((beats * 1.57) * 0.25))), (uv.x * 10.0)) * 7.0)) / 7.0))) * 7.0)) / 7.0) - (uv.y * 8.0))) - (uv.x * 2.0)) - 3.1416)).x * 7.0)) / 7.0)) / 2.0), (uv.x * 10.0))) + (uv.x * 10.0)) + (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0))), (uv.y * 8.0)))) + 3.1416) - (uv.x * 2.0)) - 4.0)) / 2.0)).x - audio3), (tan(((beats * 3.14) * 0.5)) / 2.0)), sin(((beats * 1.57) * 0.25))) + (tan(((beats * 3.14) * 0.5)) / 2.0)) - audio1)) + (length(uv) * 10.0)) * 7.0)) / 7.0), 4.0)), audio3)) + audio3)), 0.0, 0.1), 0.0, 0.1), audio3), (length(uv) * 10.0))), 0.0, 0.1))).x, 0.0, 0.1)).x) / 2.0)).y + (length(uv) * 10.0))) + (uv.y * 8.0))).x).y * 7.0)) / 7.0)).x + 3.1416), audio3)) + (tan(((beats * 3.14) * 0.5)) / 2.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)), 0.0, 0.1), audio1))), audio3))).x, audio2)) * 7.0)) / 7.0) - audio2)), 0.0, 0.1)) * 7.0)) / 7.0), audio2)) + sin(((beats * 1.57) * 0.25))), sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0)).y + 4.0), 0.0, 0.1) * 7.0)) / 7.0), (uv.x * 2.0))))) - audio3) - (uv.y * 8.0))) / 2.0), (length(uv) * 10.0)) - audio1), (uv.x * 10.0)))) / 2.0), audio1) * 7.0)) / 7.0)).y, 0.0, 0.95);
c = vec3((1.0 / ((max(((round((length(vec2(pR((uv * 1.5), cos(((floor(((floor((max(((round(((pR((uv * 1.5), (smoothstep(length(vec2(((round((smoothstep(pR((uv * 1.5), smoothstep(cos((-max((tan(pR((uv * 1.5), length(vec2(cos(length(vec2((tan(length(vec2(length(vec2(max(length(vec2(length(vec2((((pR((uv * 1.5), (round((smoothstep(sin(cos(max((tan((-(floor((length(vec2((length(vec2(length(vec2((sin(pR((uv * 1.5), max(length(vec2(cos((round((smoothstep((tan((-max(length(vec2(pR((uv * 1.5), max(3.1416, 4.0)).x, audio1)), sin(((beats * 1.57) * 0.25))))) / 2.0), 0.0, 0.1) * 7.0)) / 7.0)), (length(uv) * 10.0))), audio2)).x) - 4.0), audio2)), (uv.x * 10.0))) + audio3), (uv.y * 8.0))) * 7.0)) / 7.0))) / 2.0), 4.0))), 0.0, 0.1) * 7.0)) / 7.0)).x + (uv.x * 10.0)) + audio1) - sin(((beats * 1.57) * 0.25))), audio2)), (length(uv) * 10.0))), (uv.y * 1.5)), audio1)), (uv.x * 2.0)))) / 2.0), audio3))), audio3))).x) / 2.0), (uv.y * 8.0)))), 0.0, 0.1)).x, 0.0, 0.1) * 7.0)) / 7.0) - sin(((beats * 1.57) * 0.25))), audio1)), 0.0, 0.1) + sin(((beats * 1.57) * 0.25)))).x - (uv.y * 8.0)) * 7.0)) / 7.0) + (uv.x * 10.0)), (uv.y * 8.0)) * 7.0)) / 7.0) * 7.0)) / 7.0) - audio3))).x, audio2)) * 7.0)) / 7.0) + audio1), audio3) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + (uv.y * 1.5))), (1.0 / smoothstep((floor((smoothstep(length(vec2(length(vec2(cos((tan(max(length(vec2((floor((pR((uv * 1.5), (-(tan((tan((pR((uv * 1.5), (-smoothstep((floor(((round((length(vec2(pR((uv * 1.5), pR((uv * 1.5), pR((uv * 1.5), max((round((pR((uv * 1.5), ((length(vec2((max((tan(max((-max(max(sin(length(vec2(max(pR((uv * 1.5), smoothstep((sin(smoothstep(cos(smoothstep(cos((pR((uv * 1.5), ((length(vec2(smoothstep((((round((length(vec2(length(vec2(((uv.y * 8.0) - (uv.x * 2.0)), (uv.x * 2.0))), sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0) - audio2) + (uv.x * 10.0)), 0.0, 0.1), 4.0)) + audio1) + (uv.x * 2.0))).y - audio1)), 0.0, 0.1)), 0.0, 0.1)) + 4.0), 0.0, 0.1)).y, audio2), sin(((beats * 1.57) * 0.25))))), (sin(((beats * 1.57) * 0.5)) * 4.0)), (length(uv) * 10.0))), 3.1416)) / 2.0), (uv.y * 1.5)) + audio1), 4.0)) - sin(((beats * 1.57) * 0.25))) + 4.0)).x * 7.0)) / 7.0), (uv.x * 2.0))).x).x).y, (uv.x * 10.0))) * 7.0)) / 7.0) * 7.0)) / 7.0), 0.0, 0.1))).x - sin(((beats * 1.57) * 0.25)))) / 2.0)) / 2.0))).x * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0))), (sin(((beats * 1.57) * 0.5)) * 4.0))) / 2.0)), sin(((beats * 1.57) * 0.25)))), audio3)), 0.0, 0.1) * 7.0)) / 7.0), 0.0, 0.1)), (1.0 / pR((uv * 1.5), pR((uv * 1.5), max((tan((-((tan(max(((max(sin(max(length(vec2(length(vec2((-(tan((round(((length(vec2(max(length(vec2(((-pR((uv * 1.5), (tan((pR((uv * 1.5), (-max((((tan(length(vec2((length(vec2((smoothstep((cos(max((tan(((floor(((floor((sin(length(vec2(pR((uv * 1.5), (pR((uv * 1.5), smoothstep((-((-max((tan((round((((-(-((uv.x * 2.0) - (uv.y * 8.0)))) + (length(uv) * 10.0)) * 7.0)) / 7.0)) / 2.0), (uv.x * 2.0))) - 4.0)), 0.0, 0.1)).y - (uv.y * 1.5))).x, (length(uv) * 10.0)))) * 7.0)) / 7.0) * 7.0)) / 7.0) + (uv.y * 8.0))) / 2.0), (sin(((beats * 1.57) * 0.5)) * 4.0))) - audio3), 0.0, 0.1) + (tan(((beats * 3.14) * 0.5)) / 2.0)), (uv.x * 10.0))) + (uv.y * 1.5)), 4.0))) / 2.0) + (uv.x * 10.0)) + (uv.x * 10.0)), sin(((beats * 1.57) * 0.25))))).x + (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0)).x) + (length(uv) * 10.0)), audio2)), audio3), audio3)) + (length(uv) * 10.0)) * 7.0)) / 7.0)) / 2.0)), (uv.y * 1.5))), (uv.y * 1.5))), (uv.y * 8.0))), 4.0) - (uv.y * 8.0)) + sin(((beats * 1.57) * 0.25))), (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0) + sin(((beats * 1.57) * 0.25))))) / 2.0), sin(((beats * 1.57) * 0.25)))).y).y));
c = (c * 0.9);
vec3 actualColor = vec3(1.0);
actualColor = (actualColor - (vec3(c.x) * r));
actualColor = (actualColor - (vec3(c.y) * g));
actualColor = (actualColor - (vec3(c.z) * b));
c = (vec3(l) * actualColor);
c = (c + (noise(pR(uv, Time), 0.5) * 0.021));
c = max(c, vec3(0.0));
c = (c / smoothstep(0.1, 0.3, fract((beats + 2.) / 4.) * 4.));
fsout_Color = vec4(c, 1.0);

}

