#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}



#define PI 3.14159265358979323846
const vec3 purple = vec3(0.298, 0.176, 0.459);
const vec3 yellow = vec3(0.675, 0.635, 0.22);
#define ITS 400.
float hashX(vec3 p)
{
    p  = fract( p*0.3183099+.1 );
	p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}
float noiseX(in vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hashX(p+vec3(0.,0.,0)), 
                        hashX(p+vec3(1.,0.,0)),f.x),
                   mix( hashX(p+vec3(0.,1.,0)), 
                        hashX(p+vec3(1.,1.,0)),f.x),f.y),
               mix(mix( hashX(p+vec3(0.,0.,1)), 
                        hashX(p+vec3(1.,0.,1)),f.x),
                   mix( hashX(p+vec3(0.,1.,1)), 
                        hashX(p+vec3(1.,1.,1)),f.x),f.y),f.z);
}
void pR2(inout vec2 p, float a) {
    // thx to hg (http://mercury.sexy/hg_sdf)
	p = cos(a)*p + sin(a)*vec2(p.y, -p.x);
}
vec3 scene(vec3 p)
{
    float n = beats * 2.;
    //n = mod(n, 6.); // loop dur
    //n += 20.; // start
    float lum = 0.02;
    lum += sin(n / 5.)*0.006; // slow pulse
    //float pump = max(0.8, (1.-fract(n)));
    p *= smoothstep(0., 12., n);
    p *= 5. + sin(n / 3.); // slow zoom in<->out
    pR2(p.yz, (p.x * 4. + n * 4.) * 0.1); // x axis spiral
    pR2(p.xy, (p.z * 2. + n) * 0.3); // spin
    pR2(p.zx, noiseX(p * 2. + n) * smoothstep(34., 52., n));
    pR2(p.xy, (noiseX(p * 4. + n) - 0.5) * smoothstep(42., 64., n));
    pR2(p.yz, n);
    p.x *= 1. - smoothstep(22., 30., n);
    float field = length(p - clamp(p, -0.05, 0.05));
    float cube = 1. / field * lum;
    vec3 cubec = min(1., cube) * purple * 0.13;
    vec3 c = cubec;
    c *= 300. / ITS;
    c *= smoothstep(0., 3., n);
    return c;
}
vec3 flame()
{
	//vec2 iResolution = vec2(80., 45.);
    //vec2 uv = (fsin_Position.xy - (iResolution.xy * 0.5)) / iResolution.yy;
	vec2 uv = fsin_Position;
    vec3 c = vec3(0.0);
    float hr = 0.3;
    for(float z = -hr; z < hr; z += 1. / ITS)
    {
        c += scene(vec3(uv, z));
    }
    c = clamp(c, 0., 1.);
    //c -= smoothstep(0.55, 1.3, abs(uv.x)) * 0.05; // vignette x
    //c -= smoothstep(0.17, 0.7, abs(uv.y)) * 0.05; // vignette y
    c += sin(Time * 0.4) * 0.02; // ambience
    //c += noiseX(vec3(uv * 2000., 0.)) * 0.02; // grain
    //c -= step(0.35, abs(uv.y)); // letterbox
	c = clamp(c, 0., 1.);
	return c;
}

void main()
{
float audio1 = max(0.0, (0.1 - fract(((beats * 4.0) + 0.04))));
float audio2 = max(0.0, (0.1 - fract((((beats * 4.0) + 0.05) - 0.4))));
float audio3 = (step(1.5, (fract((beats / 2.0)) * 2.0)) - step(8.0, (fract((beats / 2.0)) * 2.0)));
vec2 uv = fsin_Position;
uv = vec2((uv.x + (audio1 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio2 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio3 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = ((uv / 2.0) - Offset);
uv = (uv * (1.0 + (Zoom * Zoom)));
vec3 c = vec3(0.0);
vec3 r = vec3(0.68, 0.18, 0.14);
vec3 g = vec3(0.87, 0.89, 0.78);
vec3 b = vec3(0.0, 0.6, 0.96);
float l = clamp(sin((length(vec2(pR((uv * 5.0), cos((((length(vec2(length(vec2(pR(vec2(pR(vec2((uv.x * 10.0), max(max(pR(vec2((tan(sin((floor((pR(vec2((uv.x * 10.0), pR((uv * 5.0), pR((uv * 1.5), pR(vec2(length(vec2((max(sin(max(pR((uv * 5.0), length(vec2((length(vec2(pR((uv * 1.5), (floor((pR((uv * 1.5), pR((uv * 5.0), (cos(pR((uv * 1.5), max((tan((floor((pR(vec2(((tan(((sin(sin(pR((uv * 5.0), max((pR(vec2((uv.x * 10.0), (pR(vec2((uv.x * 10.0), (-(tan(pR(vec2((uv.x * 10.0), pR(vec2((pR((uv * 1.5), smoothstep(max(pR((uv * 5.0), pR(vec2(length(vec2(pR((uv * 5.0), ((max(smoothstep(pR((uv * 1.5), (round((length(vec2(pR(vec2(sin((floor(((round((pR(vec2((floor(((pR(vec2(pR(vec2(pR((uv * 1.5), length(vec2(pR((uv * 5.0), length(vec2(pR(vec2((uv.x * 10.0), (pR(vec2((uv.x * 10.0), pR(vec2(pR(vec2((uv.x * 10.0), (-(floor((max((floor((pR((uv * 1.5), pR((uv * 5.0), sin(pR((uv * 5.0), (round((sin((-pR(vec2((uv.y * 10.0), pR((uv * 5.0), pR((uv * 1.5), (pR((uv * 1.5), ((pR((uv * 5.0), smoothstep(pR(vec2(max((pR((uv * 1.5), pR(vec2((uv.x * 10.0), pR((uv * 1.5), pR((uv * 1.5), ((pR(vec2((uv.y * 10.0), length(vec2(max(pR(vec2((round((sin(pR(vec2((uv.y * 10.0), pR(vec2(pR((uv * 5.0), pR((uv * 5.0), (pR((uv * 5.0), pR(vec2(cos(pR((uv * 1.5), pR(vec2((uv.y * 10.0), pR(vec2((uv.x * 10.0), pR((uv * 1.5), smoothstep(max(pR(vec2(pR(vec2((uv.y * 10.0), pR((uv * 1.5), (floor((length(vec2((round((pR(vec2((uv.y * 10.0), pR(vec2(max((pR((uv * 5.0), (floor((pR(vec2((uv.x * 10.0), max((-pR(vec2((uv.y * 10.0), (pR(vec2((uv.x * 10.0), pR((uv * 5.0), (floor(((pR((uv * 1.5), (floor((pR((uv * 1.5), (floor((pR((uv * 1.5), pR(vec2(cos((((tan(smoothstep(pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR(vec2(pR(vec2((uv.x * 10.0), (pR((uv * 1.5), pR((uv * 1.5), sin((-((tan((floor(((floor((pR((uv * 5.0), length(vec2((pR(vec2(pR(vec2(pR(vec2((uv.y * 10.0), (round((sin(smoothstep(pR((uv * 5.0), pR((uv * 1.5), pR(vec2((uv.y * 10.0), pR((uv * 5.0), (smoothstep(pR(vec2((uv.x * 10.0), length(vec2(pR(vec2(((pR((uv * 5.0), cos(pR(vec2((uv.y * 10.0), (round((smoothstep(sin(pR((uv * 5.0), pR(vec2(pR(vec2((uv.x * 10.0), (round(((pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), max(pR((uv * 5.0), (tan((pR(vec2((uv.y * 10.0), (tan(pR((uv * 1.5), (pR(vec2(pR(vec2((uv.x * 10.0), cos(max((pR((uv * 5.0), smoothstep((tan(pR((uv * 1.5), pR(vec2(length(vec2(sin((tan(((pR((uv * 5.0), length(vec2(sin(pR((uv * 5.0), (floor((pR(vec2((uv.y * 10.0), (round(((floor((max(pR((uv * 5.0), (length(vec2((((tan((round(((-(sin(((-pR((uv * 5.0), pR((uv * 5.0), pR(vec2((uv.y * 10.0), cos(pR(vec2(pR(vec2(pR((uv * 5.0), pR(vec2(sin(pR((uv * 5.0), pR((uv * 5.0), pR(vec2((uv.x * 10.0), cos(pR((uv * 1.5), pR((uv * 1.5), pR(vec2((uv.y * 10.0), (round(((pR(vec2((uv.y * 10.0), length(vec2(pR(vec2((uv.x * 10.0), (pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR((uv * 1.5), sin((tan((((floor(((sin(pR((uv * 1.5), pR((uv * 1.5), pR((uv * 1.5), pR(vec2((pR((uv * 5.0), pR(vec2((uv.y * 10.0), pR((uv * 5.0), pR(vec2((uv.y * 10.0), smoothstep((round((((pR(vec2((uv.y * 10.0), (round(((-pR(vec2(length(vec2(length(vec2(cos(pR((uv * 5.0), length(vec2(max(pR((uv * 5.0), smoothstep((pR(vec2((uv.y * 10.0), (pR((uv * 1.5), pR((uv * 5.0), pR((uv * 5.0), sin(pR((uv * 1.5), max(pR(vec2(pR((uv * 1.5), max(length(vec2(pR((uv * 5.0), smoothstep((pR(vec2((uv.x * 10.0), pR((uv * 5.0), pR(vec2((uv.x * 10.0), (-(((-pR(vec2((uv.y * 10.0), (round((((max((pR((uv * 1.5), (cos(pR((uv * 5.0), (-(round((max((round(((floor((pR(vec2((uv.x * 10.0), pR((uv * 5.0), (smoothstep(pR(vec2((uv.y * 10.0), (round((pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR((uv * 5.0), pR((uv * 5.0), (pR(vec2((uv.y * 10.0), max(pR((uv * 5.0), pR(vec2((uv.y * 10.0), (pR(vec2(((-(cos((tan(pR(vec2(pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), length(vec2(smoothstep(pR((uv * 5.0), (pR((uv * 1.5), (floor((pR((uv * 5.0), (floor((max(pR((uv * 5.0), pR((uv * 1.5), pR(vec2((uv.y * 10.0), (pR(vec2((uv.x * 10.0), length(vec2((length(vec2(((max((floor((pR(vec2((uv.x * 10.0), (floor((smoothstep(cos((tan((round((smoothstep((length(vec2(pR((uv * 1.5), ((-(-pR((uv * 1.5), pR(vec2((uv.y * 10.0), (tan(pR((uv * 1.5), (tan(smoothstep(pR(vec2((uv.x * 10.0), sin(sin(pR(vec2((uv.x * 10.0), pR(vec2((max(smoothstep((tan(length(vec2(pR(vec2(sin(pR((uv * 1.5), (tan((tan((tan(((-max(pR((uv * 5.0), cos(sin(max(((tan(cos(pR((uv * 5.0), (tan(pR(vec2((uv.x * 10.0), ((tan(pR(vec2(pR((uv * 1.5), sin(((audio3 + (length(uv) * 10.0)) - (uv.x * 10.0)))).y, (uv.x * 2.0)), (beats * 0.25)).y) / 2.0) + audio3)), audio2).x) / 2.0)).y)) / 2.0) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))), (uv.y * 1.5))))).x, 4.0)) + (uv.y * 1.5))) / 2.0)) / 2.0)) / 2.0)).y), audio3), (beats * 0.25)).x, (sin(((beats * 1.57) * 0.5)) * 4.0)))) / 2.0), 0.0, 0.1), (uv.y * 8.0)) - (length(uv) * 10.0)), (length(uv) * 10.0)), (beats * 0.25)).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).x))), 4.0).x, 0.0, 0.1)) / 2.0)).y) / 2.0)), audio1).y).x)) + (length(uv) * 10.0))).x, (uv.x * 10.0))) + (tan(((beats * 3.14) * 0.5)) / 2.0)), 0.0, 0.1) * 7.0)) / 7.0)) / 2.0)), 0.0, 0.1) * 7.0)) / 7.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)).x * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25))) + sin(((beats * 1.57) * 0.25))) - (uv.x * 2.0)), audio3)) - audio2), sin(((beats * 1.57) * 0.25))))), (sin(((beats * 1.57) * 0.5)) * 4.0)).x + 3.1416)), audio2).y).y).y, sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0)).y * 7.0)) / 7.0)).x + audio2)).y, 0.0, 0.1), 4.0))), (uv.y * 8.0)).x), sin(((beats * 1.57) * 0.25))).x, (uv.x * 2.0)), (beats * 0.25)).y) / 2.0)) / (1.3 / audio1))) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y / (1.3 / audio2))), (uv.y * 8.0)).y).x, (tan(((beats * 3.14) * 0.5)) / 2.0))), 4.0).y + audio2)).y).x), (sin(((beats * 1.57) * 0.5)) * 4.0)).x).y * 7.0)) / 7.0)), (uv.y * 1.5)).y, 0.0, 0.1) + (sin(((beats * 1.57) * 0.5)) * 4.0))).y), audio1).x * 7.0)) / 7.0) * 7.0)) / 7.0), (uv.x * 2.0)) * 7.0)) / 7.0))).y) / (1.3 / audio3))).x / (1.3 / 4.0)), audio2) / (1.3 / sin(((beats * 1.57) * 0.25)))) - (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0)), (uv.y * 8.0)).y) - (uv.y * 8.0)) - (uv.x * 2.0)))), (uv.y * 8.0)).x).y), (length(uv) * 10.0)).x / (1.3 / audio1)), 0.0, 0.1)).y, (uv.y * 1.5))), audio1)).x, (uv.y * 1.5)), (beats * 0.25)).x, audio1)).x)).x).y).y / (1.3 / 3.1416))), (uv.x * 10.0)).y + 3.1416), 0.0, 0.1)).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)))).y), audio1)), sin(((beats * 1.57) * 0.25)))), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x) * 7.0)) / 7.0)), (uv.x * 10.0)).y / (1.3 / (length(uv) * 10.0))) - (uv.x * 2.0)) * 7.0)) / 7.0), 0.0, 0.1)), (length(uv) * 10.0)).y).y), audio3).y).y + (sin(((beats * 1.57) * 0.5)) * 4.0)), audio3), (beats * 0.25)).x).y).x).x) - 3.1416) * 7.0)) / 7.0) + (uv.y * 1.5)) - (uv.y * 8.0))) / 2.0))).x), audio3).x).y / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0)))), audio2).x, audio1))), (length(uv) * 10.0)).y - (uv.x * 10.0)) * 7.0)) / 7.0)), 4.0).y).x).x)), (uv.y * 8.0)).x).x).y), audio3), (beats * 0.25)).x).x, 3.1416), (beats * 0.25)).y, (uv.y * 8.0)), (beats * 0.25)).x)), 3.1416).y).x).y) / (1.3 / audio1))) / (1.3 / 3.1416))) * 7.0)) / 7.0)) / 2.0) - (tan(((beats * 3.14) * 0.5)) / 2.0)) / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))), (sin(((beats * 1.57) * 0.5)) * 4.0))) + audio1)).y, (sin(((beats * 1.57) * 0.5)) * 4.0)) * 7.0)) / 7.0) * 7.0)) / 7.0)), 3.1416).y * 7.0)) / 7.0)).y), audio2))).y / (1.3 / (uv.y * 1.5))) / (1.3 / audio1))) / 2.0)), 3.1416)), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x).y) / 2.0), 0.0, 0.1)).x - (uv.x * 2.0)), 4.0))), (uv.y * 8.0)).x, (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y / (1.3 / audio2))).y) / 2.0)), (uv.y * 8.0)).y + (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0)).x, (sin(((beats * 1.57) * 0.5)) * 4.0))), (uv.y * 1.5)).x), audio1).x - (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0)), audio1).x, (uv.x * 10.0)), (beats * 0.25)).y).x), 0.0, 0.1) * 7.0)) / 7.0)), (uv.x * 10.0)).y)).y - (length(uv) * 10.0)) + 3.1416), 4.0), (beats * 0.25)).y, (uv.x * 2.0)))), (uv.y * 1.5)).x, 0.0, 0.1) - (uv.x * 10.0))).y), sin(((beats * 1.57) * 0.25))).y).y).y, 0.0, 0.1)) * 7.0)) / 7.0)), (uv.y * 8.0)).y, (uv.y * 1.5)), (beats * 0.25)).x, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x - (uv.x * 10.0)), (uv.x * 2.0)))).y * 7.0)) / 7.0) * 7.0)) / 7.0)) / 2.0) - (uv.y * 1.5))))).x).x / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0)))), audio2).x, 3.1416), (beats * 0.25)).y), (length(uv) * 10.0)).x).x, 0.0, 0.1)) / 2.0) + (uv.x * 2.0)) / (1.3 / 4.0))), (uv.y * 1.5)), (beats * 0.25)).x).x * 7.0)) / 7.0)).x * 7.0)) / 7.0)).x / (1.3 / (uv.y * 1.5))) * 7.0)) / 7.0)).y), audio2).x - 3.1416)), audio2).y), audio2)), (uv.x * 2.0)).x * 7.0)) / 7.0)).y + (length(uv) * 10.0)), audio3), audio3), (beats * 0.25)).y), sin(((beats * 1.57) * 0.25))).y * 7.0)) / 7.0), audio2)) * 7.0)) / 7.0)).y), (length(uv) * 10.0)).y, (uv.y * 1.5)), (beats * 0.25)).y, audio1), 0.0, 0.1)).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).x), sin(((beats * 1.57) * 0.25))).y).x), (uv.y * 8.0)), (beats * 0.25)).x).x - 4.0)).x).x, audio1), (beats * 0.25)).x), audio1).y) * 7.0)) / 7.0), (uv.x * 2.0)), (beats * 0.25)).x, 3.1416), (uv.y * 1.5)))), audio1).y - 4.0) - (sin(((beats * 1.57) * 0.5)) * 4.0))).x).x), (length(uv) * 10.0)).x).x / (1.3 / (uv.x * 2.0))), audio1), audio3), (beats * 0.25)).x, 0.0, 0.1)).x - (uv.y * 8.0)) + 3.1416)).x - sin(((beats * 1.57) * 0.25)))).x).y), (uv.y * 8.0)).y)) * 7.0)) / 7.0)).x)).x).x * 7.0)) / 7.0), audio3) * 7.0)) / 7.0))), (length(uv) * 10.0)).x, (uv.y * 1.5)), (beats * 0.25)).y), (length(uv) * 10.0)).x + (uv.y * 8.0))), (uv.x * 10.0)).x, 4.0))).x, sin(((beats * 1.57) * 0.25))))).x, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y, 4.0), (beats * 0.25)).y / (1.3 / audio3)) * 7.0)) / 7.0), audio2), (beats * 0.25)).y * 7.0)) / 7.0) * 7.0)) / 7.0)), audio1), (beats * 0.25)).x, 4.0)) * 7.0)) / 7.0)).y, 0.0, 0.1), (uv.x * 10.0)) + audio3) - (sin(((beats * 1.57) * 0.5)) * 4.0))).y, audio3)), audio2), (beats * 0.25)).x).y, (uv.x * 2.0)), 0.0, 0.1)).y - sin(((beats * 1.57) * 0.25))), (uv.x * 2.0)), (beats * 0.25)).x), (tan(((beats * 3.14) * 0.5)) / 2.0)).x) / 2.0))), 4.0).x - (sin(((beats * 1.57) * 0.5)) * 4.0))), 4.0).x + (uv.y * 8.0)), (uv.y * 1.5))).y)) + (uv.y * 1.5)) / (1.3 / 4.0))) / 2.0) + (uv.y * 8.0)), (uv.x * 10.0)), (beats * 0.25)).x * 7.0)) / 7.0)) / 2.0), (uv.x * 10.0))).x) + (uv.y * 1.5))).y).x * 7.0)) / 7.0)).x, (uv.y * 1.5))) + audio3), audio2))).x, audio1)), (uv.y * 1.5)) / (1.3 / (uv.y * 8.0))), (uv.y * 1.5))), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x).x).x), (uv.x * 10.0)).x * 7.0)) / 7.0))) / 2.0), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y, audio1), (uv.y * 8.0))), 3.1416).x, audio3), (beats * 0.25)).x, (length(uv) * 10.0))), 3.1416)) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + (uv.y * 1.5)) / (1.3 / (length(uv) * 10.0))))).x, (uv.x * 10.0))) + audio3)), 0.0, 0.95);
c = vec3((1.0 / (round((pR((uv * 1.5), (cos(pR(vec2(pR((uv * 1.5), pR(vec2((pR(vec2(sin(pR((uv * 5.0), (pR(vec2((uv.y * 10.0), cos(pR(vec2(pR((uv * 5.0), pR(vec2((tan(pR((uv * 5.0), (pR(vec2((uv.y * 10.0), (pR((uv * 1.5), (tan(((pR((uv * 5.0), pR((uv * 1.5), cos(pR(vec2(sin((floor((pR(vec2((uv.x * 10.0), ((round(((floor((length(vec2(smoothstep(max((cos(pR(vec2(pR(vec2(pR(vec2((pR(vec2((uv.x * 10.0), smoothstep((-(-sin(((sin(pR(vec2((uv.x * 10.0), (pR((uv * 1.5), (floor((pR((uv * 5.0), pR((uv * 1.5), pR((uv * 1.5), (tan(pR(vec2((round(((pR(vec2((uv.x * 10.0), (((round(((uv.x * 10.0) * 7.0)) / 7.0) + (uv.x * 2.0)) - (tan(((beats * 3.14) * 0.5)) / 2.0))), sin(((beats * 1.57) * 0.25))).x - sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0), 3.1416), (beats * 0.25)).y) / 2.0)).y).x).y * 7.0)) / 7.0)).y - (uv.y * 8.0))), 3.1416).x) - (tan(((beats * 3.14) * 0.5)) / 2.0)) - (sin(((beats * 1.57) * 0.5)) * 4.0))))), 0.0, 0.1)), (uv.y * 1.5)).x / (1.3 / audio2)), (uv.x * 10.0)), (beats * 0.25)).x, 4.0), (beats * 0.25)).y, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y) - (uv.y * 1.5)), audio1), 0.0, 0.1), (tan(((beats * 3.14) * 0.5)) / 2.0))) * 7.0)) / 7.0) * 7.0)) / 7.0) + 3.1416)), (uv.y * 8.0)).x * 7.0)) / 7.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y)).x).y - sin(((beats * 1.57) * 0.25))) - (uv.x * 2.0))) / 2.0)).y - (uv.y * 8.0))), sin(((beats * 1.57) * 0.25))).y - audio1)).x) / 2.0), (length(uv) * 10.0)), (beats * 0.25)).y).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x)), (tan(((beats * 3.14) * 0.5)) / 2.0)).y / (1.3 / (uv.x * 10.0)))).x), 4.0), (beats * 0.25)).x - audio1), 3.1416), (beats * 0.25)).y).x, (uv.x * 10.0)), (beats * 0.25)).y) / (1.3 / audio1))).x * 7.0)) / 7.0)), (1.0 / pR(vec2(cos(length(vec2(max((max(((floor((pR(vec2(pR(vec2((uv.y * 10.0), length(vec2(pR((uv * 5.0), pR(vec2((uv.y * 10.0), (pR(vec2(pR(vec2((round((pR((uv * 5.0), max(pR(vec2((max(pR((uv * 5.0), pR((uv * 1.5), max(pR((uv * 5.0), smoothstep((floor((pR(vec2((uv.y * 10.0), length(vec2(max(pR((uv * 5.0), length(vec2(pR((uv * 1.5), max(pR((uv * 1.5), sin((floor((pR(vec2(pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), smoothstep(pR(vec2(((tan((length(vec2((round(((length(vec2(pR((uv * 5.0), pR((uv * 5.0), (pR(vec2((uv.x * 10.0), (tan(pR(vec2((uv.y * 10.0), (floor((((uv.x * 2.0) - (length(uv) * 10.0)) * 7.0)) / 7.0)), (length(uv) * 10.0)).y) / 2.0)), (uv.y * 1.5)).x - (sin(((beats * 1.57) * 0.5)) * 4.0))).x).y, audio3)) / (1.3 / audio3)) * 7.0)) / 7.0), audio3)) - (uv.x * 10.0))) / 2.0) / (1.3 / (uv.x * 10.0))), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y, 0.0, 0.1)), (uv.x * 2.0)).y), audio3).x, 3.1416), (beats * 0.25)).y * 7.0)) / 7.0))).x, 4.0)).x, (length(uv) * 10.0)))).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), audio3))), 3.1416).y * 7.0)) / 7.0), 0.0, 0.1)).y, (uv.x * 2.0))).x).y, (uv.y * 8.0)) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))), (uv.x * 10.0)), (beats * 0.25)).y, (uv.y * 8.0))).y * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y, (uv.y * 8.0)), (beats * 0.25)).y / (1.3 / (uv.x * 2.0)))), 3.1416).y).x, (uv.x * 10.0)))), (uv.y * 1.5)).y, 3.1416), (beats * 0.25)).x * 7.0)) / 7.0) + (uv.y * 1.5)), (sin(((beats * 1.57) * 0.5)) * 4.0)) / (1.3 / audio2)), (uv.y * 1.5)), (uv.x * 2.0)))), audio3), (beats * 0.25)).y), (1.0 / (pR(vec2((uv.y * 10.0), ((-pR(vec2(pR(vec2((max((floor((length(vec2(sin(smoothstep(pR((uv * 1.5), pR(vec2(pR(vec2((uv.y * 10.0), pR((uv * 1.5), (pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), pR(vec2(pR(vec2((uv.x * 10.0), cos(max(length(vec2(pR(vec2((uv.y * 10.0), (-(tan((max(pR(vec2(max(pR((uv * 5.0), (round((pR(vec2((uv.x * 10.0), pR(vec2(pR((uv * 5.0), cos(pR(vec2((uv.y * 10.0), (tan(pR((uv * 1.5), pR(vec2((uv.x * 10.0), pR((uv * 1.5), length(vec2(sin(sin((length(vec2(pR(vec2((uv.y * 10.0), (-length(vec2(pR((uv * 1.5), (floor((pR(vec2((uv.x * 10.0), cos((tan((-pR(vec2(((-max((floor((pR(vec2(pR((uv * 5.0), (tan(((tan(pR(vec2((uv.y * 10.0), (round((max(smoothstep(pR((uv * 5.0), (tan(((beats * 3.14) * 0.5)) / 2.0)).x, 0.0, 0.1), sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0)), 4.0).y) / 2.0) + (uv.x * 2.0))) / 2.0)).y, 4.0), (beats * 0.25)).x * 7.0)) / 7.0), audio1)) / (1.3 / (uv.y * 8.0))), (uv.y * 8.0)), (beats * 0.25)).y)) / 2.0))), (sin(((beats * 1.57) * 0.5)) * 4.0)).x * 7.0)) / 7.0)).y, audio3)))), (tan(((beats * 3.14) * 0.5)) / 2.0)).y, audio1)) - (tan(((beats * 3.14) * 0.5)) / 2.0)))), audio1))).y), (tan(((beats * 3.14) * 0.5)) / 2.0)).x).y) / 2.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)).y)).y, (uv.y * 8.0)), (beats * 0.25)).x), (uv.y * 8.0)).x * 7.0)) / 7.0)).x, (length(uv) * 10.0)), audio2), (beats * 0.25)).x, (uv.x * 10.0)) - (uv.y * 1.5))) / 2.0))), (uv.y * 1.5)).y, (uv.y * 1.5))), (uv.y * 1.5)))), (length(uv) * 10.0)).x, (uv.y * 1.5)), (beats * 0.25)).y), audio3).x), sin(((beats * 1.57) * 0.25))).x - sin(((beats * 1.57) * 0.25)))).x), audio3).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y).y, 0.0, 0.1)), audio3)) * 7.0)) / 7.0), (uv.y * 1.5)) / (1.3 / (uv.y * 8.0))), (uv.y * 1.5)), (beats * 0.25)).y, 4.0), (beats * 0.25)).y) - 4.0)), 3.1416).y / (1.3 / (uv.y * 1.5)))));
c = (c * 0.9);
vec3 actualColor = vec3(1.0);
actualColor = (actualColor - (vec3(c.x) * r));
actualColor = (actualColor - (vec3(c.y) * g));
actualColor = (actualColor - (vec3(c.z) * b));
c = (vec3(l) * actualColor);
c = (c + (noise(pR(uv, Time), 0.5) * 0.021));
c = max(c, vec3(0.0));
c = (c / smoothstep(0.1, 0.3, (fract((beats / 2.0)) * 2.0)));

c *= flame();

fsout_Color = vec4(c, 1.0);

}

