#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

void main()
{
float audio1 = max(0.0, (0.1 - fract(((beats * 4.0) + 0.04))));
float audio2 = max(0.0, (0.1 - fract((((beats * 4.0) + 0.05) - 0.4))));
float audio3 = (step(1.5, (fract((beats / 2.0)) * 2.0)) - step(8.0, (fract((beats / 2.0)) * 2.0)));
vec2 uv = fsin_Position;
uv = vec2((uv.x + (audio1 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio2 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio3 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = ((uv / 2.0) - Offset);
uv = (uv * (1.0 + (Zoom * Zoom)));
vec3 c = vec3(0.0);
vec3 r = vec3(0.68, 0.18, 0.14);
vec3 g = vec3(0.87, 0.89, 0.78);
vec3 b = vec3(0.0, 0.6, 0.96);
float l = clamp((floor((max(max(sin(cos(max((round((cos((tan(((sin((tan(cos(max((floor(((max((tan(max(((tan(((-(tan((round((max(max(sin(max((floor(((tan(((max((tan(cos(max((tan(((-(cos((round((sin((floor((max((max(sin((((max(((tan((floor((sin(((tan((tan(sin((floor(((-cos(max((((max((((round(((sin((max(sin(max((-(((sin((((tan((-((sin((floor(((floor(((round(((-max((floor(((floor(((((max(max(max(cos(((-(round((sin((tan((round(((max((floor((((-(tan(((round((max(((max((sin((-max(cos((floor(((round(((floor(((max(sin((tan(cos((round(((((tan(((round(((((tan((max(sin((-(max(((tan((floor(((-((floor(((tan((floor(((max((-(-(-((cos((((floor(((tan((-((tan(max(cos((cos((cos((-(floor(((sin(max((round((max(max(((((tan(((tan((tan(cos((round(((-(floor(((round(((-max(((floor(((-(tan((round((sin(((sin((round((((max((floor(((tan(max((tan((round(((cos(cos(max((sin((sin(((tan((tan((sin(((floor((max(sin(((floor(((sin((tan(((tan((tan((tan((cos(sin(((max((floor((cos(max((cos(((-(tan((tan(((max(max(((floor((max((sin((tan(max((tan((floor((max(cos((tan((round(((sin(((round((((tan((tan((tan(((round((max(max(((round((((max((sin(sin(((-max(((round((((max((floor((max((-((-(max((-sin(sin((max((((floor((((floor(((floor((max(cos(cos((floor(((((-((cos((-((sin(cos(max(max(((tan((((round((((((((-sin(cos((cos(max((max(max((round(((-sin(((floor((cos(sin(sin((round((((tan((max(sin((cos(max(sin(max((-(round(((-((-sin(max(max(max(max(sin((floor((max((tan((tan((((max(((((tan(sin(cos(max(max((-cos((max(max(((tan(max(max((((((tan((((round((cos((cos(((-max((round((((round((((tan(sin(sin(sin((round(((tan((((round((((cos((floor(((tan(cos((-(-sin((tan((tan(((-(max((floor(((tan(max(((round(((tan(((sin(((((floor((audio3 * 7.0)) / 7.0) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + (uv.x * 2.0)) - (tan(((beats * 3.14) * 0.5)) / 2.0))) + audio2) + (uv.x * 2.0))) / 2.0) * 7.0)) / 7.0) - (uv.x * 2.0)), (length(uv) * 10.0))) / 2.0) * 7.0)) / 7.0), audio2) + audio2)) + (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0)) / 2.0)))))) / 2.0) * 7.0)) / 7.0)) + audio2) - (uv.x * 2.0)) * 7.0)) / 7.0) - (tan(((beats * 3.14) * 0.5)) / 2.0)) - (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0) * 7.0)) / 7.0))))) / 2.0) - (length(uv) * 10.0)) * 7.0)) / 7.0) + (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0), (tan(((beats * 3.14) * 0.5)) / 2.0))) - audio2)) - 3.1416)) * 7.0)) / 7.0) - 3.1416) - (sin(((beats * 1.57) * 0.5)) * 4.0))) / 2.0) + 3.1416) + (tan(((beats * 3.14) * 0.5)) / 2.0)) + (uv.y * 8.0)) + (uv.y * 8.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)), audio1)) / 2.0) + (sin(((beats * 1.57) * 0.5)) * 4.0)), (length(uv) * 10.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)) + audio1))), audio2), (length(uv) * 10.0))))) / 2.0) + (uv.y * 1.5)) + 3.1416) + audio1), (tan(((beats * 3.14) * 0.5)) / 2.0)) + (uv.x * 2.0)) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + audio1)) / 2.0)) / 2.0), (uv.x * 10.0)) * 7.0)) / 7.0)), 3.1416), audio2), audio2), audio2))) + (uv.x * 10.0))) * 7.0)) / 7.0)), 3.1416)), sin(((beats * 1.57) * 0.25)))) - (uv.x * 2.0))), (length(uv) * 10.0)) + (uv.x * 2.0))) / 2.0) - 3.1416) * 7.0)) / 7.0)))) * 7.0)) / 7.0) - audio1))) * 7.0)) / 7.0), (uv.x * 2.0)), (uv.y * 1.5)) + (uv.x * 2.0)), audio3)) + sin(((beats * 1.57) * 0.25)))))) + (sin(((beats * 1.57) * 0.5)) * 4.0)) - (uv.y * 8.0)) - (sin(((beats * 1.57) * 0.5)) * 4.0)) - (length(uv) * 10.0)) + sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0) + (uv.y * 1.5)) + (uv.y * 8.0))) / 2.0) + (length(uv) * 10.0)), 3.1416), (uv.x * 2.0)))) + audio3) - audio2))) + (sin(((beats * 1.57) * 0.5)) * 4.0)) + audio3)) - audio2) + (uv.x * 2.0)) * 7.0)) / 7.0))), (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0) * 7.0)) / 7.0) - (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0) - (tan(((beats * 3.14) * 0.5)) / 2.0)) + (length(uv) * 10.0)), audio1) + (uv.x * 2.0))))), (length(uv) * 10.0)) + audio2)) - audio1)), (uv.y * 1.5)) * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0)) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + (uv.x * 2.0)) * 7.0)) / 7.0) + 3.1416), audio3)) - (tan(((beats * 3.14) * 0.5)) / 2.0)))) + (sin(((beats * 1.57) * 0.5)) * 4.0)), (length(uv) * 10.0)) - (uv.y * 8.0)) + (uv.y * 8.0)) * 7.0)) / 7.0) + audio1), audio1), sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0) + (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0)) / 2.0)) / 2.0) + (uv.x * 2.0)) * 7.0)) / 7.0) - audio1)) - (uv.y * 1.5)) * 7.0)) / 7.0)) / 2.0)), (uv.x * 10.0)) * 7.0)) / 7.0)) / 2.0), audio3)) / 2.0)) - audio3), (sin(((beats * 1.57) * 0.5)) * 4.0)) * 7.0)) / 7.0) - (sin(((beats * 1.57) * 0.5)) * 4.0)), audio3), (uv.y * 1.5)) + (length(uv) * 10.0)) - audio2)) / 2.0)) / 2.0)) - (uv.y * 8.0))) - audio2), sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0)) - (uv.y * 1.5)) - (uv.y * 8.0)))) + (uv.x * 2.0))) / 2.0)) / 2.0)) / 2.0) - (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0)) + (uv.y * 1.5)) * 7.0)) / 7.0) + 3.1416)), (uv.x * 2.0)) * 7.0)) / 7.0) + (tan(((beats * 3.14) * 0.5)) / 2.0))) + (uv.x * 2.0))) / 2.0)) / 2.0) - sin(((beats * 1.57) * 0.25)))) + 3.1416)) + sin(((beats * 1.57) * 0.25))), (sin(((beats * 1.57) * 0.5)) * 4.0)))) - (uv.y * 8.0)) * 7.0)) / 7.0)) / 2.0), (uv.x * 10.0))) / 2.0) * 7.0)) / 7.0), (uv.y * 1.5)) + 3.1416) - (uv.y * 1.5)) * 7.0)) / 7.0)) + (length(uv) * 10.0)) - audio3)) * 7.0)) / 7.0)) / 2.0)) * 7.0)) / 7.0) + 3.1416), audio1)) * 7.0)) / 7.0) * 7.0)) / 7.0)) * 7.0)) / 7.0))) / 2.0)) / 2.0) - (length(uv) * 10.0))) / 2.0) + (uv.x * 10.0)) + 3.1416) - audio2), (sin(((beats * 1.57) * 0.5)) * 4.0)), (uv.x * 2.0)) * 7.0)) / 7.0), (uv.x * 10.0))) - (uv.y * 1.5)) * 7.0)) / 7.0))) - 3.1416)) + audio2)), audio3)) / 2.0) + (tan(((beats * 3.14) * 0.5)) / 2.0)))) / 2.0) * 7.0)) / 7.0) + 3.1416) - (sin(((beats * 1.57) * 0.5)) * 4.0))) - sin(((beats * 1.57) * 0.25))) - audio2)))), (uv.y * 8.0)) + (uv.x * 2.0)) * 7.0)) / 7.0)) / 2.0) * 7.0)) / 7.0) - (sin(((beats * 1.57) * 0.5)) * 4.0))) * 7.0)) / 7.0)) / 2.0) - audio1), 3.1416) - (uv.y * 8.0)))), (uv.x * 10.0)) + audio1)) / 2.0) + audio3) + (uv.y * 1.5)) * 7.0)) / 7.0) + (sin(((beats * 1.57) * 0.5)) * 4.0))) / 2.0) - audio2) - audio2) * 7.0)) / 7.0))) / 2.0)), audio2) - (uv.y * 1.5)) * 7.0)) / 7.0) * 7.0)) / 7.0) * 7.0)) / 7.0)), (uv.x * 10.0)))) - (uv.y * 8.0)), audio3) + audio1) + (tan(((beats * 3.14) * 0.5)) / 2.0)), sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0) + (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0)) + sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0), (length(uv) * 10.0)) + (sin(((beats * 1.57) * 0.5)) * 4.0)) * 7.0)) / 7.0)) / 2.0)) * 7.0)) / 7.0)) + (uv.x * 10.0))), audio2), 3.1416), audio3) + audio1) + (tan(((beats * 3.14) * 0.5)) / 2.0)) + audio1) * 7.0)) / 7.0) * 7.0)) / 7.0), (uv.x * 10.0))) * 7.0)) / 7.0) * 7.0)) / 7.0) * 7.0)) / 7.0)) - 3.1416) - 3.1416))) / 2.0) + (length(uv) * 10.0)) - audio2)) + (length(uv) * 10.0)) + 3.1416) - 3.1416)), audio1)), 3.1416) - (sin(((beats * 1.57) * 0.5)) * 4.0))) + (uv.x * 10.0)) * 7.0)) / 7.0) - (length(uv) * 10.0)) + (uv.x * 10.0)), 3.1416) - sin(((beats * 1.57) * 0.25))) + sin(((beats * 1.57) * 0.25))) - audio2), 3.1416))) * 7.0)) / 7.0))) / 2.0)) / 2.0) - (uv.y * 1.5))) * 7.0)) / 7.0)) / 2.0) - audio1), sin(((beats * 1.57) * 0.25))) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + (uv.y * 8.0)) + audio1)), audio1) + audio2), audio2) * 7.0)) / 7.0)) * 7.0)) / 7.0)) + 3.1416)) - audio1)) / 2.0), audio3))) / 2.0), 3.1416) - audio1) + (uv.y * 1.5))) / 2.0) * 7.0)) / 7.0), (uv.x * 2.0))), audio1), (uv.y * 1.5)) * 7.0)) / 7.0)) / 2.0)) + (uv.y * 8.0))) / 2.0) - audio2), audio3)) / 2.0), audio1) + (uv.y * 1.5)) * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0)))) / 2.0)) + (sin(((beats * 1.57) * 0.5)) * 4.0)) - sin(((beats * 1.57) * 0.25)))) / 2.0)) * 7.0)) / 7.0), audio2))), (length(uv) * 10.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0), 0.0, 0.95);
c = vec3((1.0 / (((-(max((-((floor((((round((max(cos((floor(((round(((max(((round((max(((-max((max((-((((((-(round(((floor((((-(floor((((((tan(((((cos((floor(((floor(((floor(((-sin(sin(max(max(max((max(cos(max((max(max((((-((cos((-(tan(((beats * 3.14) * 0.5)) / 2.0))) + (uv.y * 8.0)) - (length(uv) * 10.0))) + sin(((beats * 1.57) * 0.25))) + (uv.y * 8.0)), (uv.x * 10.0)), (uv.x * 2.0)) + (uv.x * 10.0)), 3.1416)), sin(((beats * 1.57) * 0.25))) - 3.1416), (tan(((beats * 3.14) * 0.5)) / 2.0)), 3.1416), (uv.x * 10.0))))) * 7.0)) / 7.0) * 7.0)) / 7.0) * 7.0)) / 7.0)) + (uv.x * 2.0)) + (uv.y * 1.5)) - sin(((beats * 1.57) * 0.25))) - (sin(((beats * 1.57) * 0.5)) * 4.0))) / 2.0) + audio1) + audio1) - audio3) * 7.0)) / 7.0)) - (length(uv) * 10.0)) * 7.0)) / 7.0) * 7.0)) / 7.0)) - audio3) - (uv.y * 8.0)) - (length(uv) * 10.0)) + audio3) + (length(uv) * 10.0))), (uv.x * 10.0)) + (uv.y * 8.0)), audio2)) + (uv.x * 10.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)) * 7.0)) / 7.0) + sin(((beats * 1.57) * 0.25))), (uv.y * 8.0)) + audio1) * 7.0)) / 7.0) * 7.0)) / 7.0)), (uv.x * 2.0)) * 7.0)) / 7.0) + sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0) - (sin(((beats * 1.57) * 0.5)) * 4.0))), (tan(((beats * 3.14) * 0.5)) / 2.0)) + (uv.y * 1.5))) - 3.1416) + audio1)), (1.0 / (cos((floor(((floor((((sin(((tan(max((-(round((sin(cos((max((-max((round(((((max((((round((((tan((cos((tan((-(tan(cos((floor((cos((max((round((max((tan(max((-sin((floor(((tan(max((round((((-max((-max((((-cos(((cos((((max((floor((3.1416 * 7.0)) / 7.0), (uv.y * 1.5)) - (sin(((beats * 1.57) * 0.5)) * 4.0)) + audio3) + (tan(((beats * 3.14) * 0.5)) / 2.0))) - (sin(((beats * 1.57) * 0.5)) * 4.0)) - (uv.x * 2.0)))) - (uv.x * 2.0)) + (uv.x * 2.0)), audio2)), (uv.x * 10.0))) - sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0), (uv.x * 10.0))) / 2.0) * 7.0)) / 7.0))), audio2)) / 2.0), (uv.y * 8.0)) * 7.0)) / 7.0), (uv.y * 8.0)) + (tan(((beats * 3.14) * 0.5)) / 2.0))) * 7.0)) / 7.0))) / 2.0))) / 2.0)) - (tan(((beats * 3.14) * 0.5)) / 2.0))) / 2.0) - (sin(((beats * 1.57) * 0.5)) * 4.0)) * 7.0)) / 7.0) + (uv.y * 1.5)) - audio3), (uv.y * 8.0)) + (tan(((beats * 3.14) * 0.5)) / 2.0)) + (tan(((beats * 3.14) * 0.5)) / 2.0)) - (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0), audio3)), (length(uv) * 10.0)) + (uv.y * 1.5)))) * 7.0)) / 7.0)), audio2)) / 2.0) + (length(uv) * 10.0))) - audio1) + sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0) * 7.0)) / 7.0)) - sin(((beats * 1.57) * 0.25)))), (1.0 / (floor(((-cos(max(max(((round(((max(((-max(sin((tan((floor((max((((((max(((tan(max((floor((sin(((-(-(((floor((((tan(max((tan(max(max((cos((sin(cos((-(((round(((round(((floor((((round((max(sin((tan(((floor(((round((max(((((tan((-(uv.x * 2.0))) / 2.0) - 3.1416) + audio3) - (uv.y * 1.5)), (length(uv) * 10.0)) * 7.0)) / 7.0) * 7.0)) / 7.0) + (sin(((beats * 1.57) * 0.5)) * 4.0))) / 2.0)), (uv.y * 1.5)) * 7.0)) / 7.0) - (length(uv) * 10.0)) * 7.0)) / 7.0) * 7.0)) / 7.0) * 7.0)) / 7.0) + sin(((beats * 1.57) * 0.25))) + (uv.x * 2.0))))) + audio3)) + audio3), audio2), (uv.x * 2.0))) / 2.0), (uv.y * 1.5))) / 2.0) - (uv.x * 2.0)) * 7.0)) / 7.0) + (uv.x * 10.0)) + (sin(((beats * 1.57) * 0.5)) * 4.0)))) + (uv.y * 8.0))) * 7.0)) / 7.0), (length(uv) * 10.0))) / 2.0) + 3.1416), (uv.y * 8.0)) - (tan(((beats * 3.14) * 0.5)) / 2.0)) + (uv.y * 1.5)) - sin(((beats * 1.57) * 0.25))) - (uv.y * 1.5)) - audio1), audio2) * 7.0)) / 7.0)) / 2.0)), (tan(((beats * 3.14) * 0.5)) / 2.0))) + (length(uv) * 10.0)), (length(uv) * 10.0)) - sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0) + (length(uv) * 10.0)), (length(uv) * 10.0)), (uv.x * 2.0)))) * 7.0)) / 7.0)));
c = (c * 0.9);
vec3 actualColor = vec3(1.0);
actualColor = (actualColor - (vec3(c.x) * r));
actualColor = (actualColor - (vec3(c.y) * g));
actualColor = (actualColor - (vec3(c.z) * b));
c = (vec3(l) * actualColor);
c = (c + (noise(pR(uv, Time), 0.5) * 0.021));
c = max(c, vec3(0.0));
c = (c / smoothstep(0.1, 0.3, (fract((beats / 2.0)) * 2.0)));
fsout_Color = vec4(c, 1.0);

}

