#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

void main()
{
float audio1 = max(0.0, (0.1 - fract(((beats * 4.0) + 0.04))));
float audio2 = max(0.0, (0.1 - fract((((beats * 4.0) + 0.05) - 0.4))));
float audio3 = (step(1.5, (fract((beats / 2.0)) * 2.0)) - step(8.0, (fract((beats / 2.0)) * 2.0)));
vec2 uv = fsin_Position;
uv = vec2((uv.x + (audio1 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio2 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio3 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = ((uv / 2.0) - Offset);
uv = (uv * (1.0 + (Zoom * Zoom)));
vec3 c = vec3(0.0);
vec3 r = vec3(0.68, 0.18, 0.14);
vec3 g = vec3(0.87, 0.89, 0.78);
vec3 b = vec3(0.0, 0.6, 0.96);
float l = clamp(pR(vec2((uv.y * 10.0), (length(vec2(cos(pR((uv * 1.5), pR(vec2(pR(vec2((uv.y * 10.0), pR(vec2((uv.y * 10.0), (smoothstep(pR((uv * 5.0), pR((uv * 1.5), pR(vec2((uv.y * 10.0), pR((uv * 1.5), pR((uv * 1.5), smoothstep(pR(vec2(cos(length(vec2((((((tan(pR((uv * 1.5), (floor(((floor(((pR(vec2(pR(vec2(pR(vec2(max(pR(vec2((floor(((tan(length(vec2(pR(vec2((uv.y * 10.0), smoothstep(pR((uv * 1.5), pR(vec2(pR(vec2((uv.x * 10.0), pR(vec2(pR((uv * 1.5), (pR((uv * 1.5), (-sin((round(((tan(pR(vec2(pR(vec2((uv.x * 10.0), pR(vec2((-sin(smoothstep(smoothstep((tan((tan(pR((uv * 1.5), ((-(floor((pR(vec2((uv.x * 10.0), length(vec2((round(((pR((uv * 5.0), (pR((uv * 1.5), pR((uv * 5.0), (-max(pR(vec2((pR(vec2((round(((tan(length(vec2((-cos(pR((uv * 5.0), pR(vec2((uv.y * 10.0), (-(tan((floor(((pR((uv * 5.0), (((-smoothstep(length(vec2(pR((uv * 5.0), max(smoothstep(length(vec2((round(((pR(vec2((uv.x * 10.0), (round(((-(floor((pR((uv * 5.0), (pR(vec2(pR(vec2((uv.y * 10.0), sin(pR((uv * 1.5), pR((uv * 1.5), pR(vec2((uv.y * 10.0), (round(((cos((round((pR(vec2((uv.y * 10.0), pR((uv * 1.5), pR((uv * 1.5), sin(sin((-(((-(-(-pR(vec2((pR((uv * 1.5), pR(vec2(length(vec2(pR((uv * 1.5), cos(sin(pR((uv * 1.5), pR(vec2((uv.x * 10.0), smoothstep(smoothstep(pR((uv * 1.5), pR(vec2(pR(vec2((uv.y * 10.0), pR(vec2((uv.y * 10.0), ((pR((uv * 5.0), (pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), pR((uv * 5.0), ((floor((pR((uv * 1.5), pR((uv * 1.5), (floor((pR(vec2(pR(vec2((uv.x * 10.0), (pR(vec2((-pR(vec2((uv.y * 10.0), pR(vec2(pR(vec2(pR((uv * 5.0), (floor((pR(vec2((uv.x * 10.0), (floor(((pR((uv * 5.0), smoothstep(((pR((uv * 5.0), pR(vec2((uv.y * 10.0), pR((uv * 5.0), (round((length(vec2(smoothstep(((length(vec2(pR(vec2((uv.y * 10.0), sin(pR((uv * 1.5), (round((pR((uv * 5.0), (-length(vec2(pR((uv * 5.0), smoothstep((pR(vec2(pR(vec2(pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), max(pR(vec2(pR((uv * 5.0), (pR(vec2((uv.x * 10.0), smoothstep(max(pR((uv * 5.0), (-length(vec2(pR(vec2((uv.x * 10.0), (cos(pR((uv * 1.5), pR((uv * 1.5), pR((uv * 1.5), max(smoothstep(length(vec2((pR(vec2((uv.x * 10.0), (floor(((round(((-(tan((sin(max(sin(pR((uv * 1.5), pR(vec2((uv.y * 10.0), length(vec2(((pR(vec2(pR(vec2((uv.y * 10.0), smoothstep(pR(vec2((-sin((tan(pR(vec2((floor((sin(pR((uv * 5.0), (tan(cos(pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR((uv * 1.5), (floor(((floor(((max(length(vec2((-pR((uv * 1.5), length(vec2((round(((round(((pR(vec2(pR(vec2((uv.y * 10.0), (length(vec2(pR(vec2(length(vec2(smoothstep(smoothstep((-sin(smoothstep(sin(smoothstep((floor(((pR((uv * 1.5), length(vec2(pR((uv * 1.5), pR(vec2((uv.x * 10.0), (round((((floor(((pR((uv * 5.0), (pR((uv * 1.5), pR((uv * 1.5), max(smoothstep(pR(vec2((uv.x * 10.0), max(pR(vec2((length(vec2(pR(vec2(cos(pR(vec2(max((smoothstep((tan(pR(vec2((uv.x * 10.0), (pR((uv * 1.5), pR(vec2((uv.y * 10.0), smoothstep((round((pR(vec2(((smoothstep((length(vec2((floor((pR(vec2((uv.x * 10.0), pR((uv * 5.0), (sin((round((pR(vec2((uv.y * 10.0), cos(sin(cos(pR((uv * 5.0), (round((pR((uv * 5.0), pR(vec2((round((smoothstep((smoothstep(sin(max(pR((uv * 5.0), max(pR(vec2(pR((uv * 1.5), length(vec2(pR((uv * 5.0), pR(vec2(pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR(vec2(pR(vec2((uv.x * 10.0), (tan(pR(vec2(pR(vec2((uv.x * 10.0), (floor((pR(vec2(pR(vec2((uv.y * 10.0), pR(vec2((uv.y * 10.0), pR((uv * 5.0), pR((uv * 5.0), ((round((smoothstep((floor(((tan((tan((pR((uv * 5.0), pR(vec2((uv.x * 10.0), (pR(vec2(pR((uv * 1.5), (round((pR((uv * 1.5), pR((uv * 1.5), pR((uv * 1.5), (tan(smoothstep(pR(vec2((uv.y * 10.0), smoothstep(pR(vec2((uv.y * 10.0), pR(vec2(max(pR((uv * 5.0), (floor((pR((uv * 5.0), (round((cos(pR((uv * 1.5), (sin(pR((uv * 5.0), (round((length(vec2((-(tan(pR((uv * 5.0), pR((uv * 5.0), (tan((floor((pR(vec2((smoothstep(cos(smoothstep(pR(vec2((tan((-pR((uv * 5.0), max((round(((round(((-length(vec2((smoothstep(max((pR((uv * 5.0), pR(vec2((uv.x * 10.0), (-pR(vec2(((tan((length(vec2(pR(vec2(pR((uv * 5.0), (pR(vec2((uv.x * 10.0), (-smoothstep(((pR(vec2((pR((uv * 5.0), max(pR(vec2((floor((pR(vec2((uv.y * 10.0), pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), pR((uv * 5.0), pR((uv * 1.5), pR(vec2((round(((pR((uv * 5.0), smoothstep((pR(vec2(pR(vec2(((tan(length(vec2(pR((uv * 5.0), pR((uv * 5.0), (length(vec2((pR((uv * 1.5), cos(pR(vec2(smoothstep(pR((uv * 5.0), (length(uv) * 10.0)).y, 0.0, 0.1), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y)).x + (uv.y * 8.0)), (length(uv) * 10.0))) - 3.1416)).y).y, sin(((beats * 1.57) * 0.25))))) / 2.0) / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))), audio2), (beats * 0.25)).y, audio3), (beats * 0.25)).x / (1.3 / (uv.y * 8.0))), 0.0, 0.1)).x / (1.3 / (uv.x * 10.0))) * 7.0)) / 7.0), audio1), (beats * 0.25)).y).x).x), (uv.y * 1.5)).y), (uv.y * 8.0)).x), 3.1416).y * 7.0)) / 7.0), (uv.x * 10.0)), (beats * 0.25)).y, audio1)).y / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))), (uv.x * 10.0)), (beats * 0.25)).y + (tan(((beats * 3.14) * 0.5)) / 2.0)) / (1.3 / (length(uv) * 10.0))), 0.0, 0.1))), audio2).x / (1.3 / 4.0))).x, 3.1416), (beats * 0.25)).y, audio2)) + sin(((beats * 1.57) * 0.25)))) / 2.0) - (uv.y * 1.5)), (uv.y * 8.0)), (beats * 0.25)).x)), (uv.y * 1.5)).x).x + (uv.y * 1.5)), audio1), 0.0, 0.1) + 3.1416), (tan(((beats * 3.14) * 0.5)) / 2.0)))) * 7.0)) / 7.0) * 7.0)) / 7.0), (uv.y * 1.5))).x)) / 2.0), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y, 0.0, 0.1)), 0.0, 0.1) - (uv.x * 2.0)), (length(uv) * 10.0)), (beats * 0.25)).x * 7.0)) / 7.0)) / 2.0)).x).y) / 2.0)), (uv.x * 10.0))) * 7.0)) / 7.0)).x) / (1.3 / audio3))).y) * 7.0)) / 7.0)).x * 7.0)) / 7.0)).x, (uv.y * 1.5)), audio2), (beats * 0.25)).x), (uv.y * 8.0)).y, 0.0, 0.1)), 4.0).y, 0.0, 0.1)) / 2.0)).x).x).y * 7.0)) / 7.0)).x, (uv.y * 1.5)), (beats * 0.25)).y / (1.3 / audio1))), 4.0).x).x + audio1)) / 2.0)) / 2.0) * 7.0)) / 7.0), 0.0, 0.1) * 7.0)) / 7.0) + (uv.y * 1.5))).x).x), (length(uv) * 10.0)).y), audio2).y, (uv.y * 1.5)), (beats * 0.25)).y * 7.0)) / 7.0)), (uv.x * 2.0)).x, audio3), (beats * 0.25)).y) / 2.0)), (uv.y * 8.0)).x, (uv.x * 2.0)), (beats * 0.25)).x), (uv.y * 1.5)).x).x, 4.0), (beats * 0.25)).x).x, (uv.x * 10.0)))).x, audio1), (beats * 0.25)).x, 4.0)).x, (uv.x * 10.0))), 0.0, 0.1) + (sin(((beats * 1.57) * 0.5)) * 4.0)), 0.0, 0.1) * 7.0)) / 7.0), (length(uv) * 10.0)), (beats * 0.25)).y).x * 7.0)) / 7.0)).y)))), (uv.x * 2.0)).y * 7.0)) / 7.0)) / (1.3 / (uv.y * 8.0)))).x), (length(uv) * 10.0)).x * 7.0)) / 7.0), 3.1416)) / (1.3 / (uv.x * 10.0))), 0.0, 0.1) + (uv.y * 8.0)) - (uv.y * 1.5)), (uv.x * 10.0)), (beats * 0.25)).y * 7.0)) / 7.0), 0.0, 0.1)), (uv.x * 2.0)).y).x - (uv.x * 2.0))), audio2).x) / 2.0), 0.0, 0.1) - (length(uv) * 10.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x), (uv.x * 2.0)), (beats * 0.25)).x, 4.0)) + (uv.y * 8.0)), 4.0), (beats * 0.25)).y, (uv.y * 8.0))), (uv.y * 1.5)).x, 0.0, 0.1), (tan(((beats * 3.14) * 0.5)) / 2.0))).x).x / (1.3 / 4.0))).y - (uv.y * 8.0)) * 7.0)) / 7.0) / (1.3 / (uv.x * 10.0))) * 7.0)) / 7.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)).x).x, audio1))).y - (uv.x * 2.0)) * 7.0)) / 7.0), 0.0, 0.1)), 0.0, 0.1))), 0.0, 0.1), 0.0, 0.1), (uv.x * 2.0))), (uv.y * 1.5)), (beats * 0.25)).x, (sin(((beats * 1.57) * 0.5)) * 4.0))) - (uv.y * 1.5))), 3.1416).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x + (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0) * 7.0)) / 7.0), (uv.y * 8.0)))).x), (uv.y * 8.0))), (uv.y * 8.0)) - 4.0) * 7.0)) / 7.0) * 7.0)) / 7.0)).y), (uv.x * 10.0)).x).x)) / 2.0)).x) * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y) / 2.0))), (uv.y * 1.5)), (beats * 0.25)).y, 0.0, 0.1)), sin(((beats * 1.57) * 0.25))).y, (length(uv) * 10.0)), (beats * 0.25)).x - 4.0) - 3.1416), (uv.y * 1.5)))), (length(uv) * 10.0)).y).y), audio2)) - (uv.x * 2.0))) / 2.0)) * 7.0)) / 7.0) * 7.0)) / 7.0)), 3.1416).x / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))), (sin(((beats * 1.57) * 0.5)) * 4.0))), 0.0, 0.1), audio1)).x).x).y) - audio2)), (tan(((beats * 3.14) * 0.5)) / 2.0)).x, (uv.y * 8.0))))).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), 0.0, 0.1)), (uv.y * 1.5)).x + (sin(((beats * 1.57) * 0.5)) * 4.0))).y, audio3), (beats * 0.25)).x, (uv.y * 1.5))), (sin(((beats * 1.57) * 0.5)) * 4.0)).y), (tan(((beats * 3.14) * 0.5)) / 2.0)).x, (length(uv) * 10.0)), (beats * 0.25)).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y + (sin(((beats * 1.57) * 0.5)) * 4.0)), 0.0, 0.1)).y, (uv.y * 1.5))))).y * 7.0)) / 7.0)).x)), (uv.x * 2.0)).y, (sin(((beats * 1.57) * 0.5)) * 4.0))) - (uv.y * 1.5)) + 4.0), 0.0, 0.1), (sin(((beats * 1.57) * 0.5)) * 4.0))) * 7.0)) / 7.0)).y), audio3).y).x + audio1) / (1.3 / 4.0)), 0.0, 0.1)).y - sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0)), (uv.y * 1.5)).x * 7.0)) / 7.0)).x, (uv.x * 10.0)), (beats * 0.25)).x, audio3), (beats * 0.25)).x), (uv.y * 1.5)).y), (uv.x * 2.0)), (beats * 0.25)).x - (uv.x * 2.0))), sin(((beats * 1.57) * 0.25))).x, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y * 7.0)) / 7.0)).y).x * 7.0)) / 7.0) + 3.1416)).x), (uv.x * 2.0)).y), (uv.y * 1.5)).x / (1.3 / audio2))).y + (uv.y * 1.5)) / (1.3 / audio2))), (uv.x * 2.0)).y), (tan(((beats * 3.14) * 0.5)) / 2.0)).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x).x, 0.0, 0.1), 0.0, 0.1)), (uv.x * 10.0)).x).x))).y, audio3)), (uv.y * 1.5)), (beats * 0.25)).x).x / (1.3 / (uv.x * 2.0))), 4.0), (beats * 0.25)).y))) + audio2) + audio3))))).y).y), (tan(((beats * 3.14) * 0.5)) / 2.0)).y * 7.0)) / 7.0)) + audio2) * 7.0)) / 7.0)), audio3).y).y).y)), (uv.x * 10.0)).y, 4.0), (beats * 0.25)).y + (uv.x * 10.0))).y * 7.0)) / 7.0)) * 7.0)) / 7.0)), 3.1416).x + (sin(((beats * 1.57) * 0.5)) * 4.0)) * 7.0)) / 7.0), audio3)), 0.0, 0.1), (length(uv) * 10.0))).x, 3.1416)), 0.0, 0.1)) - (length(uv) * 10.0)) + (uv.y * 1.5))).y / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))) * 7.0)) / 7.0)) / 2.0))), (uv.x * 10.0)).y).y)), (length(uv) * 10.0)))) / 2.0) * 7.0)) / 7.0), (uv.x * 2.0)), (beats * 0.25)).x + sin(((beats * 1.57) * 0.25))), (uv.y * 1.5)), (beats * 0.25)).y, (sin(((beats * 1.57) * 0.5)) * 4.0)))).y).x - audio2)).y - audio3) * 7.0)) / 7.0), audio1))), (uv.y * 1.5)).x * 7.0)) / 7.0)) + sin(((beats * 1.57) * 0.25)))).y) / 2.0)) / 2.0), 0.0, 0.1), 0.0, 0.1))), (uv.x * 2.0)), (beats * 0.25)).x), audio2).x, (uv.x * 10.0)), (beats * 0.25)).x) / 2.0) * 7.0)) / 7.0)))).y + 4.0)).y, (uv.x * 2.0)), (beats * 0.25)).y), audio3).x, audio2), (beats * 0.25)).x).y, 0.0, 0.1)), audio2).y, (uv.y * 1.5)))) / 2.0) * 7.0)) / 7.0), (uv.y * 8.0)), (beats * 0.25)).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (uv.x * 2.0)), (beats * 0.25)).x, audio3), (beats * 0.25)).y, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x / (1.3 / sin(((beats * 1.57) * 0.25)))) * 7.0)) / 7.0) * 7.0)) / 7.0)).y) / 2.0) + (length(uv) * 10.0)) / (1.3 / audio2)) / (1.3 / 3.1416)) - 3.1416), sin(((beats * 1.57) * 0.25))))), 4.0), (beats * 0.25)).x, 0.0, 0.1)).y).x), (uv.y * 8.0)).y).x).y, 0.0, 0.1) - (tan(((beats * 3.14) * 0.5)) / 2.0))), (tan(((beats * 3.14) * 0.5)) / 2.0)).y), (tan(((beats * 3.14) * 0.5)) / 2.0)).y, (uv.y * 8.0)), (beats * 0.25)).x).x), sin(((beats * 1.57) * 0.25)))) + (tan(((beats * 3.14) * 0.5)) / 2.0))), audio1).y, 0.0, 0.95);
c = vec3((1.0 / (round((max(pR((uv * 1.5), smoothstep(sin((round((sin((tan(pR(vec2((uv.y * 10.0), (round((pR(vec2((uv.y * 10.0), (round((pR(vec2((uv.x * 10.0), (round((length(vec2(pR(vec2(length(vec2(sin(pR((uv * 5.0), pR((uv * 1.5), pR(vec2(cos(pR((uv * 1.5), pR((uv * 1.5), (length(vec2(pR((uv * 5.0), cos(pR(vec2(max((pR(vec2(smoothstep(sin(pR(vec2(pR(vec2(pR((uv * 5.0), pR((uv * 1.5), sin(length(vec2(pR((uv * 5.0), (cos(pR(vec2(pR(vec2((pR((uv * 5.0), length(vec2((floor((pR(vec2((uv.y * 10.0), pR(vec2((round((pR((uv * 5.0), max((tan(((floor((pR(vec2((uv.y * 10.0), pR(vec2((pR(vec2((length(vec2(audio3, audio2)) - audio2), 3.1416), (beats * 0.25)).y + (uv.x * 10.0)), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y), (uv.y * 8.0)).y * 7.0)) / 7.0) / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0)))) / 2.0), audio3)).y * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x), (uv.y * 8.0)).y * 7.0)) / 7.0), (tan(((beats * 3.14) * 0.5)) / 2.0)))).x / (1.3 / (uv.x * 10.0))), audio2), (beats * 0.25)).y, audio1), (beats * 0.25)).y) / (1.3 / (uv.y * 8.0)))).y, (tan(((beats * 3.14) * 0.5)) / 2.0))))).x).y, 3.1416), (beats * 0.25)).x, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y), 0.0, 0.1), (length(uv) * 10.0)), (beats * 0.25)).x / (1.3 / audio3)), audio1), (uv.y * 8.0)), (beats * 0.25)).x)).x, 3.1416)) + sin(((beats * 1.57) * 0.25)))).y).y), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y).x).x), audio1)), (uv.y * 8.0)), (beats * 0.25)).x, audio1)) * 7.0)) / 7.0)), sin(((beats * 1.57) * 0.25))).x * 7.0)) / 7.0)), (length(uv) * 10.0)).y * 7.0)) / 7.0)), (length(uv) * 10.0)).y) / 2.0)) * 7.0)) / 7.0)), 0.0, 0.1)).x, (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0)), (1.0 / ((-pR(vec2((sin((pR((uv * 1.5), pR((uv * 5.0), pR((uv * 1.5), pR((uv * 5.0), (pR((uv * 1.5), pR((uv * 1.5), (pR(vec2((tan((tan(pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), smoothstep(length(vec2(sin(pR(vec2((uv.x * 10.0), (-max(pR((uv * 1.5), pR((uv * 5.0), smoothstep((tan(pR((uv * 1.5), pR((uv * 5.0), pR(vec2((-pR((uv * 5.0), pR(vec2((round((pR(vec2((uv.x * 10.0), pR(vec2(length(vec2(pR((uv * 1.5), (-(((((round(((round((pR((uv * 1.5), sin((smoothstep((floor((pR((uv * 5.0), pR(vec2((uv.y * 10.0), (floor(((pR(vec2((uv.y * 10.0), max(pR((uv * 5.0), max(pR(vec2((uv.x * 10.0), pR((uv * 5.0), pR(vec2(((round(((round(((tan(cos((-(uv.x * 2.0)))) / 2.0) * 7.0)) / 7.0) * 7.0)) / 7.0) + audio1), audio1), (beats * 0.25)).y).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).x, audio1)).x, (uv.y * 1.5))), audio1).y + (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0)), (uv.x * 2.0)).y).y * 7.0)) / 7.0), 0.0, 0.1) / (1.3 / (uv.y * 1.5))))).y * 7.0)) / 7.0) * 7.0)) / 7.0) - (uv.y * 1.5)) / (1.3 / (uv.x * 10.0))) + (tan(((beats * 3.14) * 0.5)) / 2.0)) / (1.3 / (uv.x * 10.0))))).x, (uv.y * 8.0))), (uv.x * 10.0)), (beats * 0.25)).y), (uv.x * 2.0)).x * 7.0)) / 7.0), (uv.y * 1.5)), (beats * 0.25)).x).x), audio1), (beats * 0.25)).x).x).x) / 2.0), 0.0, 0.1)).x).y, (length(uv) * 10.0)))), 4.0).x), (uv.x * 2.0))), 0.0, 0.1)), (tan(((beats * 3.14) * 0.5)) / 2.0)).y), (uv.y * 8.0)).x) / 2.0)) / 2.0), 3.1416), (beats * 0.25)).x + (sin(((beats * 1.57) * 0.5)) * 4.0))).y).x - (uv.x * 2.0))).y).y).x).y / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0)))) + (length(uv) * 10.0)), audio1), (beats * 0.25)).y) - sin(((beats * 1.57) * 0.25)))), (1.0 / length(vec2(smoothstep(pR(vec2(((pR(vec2(smoothstep(smoothstep(((round((pR(vec2((uv.x * 10.0), sin((floor((smoothstep(((round(((pR(vec2(pR(vec2((uv.y * 10.0), sin(pR(vec2((uv.y * 10.0), pR(vec2((uv.x * 10.0), (-(-pR((uv * 5.0), pR(vec2(pR(vec2(pR(vec2((sin(pR(vec2((uv.y * 10.0), max(smoothstep((round((pR((uv * 5.0), pR(vec2((uv.x * 10.0), smoothstep((floor((pR(vec2((uv.x * 10.0), pR((uv * 1.5), pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), (pR((uv * 5.0), (floor(((floor((pR(vec2(cos((tan(pR((uv * 1.5), ((pR(vec2((uv.x * 10.0), pR(vec2((pR(vec2(smoothstep(pR(vec2((uv.x * 10.0), pR((uv * 1.5), length(vec2(length(vec2(pR((uv * 1.5), (round((((pR((uv * 5.0), max(cos((sin(cos(pR(vec2(pR((uv * 5.0), audio1).x, (length(uv) * 10.0)), (beats * 0.25)).x)) - (uv.y * 1.5))), 4.0)).y - (sin(((beats * 1.57) * 0.5)) * 4.0)) - sin(((beats * 1.57) * 0.25))) * 7.0)) / 7.0)).x, (uv.y * 1.5))), (uv.x * 10.0)))).y), 4.0).x, 0.0, 0.1), audio3), (beats * 0.25)).y / (1.3 / audio2)), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x), 3.1416).x - (uv.x * 2.0)) / (1.3 / sin(((beats * 1.57) * 0.25))))).y) / 2.0)), (uv.y * 8.0)), (beats * 0.25)).x * 7.0)) / 7.0) * 7.0)) / 7.0)).x - (uv.x * 10.0))), audio3).y), audio3).x).y), audio2).x * 7.0)) / 7.0), 0.0, 0.1)), (tan(((beats * 3.14) * 0.5)) / 2.0)).x).x * 7.0)) / 7.0), 0.0, 0.1), (sin(((beats * 1.57) * 0.5)) * 4.0))), audio2).y) + (tan(((beats * 3.14) * 0.5)) / 2.0)), (length(uv) * 10.0)), (beats * 0.25)).y, audio3), (beats * 0.25)).y, (uv.x * 10.0)), (beats * 0.25)).x).y))), (sin(((beats * 1.57) * 0.5)) * 4.0)).x), (uv.x * 2.0)).y)), (length(uv) * 10.0)).y, (uv.x * 2.0)), (beats * 0.25)).y + (uv.x * 10.0)) * 7.0)) / 7.0) / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))), 0.0, 0.1) * 7.0)) / 7.0))), (uv.y * 8.0)).x * 7.0)) / 7.0) + 4.0), 0.0, 0.1), 0.0, 0.1), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x / (1.3 / (uv.x * 2.0))) + (uv.x * 2.0)), audio1), (beats * 0.25)).y, 0.0, 0.1), 3.1416))));
c = (c * 0.9);
vec3 actualColor = vec3(1.0);
actualColor = (actualColor - (vec3(c.x) * r));
actualColor = (actualColor - (vec3(c.y) * g));
actualColor = (actualColor - (vec3(c.z) * b));
c = (vec3(l) * actualColor);
c = (c + (noise(pR(uv, Time), 0.5) * 0.021));
c = max(c, vec3(0.0));
c = (c / smoothstep(0.1, 0.3, (fract((beats / 2.0)) * 2.0)));
fsout_Color = vec4(c, 1.0);

}

