#version 450
layout(set = 0, binding = 0) uniform _Time { float Time; };
layout(set = 0, binding = 1) uniform _Offset { vec2 Offset; };
layout(set = 0, binding = 2) uniform _Zoom { float Zoom; };
layout(location = 0) in vec2 fsin_Position;
layout(location = 0) out vec4 fsout_Color;
float beat = 0.9375;
float beats = (Time / beat);
vec2 pR(vec2 p, float a)
{
p = ((p * cos(a)) + (vec2(p.y, (-p.x)) * sin(a)));
return p;

}

float rand1d(float n)
{
return fract((sin(n) * 43758.55));

}

float noise(vec2 uv, float intensity)
{
return min(1.0, ((1.0 / (rand1d(((uv.x * 20.0) + 1.0)) + rand1d((uv.y * 40.0)))) * intensity));

}

float spikeFunc(float x)
{
return max(min(min(fract(x / -2.) * 2. -1., sin((x + 1.) / 0.31831 ) + 1.), sin((x - 1.278) / 0.31831) + 0.645), 0.);

}

float superclamp(float val, float start, float end)
{
float dur = (end - start);
float halfdur = (dur / 2.0);
float prog = (clamp(val, start, end) - start);
return ((halfdur - abs((prog - halfdur))) / halfdur);

}

void main()
{
float audio1 = max(0.0, (0.1 - fract(((beats * 4.0) + 0.04))));
float audio2 = max(0.0, (0.1 - fract((((beats * 4.0) + 0.05) - 0.4))));
float audio3 = (step(1.5, (fract((beats / 2.0)) * 2.0)) - step(8.0, (fract((beats / 2.0)) * 2.0)));
vec2 uv = fsin_Position;
uv = vec2((uv.x + (audio1 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio2 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = vec2((uv.x + (audio3 * (noise(pR(vec2(uv.y), Time), 0.1) - 0.1))), uv.y);
uv = ((uv / 2.0) - Offset);
uv = (uv * (1.0 + (Zoom * Zoom)));
vec3 c = vec3(0.0);
vec3 r = vec3(0.68, 0.18, 0.14);
vec3 g = vec3(0.87, 0.89, 0.78);
vec3 b = vec3(0.0, 0.6, 0.96);
float l = clamp(length(vec2(length(vec2(pR((uv * 5.0), max(smoothstep(pR(vec2((tan(pR(vec2(pR(vec2((uv.y * 10.0), (pR(vec2((uv.y * 10.0), (pR(vec2((pR(vec2((uv.x * 10.0), (((pR(vec2(pR((uv * 1.5), (floor((max((tan(pR((uv * 5.0), (round((cos((max((pR((uv * 1.5), pR((uv * 1.5), pR((uv * 1.5), length(vec2(smoothstep(smoothstep(pR((uv * 5.0), pR(vec2((uv.y * 10.0), (-pR((uv * 1.5), (round((cos((pR(vec2((uv.y * 10.0), ((floor(((-(tan(sin(smoothstep(pR(vec2((pR(vec2(pR((uv * 5.0), pR(vec2((round((pR((uv * 1.5), ((tan((((tan(pR(vec2(pR(vec2(max(length(vec2(pR(vec2((uv.y * 10.0), (-max(pR((uv * 1.5), pR((uv * 1.5), (tan((pR((uv * 1.5), max(((round((length(vec2(pR(vec2(((-pR(vec2((uv.y * 10.0), pR((uv * 1.5), (-length(vec2(pR((uv * 5.0), pR(vec2(pR(vec2((tan((floor((sin((pR((uv * 1.5), ((tan(max(pR(vec2((round(((-pR((uv * 1.5), ((round(((floor((sin(pR((uv * 5.0), pR((uv * 5.0), (pR(vec2(length(vec2((floor(((floor((pR((uv * 1.5), pR(vec2((round((pR(vec2((uv.y * 10.0), (pR(vec2((uv.x * 10.0), ((round((pR((uv * 5.0), ((pR(vec2((uv.x * 10.0), pR((uv * 1.5), sin((cos(pR((uv * 5.0), (pR((uv * 1.5), (round(((pR(vec2(pR(vec2((uv.y * 10.0), pR(vec2((pR((uv * 5.0), (tan(length(vec2(pR((uv * 5.0), pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), smoothstep(cos(pR(vec2((uv.x * 10.0), pR(vec2(pR(vec2((uv.x * 10.0), pR((uv * 5.0), (pR((uv * 5.0), max(max((round((sin(pR(vec2((uv.x * 10.0), smoothstep(pR((uv * 5.0), (length(vec2(pR(vec2(pR(vec2(pR((uv * 1.5), sin((-cos((pR(vec2(pR((uv * 5.0), (pR(vec2((uv.x * 10.0), (tan(pR((uv * 1.5), pR(vec2((tan((tan((length(vec2(pR(vec2((uv.y * 10.0), pR((uv * 1.5), (pR(vec2((uv.y * 10.0), pR((uv * 5.0), (round((pR(vec2((uv.y * 10.0), max(sin(pR((uv * 5.0), pR(vec2(pR(vec2((uv.y * 10.0), pR(vec2((uv.x * 10.0), ((floor((pR((uv * 1.5), (pR(vec2(pR(vec2((uv.x * 10.0), cos((-pR((uv * 1.5), (tan(length(vec2((max((-(pR((uv * 1.5), pR((uv * 1.5), (pR((uv * 1.5), ((pR((uv * 5.0), length(vec2(cos(pR(vec2((floor((pR(vec2((uv.x * 10.0), (sin((-(pR(vec2(pR(vec2((floor(((pR((uv * 5.0), pR(vec2((uv.y * 10.0), (pR(vec2(max(pR((uv * 1.5), smoothstep(pR((uv * 1.5), pR((uv * 5.0), smoothstep((((length(vec2((tan((pR(vec2((uv.y * 10.0), pR(vec2(pR((uv * 5.0), pR(vec2((uv.y * 10.0), sin((floor((pR((uv * 5.0), pR(vec2(((-(round((((round((pR(vec2((uv.x * 10.0), pR(vec2(pR(vec2(pR(vec2(pR(vec2((pR((uv * 1.5), ((floor((pR(vec2((uv.y * 10.0), pR((uv * 1.5), (round((pR(vec2(pR((uv * 5.0), pR((uv * 1.5), (pR(vec2(pR((uv * 5.0), ((-(-max(pR((uv * 5.0), pR(vec2((uv.x * 10.0), (floor((smoothstep(pR(vec2((uv.x * 10.0), cos(((((tan(pR(vec2((uv.y * 10.0), (smoothstep(length(vec2(max(pR((uv * 1.5), sin(pR(vec2(pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), pR(vec2(length(vec2((floor((pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), sin(pR((uv * 5.0), (pR(vec2(cos(pR(vec2((tan((sin(length(vec2((((-pR((uv * 5.0), (pR(vec2((uv.x * 10.0), (pR((uv * 1.5), cos(pR((uv * 5.0), (round((length(vec2(sin(cos(max(pR(vec2((uv.y * 10.0), max((-smoothstep(pR(vec2(((-length(vec2((-max(pR(vec2(pR(vec2((uv.x * 10.0), (round(((tan(pR(vec2((uv.x * 10.0), pR((uv * 1.5), ((round(((length(vec2(pR(vec2((pR(vec2(max((-sin(smoothstep(sin(pR(vec2((pR(vec2((-pR((uv * 5.0), pR(vec2(smoothstep(((-sin(cos(length(vec2(((pR((uv * 5.0), (-pR(vec2((length(vec2((tan(pR(vec2(pR((uv * 5.0), pR(vec2((uv.y * 10.0), length(vec2((tan((floor((max(pR(vec2((uv.x * 10.0), ((sin((((-pR(vec2(pR((uv * 1.5), pR((uv * 5.0), pR(vec2((tan(max(pR((uv * 1.5), pR((uv * 5.0), pR((uv * 5.0), max(cos(((pR(vec2((uv.x * 10.0), pR((uv * 1.5), length(vec2(smoothstep(((pR(vec2((pR((uv * 5.0), pR(vec2(pR((uv * 5.0), max(sin((round((pR((uv * 5.0), max((-pR((uv * 1.5), pR((uv * 5.0), pR(vec2((uv.x * 10.0), ((pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), pR((uv * 5.0), pR(vec2(cos(sin(smoothstep(pR(vec2((uv.y * 10.0), pR(vec2((uv.x * 10.0), pR(vec2((uv.x * 10.0), cos(pR((uv * 1.5), pR(vec2(max(length(vec2(max(sin(pR((uv * 5.0), (round((((floor((pR((uv * 1.5), pR((uv * 5.0), cos(length(vec2(pR(vec2((uv.x * 10.0), (pR((uv * 5.0), pR((uv * 5.0), (max(smoothstep(pR((uv * 1.5), (max(pR((uv * 1.5), (-((pR(vec2(pR((uv * 1.5), pR(vec2((uv.y * 10.0), ((round(((floor((pR((uv * 5.0), smoothstep(smoothstep(pR((uv * 1.5), (length(vec2((round((pR(vec2((floor((length(vec2(pR(vec2(pR((uv * 1.5), pR(vec2(cos(length(vec2((tan(sin((uv.x * 2.0))) / 2.0), (length(uv) * 10.0)))), audio1), (beats * 0.25)).x).y, (length(uv) * 10.0)), (beats * 0.25)).y, audio2)) * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y * 7.0)) / 7.0), 4.0)) + (uv.y * 8.0))).y, 0.0, 0.1), 0.0, 0.1)).y * 7.0)) / 7.0) * 7.0)) / 7.0) + audio1)), 3.1416).y).x, 3.1416), (beats * 0.25)).y / (1.3 / audio1)) - (uv.x * 10.0)))).x, (uv.y * 1.5)) + (uv.y * 1.5))).y, 0.0, 0.1), sin(((beats * 1.57) * 0.25))) + (sin(((beats * 1.57) * 0.5)) * 4.0))).y).x + sin(((beats * 1.57) * 0.25)))), (uv.y * 1.5)).x, (uv.x * 2.0))))).y).y * 7.0)) / 7.0) - (length(uv) * 10.0)) * 7.0)) / 7.0)).y), sin(((beats * 1.57) * 0.25))), audio3)), (tan(((beats * 3.14) * 0.5)) / 2.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y).x)), (tan(((beats * 3.14) * 0.5)) / 2.0)).x), (length(uv) * 10.0)).x), (sin(((beats * 1.57) * 0.5)) * 4.0)).y, 0.0, 0.1))), (uv.x * 10.0)), (beats * 0.25)).y).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).x), 4.0).x + (uv.y * 1.5)) - 3.1416)), (length(uv) * 10.0)).x).y).x), 4.0)).x * 7.0)) / 7.0)), audio1)).x, 3.1416), (beats * 0.25)).x).y + (uv.x * 10.0)), (uv.y * 1.5)), (beats * 0.25)).x + (uv.x * 10.0)) - (uv.y * 8.0)), 0.0, 0.1), (uv.y * 1.5)))).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).x + 4.0) - (sin(((beats * 1.57) * 0.5)) * 4.0))), audio3)).x).x).x, (uv.x * 10.0))) / 2.0), 3.1416), (beats * 0.25)).y).x).x, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y) + 3.1416) + audio2)) - (uv.y * 1.5)) - (uv.y * 8.0))), (uv.y * 1.5)).x, (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0)) / 2.0), audio3))), (uv.y * 8.0)).y).x, (uv.y * 8.0)), (beats * 0.25)).x) / 2.0), (uv.x * 10.0))) / (1.3 / (length(uv) * 10.0))), audio2), (beats * 0.25)).y)).y / (1.3 / audio3)) + audio2), audio1))))) / (1.3 / audio3)), 0.0, 0.1), audio2), (beats * 0.25)).x).x), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y - 3.1416), (length(uv) * 10.0)), (beats * 0.25)).x), 0.0, 0.1))), 3.1416), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x - sin(((beats * 1.57) * 0.25))), (uv.y * 8.0)), (beats * 0.25)).y, audio3)) + audio2) * 7.0)) / 7.0) + audio2)).y), (uv.y * 1.5)).x) / 2.0) * 7.0)) / 7.0)), audio3).x, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x, (uv.y * 1.5))), (uv.y * 1.5)))) - audio3), (uv.x * 2.0)), (beats * 0.25)).x, 0.0, 0.1)), (uv.y * 8.0))), (uv.y * 1.5)).y, sin(((beats * 1.57) * 0.25))))), (length(uv) * 10.0))) * 7.0)) / 7.0)).y)).x + (uv.x * 2.0))), (uv.y * 8.0)).x + (uv.x * 10.0))).y) - audio2) - (tan(((beats * 3.14) * 0.5)) / 2.0)), (uv.y * 1.5)))) + audio2)) / 2.0), audio2), (beats * 0.25)).y), (uv.y * 8.0)), (beats * 0.25)).y / (1.3 / audio2))).y)), sin(((beats * 1.57) * 0.25))).x), (sin(((beats * 1.57) * 0.5)) * 4.0)).x * 7.0)) / 7.0), (sin(((beats * 1.57) * 0.5)) * 4.0))), audio3), (beats * 0.25)).y), (uv.x * 2.0)).x), (length(uv) * 10.0)).x, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y)).x, sin(((beats * 1.57) * 0.25))), (length(uv) * 10.0))), 0.0, 0.1) - (uv.x * 10.0))), 4.0).y) / 2.0) / (1.3 / (uv.y * 1.5))) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))) + (uv.y * 8.0)))), (uv.y * 1.5)).x, 0.0, 0.1) * 7.0)) / 7.0)), (uv.y * 8.0)).x).x, audio2))) - (sin(((beats * 1.57) * 0.5)) * 4.0))).y, (uv.x * 10.0)), (beats * 0.25)).y / (1.3 / audio1))).y).x, (uv.y * 1.5)), (beats * 0.25)).x * 7.0)) / 7.0)).x), (uv.x * 10.0)).y * 7.0)) / 7.0) / (1.3 / audio2))).y / (1.3 / sin(((beats * 1.57) * 0.25)))), (uv.y * 8.0)), (beats * 0.25)).x, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y, (uv.x * 2.0)), (beats * 0.25)).x, (uv.x * 10.0)), (beats * 0.25)).y), (length(uv) * 10.0)).x * 7.0)) / 7.0) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))) * 7.0)) / 7.0)) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))), audio3), (beats * 0.25)).y).x * 7.0)) / 7.0))), (length(uv) * 10.0)).y).y, audio2), (beats * 0.25)).y), (length(uv) * 10.0)).y + audio2)) / 2.0), sin(((beats * 1.57) * 0.25)))) - (uv.x * 10.0)) / (1.3 / (uv.x * 2.0))) - (sin(((beats * 1.57) * 0.5)) * 4.0)), 0.0, 0.1)).y).x, 0.0, 0.1)).x, (sin(((beats * 1.57) * 0.5)) * 4.0)), audio2), (beats * 0.25)).y / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0)))), 4.0).y).x / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))) * 7.0)) / 7.0), (uv.y * 8.0)), (beats * 0.25)).y, audio1), (beats * 0.25)).y / (1.3 / (sin(((beats * 1.57) * 0.5)) * 4.0))))) / (1.3 / 4.0))), (sin(((beats * 1.57) * 0.5)) * 4.0)).x * 7.0)) / 7.0), (uv.y * 8.0)), (beats * 0.25)).y), audio2))).y + audio3) - 4.0)).x + 4.0)).y).y - (sin(((beats * 1.57) * 0.5)) * 4.0))), 4.0) + (sin(((beats * 1.57) * 0.5)) * 4.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)))) / 2.0)).x))), audio3).x, 4.0), (beats * 0.25)).y / (1.3 / 4.0))).y * 7.0)) / 7.0) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0)))), (tan(((beats * 3.14) * 0.5)) / 2.0)).x), (uv.y * 1.5)).y, (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y).y), sin(((beats * 1.57) * 0.25)))), 3.1416).y * 7.0)) / 7.0)).y), sin(((beats * 1.57) * 0.25))).y / (1.3 / (uv.x * 2.0)))).x), (uv.x * 10.0)).y, (tan(((beats * 3.14) * 0.5)) / 2.0))) / (1.3 / (uv.x * 10.0)))) / 2.0)) / 2.0), 4.0), (beats * 0.25)).y).y) / 2.0)), sin(((beats * 1.57) * 0.25))).x + (length(uv) * 10.0))).x, audio3), (beats * 0.25)).x - audio3))))).y, (length(uv) * 10.0)), (beats * 0.25)).y, (uv.x * 2.0)), (beats * 0.25)).y, 3.1416)) / (1.3 / (uv.y * 8.0)))).y, 0.0, 0.1)), audio2).x) * 7.0)) / 7.0), audio1), 4.0)).x / (1.3 / (uv.x * 10.0)))).x), (uv.x * 2.0)).x, (uv.x * 10.0)), (beats * 0.25)).y), (uv.y * 8.0)).x), 0.0, 0.1)), (sin(((beats * 1.57) * 0.5)) * 4.0)).y), 3.1416).x).y, audio1))) / 2.0)).y / (1.3 / sin(((beats * 1.57) * 0.25)))), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x), (tan(((beats * 3.14) * 0.5)) / 2.0)).y, (uv.y * 8.0)), (beats * 0.25)).y + 3.1416) * 7.0)) / 7.0)).x + (tan(((beats * 3.14) * 0.5)) / 2.0))).x) / (1.3 / (length(uv) * 10.0))))).x), 3.1416).x - audio3) - (sin(((beats * 1.57) * 0.5)) * 4.0))).x * 7.0)) / 7.0) / (1.3 / (uv.y * 8.0)))), (uv.x * 10.0)).x + (uv.y * 8.0))), (uv.x * 2.0)).y * 7.0)) / 7.0), 4.0), (beats * 0.25)).y).x * 7.0)) / 7.0) * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25)))), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y / (1.3 / audio1))).x).y) * 7.0)) / 7.0) * 7.0)) / 7.0) - (sin(((beats * 1.57) * 0.5)) * 4.0))).x) * 7.0)) / 7.0), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y, sin(((beats * 1.57) * 0.25)))) / 2.0) / (1.3 / 4.0))).y + (uv.x * 2.0))) * 7.0)) / 7.0)) / 2.0), (uv.y * 8.0)), (beats * 0.25)).y, 3.1416), (beats * 0.25)).x).x, (uv.x * 2.0))))).y), (sin(((beats * 1.57) * 0.5)) * 4.0)).y) / (1.3 / (uv.y * 1.5))), (uv.x * 10.0)), (beats * 0.25)).y, audio1)) * 7.0)) / 7.0) / (1.3 / sin(((beats * 1.57) * 0.25)))), (uv.x * 10.0))).y - audio3)) / 2.0)).y).x, (uv.y * 8.0)))), (tan(((beats * 3.14) * 0.5)) / 2.0)).y, 4.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y, (uv.y * 1.5)), (beats * 0.25)).y) / 2.0) / (1.3 / 3.1416)) - audio1)) / 2.0) / (1.3 / audio2))).y * 7.0)) / 7.0), audio2), (beats * 0.25)).y).y, (uv.y * 1.5)), (beats * 0.25)).y / (1.3 / 3.1416)), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).x, 0.0, 0.1))) / 2.0)) * 7.0)) / 7.0) - audio1)), 4.0).y / (1.3 / sin(((beats * 1.57) * 0.25))))) * 7.0)) / 7.0)).y)), audio2).y).y, 0.0, 0.1), 0.0, 0.1), 3.1416))).y).x).x + (uv.x * 10.0)), audio3) - audio3)) * 7.0)) / 7.0)).x) / 2.0), (tan(((beats * 3.14) * 0.5)) / 2.0)) * 7.0)) / 7.0)).y, (uv.y * 1.5)), (beats * 0.25)).y + (uv.y * 8.0)) / (1.3 / audio3)) / (1.3 / (uv.x * 10.0)))), audio2).x - (uv.x * 10.0)), (uv.x * 2.0)), (beats * 0.25)).y - (uv.x * 2.0))), 4.0).y + 4.0)), sin(((beats * 1.57) * 0.25))).y, 3.1416), (beats * 0.25)).x) / 2.0), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y, 0.0, 0.1), 4.0)).y, (length(uv) * 10.0))), (sin(((beats * 1.57) * 0.5)) * 4.0))), 0.0, 0.95);
c = vec3((1.0 / pR(vec2((tan(pR(vec2((uv.x * 10.0), smoothstep((pR((uv * 5.0), sin(pR((uv * 5.0), pR((uv * 5.0), smoothstep(cos(pR(vec2((uv.x * 10.0), cos(max(((-(floor((pR(vec2((-((pR(vec2((tan(((tan(pR((uv * 5.0), length(vec2(pR(vec2(pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), length(vec2(cos(pR((uv * 1.5), pR(vec2(pR((uv * 5.0), pR((uv * 5.0), (tan(pR((uv * 1.5), pR(vec2(pR((uv * 1.5), length(vec2(pR(vec2((round((smoothstep(pR(vec2((pR((uv * 5.0), length(vec2(pR((uv * 1.5), (floor((max((round((pR(vec2((uv.y * 10.0), (floor((sin(pR(vec2((uv.x * 10.0), (round((pR(vec2((-pR((uv * 5.0), pR(vec2((uv.y * 10.0), pR(vec2(pR((uv * 1.5), (length(vec2(pR(vec2(((length(uv) * 10.0) + 3.1416), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x, (tan(((beats * 3.14) * 0.5)) / 2.0))) - (uv.x * 2.0))).x, (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y), sin(((beats * 1.57) * 0.25))).y).y), (length(uv) * 10.0)), (beats * 0.25)).x * 7.0)) / 7.0)), audio3).x) * 7.0)) / 7.0)), (sin(((beats * 1.57) * 0.5)) * 4.0)).y * 7.0)) / 7.0), (uv.y * 8.0)) * 7.0)) / 7.0)).y, (uv.x * 2.0)))).x - 3.1416), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).x, 0.0, 0.1) * 7.0)) / 7.0), sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y, audio2))).x, (uv.y * 8.0)), (beats * 0.25)).y).y) / 2.0)).x).x, audio2), (beats * 0.25)).y).x), audio3))), (uv.y * 1.5)).y), 3.1416).x, sin(((beats * 1.57) * 0.25))), (beats * 0.25)).y, (uv.y * 8.0)))).x) / 2.0) / (1.3 / (length(uv) * 10.0)))) / 2.0), 3.1416), (beats * 0.25)).x / (1.3 / sin(((beats * 1.57) * 0.25)))) + (sin(((beats * 1.57) * 0.5)) * 4.0))), (uv.x * 10.0)), (beats * 0.25)).y * 7.0)) / 7.0)) + (uv.x * 2.0)), (uv.y * 1.5)))), (uv.y * 1.5)).x), 0.0, 0.1)).y).y)).y - (tan(((beats * 3.14) * 0.5)) / 2.0)), 0.0, 0.1)), (tan(((beats * 3.14) * 0.5)) / 2.0)).x) / 2.0), (uv.y * 1.5)), (beats * 0.25)).x), (1.0 / (pR(vec2((-(tan((-(floor((pR((uv * 5.0), (((-pR(vec2((uv.x * 10.0), sin(max(sin(pR(vec2((uv.y * 10.0), (cos(pR(vec2(pR(vec2((uv.y * 10.0), pR((uv * 1.5), (round((cos((-pR((uv * 5.0), (smoothstep(pR(vec2((uv.y * 10.0), (-cos(smoothstep((-length(vec2(pR(vec2((uv.y * 10.0), max(pR((uv * 5.0), pR((uv * 5.0), (pR(vec2((uv.y * 10.0), pR(vec2(pR((uv * 1.5), pR((uv * 1.5), pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), pR(vec2((uv.y * 10.0), smoothstep((cos(cos(cos(sin(((cos((max((pR((uv * 5.0), (tan(pR((uv * 1.5), pR(vec2(pR((uv * 5.0), (uv.y * 8.0)).y, 4.0), (beats * 0.25)).y).x) / 2.0)).x / (1.3 / (length(uv) * 10.0))), (uv.x * 2.0)) / (1.3 / (uv.y * 1.5)))) - audio2) / (1.3 / (tan(((beats * 3.14) * 0.5)) / 2.0))))))) / (1.3 / (uv.y * 1.5))), 0.0, 0.1)), (tan(((beats * 3.14) * 0.5)) / 2.0)).y), audio3).y), 3.1416).x).y).x, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x), sin(((beats * 1.57) * 0.25))).y / (1.3 / (length(uv) * 10.0)))).y).x, audio1)), (length(uv) * 10.0)).y, (uv.y * 1.5)))), 0.0, 0.1)))), 4.0).y, 0.0, 0.1) - (length(uv) * 10.0))).y)) * 7.0)) / 7.0)).x), 4.0).y, audio1), (beats * 0.25)).y) + (uv.x * 2.0))), (uv.y * 1.5)).y), audio3))), audio2).x) + sin(((beats * 1.57) * 0.25))) - 4.0)).y * 7.0)) / 7.0))) / 2.0)), (uv.y * 1.5)), (beats * 0.25)).y - (sin(((beats * 1.57) * 0.5)) * 4.0))), (1.0 / ((pR((uv * 1.5), (round((pR(vec2(pR(vec2(pR((uv * 1.5), pR(vec2(pR(vec2((-pR(vec2((uv.x * 10.0), pR(vec2(pR(vec2((uv.y * 10.0), pR(vec2((uv.x * 10.0), pR(vec2((uv.y * 10.0), (-(((pR(vec2(max(pR((uv * 1.5), pR(vec2((uv.y * 10.0), (floor((pR(vec2((uv.y * 10.0), pR((uv * 1.5), (tan((((-pR((uv * 5.0), pR(vec2(max(cos((tan(pR((uv * 1.5), pR((uv * 1.5), smoothstep(pR(vec2(max(((pR((uv * 5.0), sin(smoothstep(pR(vec2((tan(smoothstep(max((pR((uv * 1.5), (floor(((-(tan(audio1) / 2.0)) * 7.0)) / 7.0)).x - 3.1416), sin(((beats * 1.57) * 0.25))), 0.0, 0.1)) / 2.0), 4.0), (beats * 0.25)).y, 0.0, 0.1))).x - audio2) + 4.0), 3.1416), audio3), (beats * 0.25)).x, 0.0, 0.1)).y).x) / 2.0)), (length(uv) * 10.0)), audio3), (beats * 0.25)).x).y) - 3.1416) + (uv.y * 1.5))) / 2.0)).x), sin(((beats * 1.57) * 0.25))).y * 7.0)) / 7.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)).y).x, (uv.x * 10.0)), (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).x + 3.1416) / (1.3 / (uv.x * 10.0))) + (uv.y * 8.0)))), (uv.x * 10.0)).y), 3.1416).x), (length(uv) * 10.0)).y, (uv.y * 1.5)), (beats * 0.25)).y), audio1).x), (sin(((beats * 1.57) * 0.5)) * 4.0)), (beats * 0.25)).y, 3.1416), (beats * 0.25)).x).x, (tan(((beats * 3.14) * 0.5)) / 2.0)), (beats * 0.25)).y, 3.1416), (beats * 0.25)).y * 7.0)) / 7.0)).y / (1.3 / audio3)) - audio3)));
c = (c * 0.9);
vec3 actualColor = vec3(1.0);
actualColor = (actualColor - (vec3(c.x) * r));
actualColor = (actualColor - (vec3(c.y) * g));
actualColor = (actualColor - (vec3(c.z) * b));
c = (vec3(l) * actualColor);
c = (c + (noise(pR(uv, Time), 0.5) * 0.021));
c = max(c, vec3(0.0));
c = (c / smoothstep(0.1, 0.3, (fract((beats / 2.0)) * 2.0)));
fsout_Color = vec4(c, 1.0);

}

