/*
 * Decompiled with CFR 0.152.
 */
package slideybopp.games.lessthan3.Controls;

import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import slideybopp.games.lessthan3.Controls.Direction;
import slideybopp.games.lessthan3.Game;

public class CustomSlider {
    private int x;
    private int y;
    private int length;
    private int travelLength;
    private int min = 0;
    private int max;
    private Direction direction;
    private int seekerSize = Game.SLIDER_SEEKER_SIZE;
    private int position = 0;
    private Rectangle track;
    private Rectangle seeker;
    private Rectangle progress;
    private Group sliderGroup;
    private boolean enabled = true;

    public CustomSlider(int x, int y, int length, Direction direction) {
        this.x = x;
        this.y = y;
        this.length = length;
        this.direction = direction;
        this.max = length;
        this.travelLength = length - this.seekerSize;
        this.track = new Rectangle(0.0, 0.0, (double)length, (double)Game.SLIDER_HORIZONTAL_HEIGHT);
        switch (direction) {
            case HorizontalToRight: {
                this.seeker = new Rectangle(0.0, 0.0, (double)this.seekerSize, (double)this.seekerSize);
                this.progress = new Rectangle(0.0, 0.0, 0.0, (double)Game.SLIDER_HORIZONTAL_HEIGHT);
                break;
            }
            case HorizontalToLeft: {
                this.seeker = new Rectangle((double)(length - Game.SLIDER_SEEKER_SIZE), 0.0, (double)this.seekerSize, (double)this.seekerSize);
                this.progress = new Rectangle((double)length, 0.0, 0.0, (double)Game.SLIDER_HORIZONTAL_HEIGHT);
            }
        }
        this.track.setFill((Paint)Color.WHITE);
        this.track.setStroke((Paint)Color.BLACK);
        this.track.getStyleClass().add((Object)"track");
        this.seeker.setFill((Paint)Color.RED);
        this.seeker.setStroke((Paint)Color.BLACK);
        this.seeker.getStyleClass().add((Object)"seeker-active");
        this.seeker.setCursor(Cursor.OPEN_HAND);
        this.progress.setFill((Paint)Color.GRAY);
        this.progress.getStyleClass().add((Object)"progress");
        this.sliderGroup = new Group();
        this.sliderGroup.setLayoutX((double)x);
        this.sliderGroup.setLayoutY((double)y);
        this.sliderGroup.getChildren().addAll((Object[])new Node[]{this.track, this.progress, this.seeker});
    }

    public Group getSliderGroup() {
        return this.sliderGroup;
    }

    public Node getSeeker() {
        return this.seeker;
    }

    public Rectangle getProgress() {
        return this.progress;
    }

    public int getSeekerSize() {
        return this.seekerSize;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(Integer pos) {
        if (this.enabled) {
            switch (this.direction) {
                case HorizontalToRight: {
                    this.position = pos;
                    this.seeker.setLayoutX((double)this.position);
                    this.progress.setWidth((double)this.position);
                    break;
                }
                case HorizontalToLeft: {
                    this.position = this.length - pos;
                    this.seeker.setLayoutX((double)(-this.position + this.seekerSize));
                    this.progress.setLayoutX((double)(-this.position + this.seekerSize));
                    this.progress.setWidth((double)(this.position - this.seekerSize));
                }
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getLength() {
        return this.length;
    }

    public int getTravelLength() {
        return this.travelLength;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.seeker.setFill((Paint)Color.RED);
            this.seeker.setCursor(Cursor.OPEN_HAND);
            this.seeker.getStyleClass().add((Object)"seeker-active");
            this.seeker.getStyleClass().remove((Object)"seeker-disabled");
        } else {
            this.seeker.setFill((Paint)Color.BLACK);
            this.seeker.setCursor(Cursor.DEFAULT);
            this.seeker.getStyleClass().remove((Object)"seeker-active");
            this.seeker.getStyleClass().add((Object)"seeker-disabled");
        }
    }
}

