const unsigned char bars_palette[16]={ 0x0f,0x28,0x2c,0x30,0x0f,0x14,0x2c,0x2a,0x0f,0x14,0x16,0x11,0x0f,0x00,0x10,0x30 };



#include "data/bars.h"

#define BAR_STEPS_ALL		238

const unsigned int bars_offset[BAR_STEPS_ALL]={
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0028,0x0028,
	0x0028,0x0028,0x0028,0x0050,0x0050,0x0050,0x0050,0x0078,
	0x00a0,0x00a0,0x00c8,0x00f0,0x0118,0x0118,0x0140,0x0168,
	0x0190,0x01b8,0x01e0,0x01e0,0x0208,0x0230,0x0258,0x0280,
	0x02a8,0x02d0,0x02f8,0x0320,0x0348,0x0370,0x0370,0x0398,
	0x03c0,0x03e8,0x0410,0x0438,0x0460,0x0488,0x04b0,0x04b0,
	0x04d8,0x0500,0x0528,0x0550,0x0578,0x05a0,0x05c8,0x05f0,
	0x0618,0x0618,0x0640,0x0668,0x0690,0x06b8,0x06e0,0x0708,
	0x0708,0x0730,0x0758,0x0780,0x07a8,0x07d0,0x07f8,0x07f8,
	0x07f8,0x0820,0x0820,0x0820,0x0848,0x0870,0x0870,0x0898,
	0x08c0,0x08c0,0x08e8,0x0910,0x0910,0x0910,0x0910,0x0910,
	0x0938,0x0960,0x0960,0x0960,0x0988,0x0988,0x0988,0x09b0,
	0x09b0,0x09b0,0x09b0,0x09b0,0x09b0,0x09b0,0x09b0,0x09d8,
	0x09d8,0x09d8,0x09d8,0x09d8,0x09d8,0x09d8,0x0a00,0x09b0,
	0x09b0,0x09b0,0x09b0,0x09b0,0x09b0,0x09b0,0x09b0,0x0988,
	0x0988,0x0960,0x0960,0x0960,0x0938,0x0910,0x0910,0x0910,
	0x0910,0x0910,0x08e8,0x08c0,0x08c0,0x0898,0x0870,0x0870,
	0x0848,0x0848,0x0820,0x0820,0x0820,0x07f8,0x07f8,0x07d0,
	0x07a8,0x07a8,0x0758,0x0730,0x0708,0x0708,0x06e0,0x06b8,
	0x0690,0x0668,0x0640,0x0618,0x0618,0x05f0,0x0a28,0x05a0,
	0x0578,0x0578,0x0528,0x0a50,0x04d8,0x04b0,0x04b0,0x0488,
	0x0460,0x0438,0x0a78,0x03c0,0x0398,0x0370,0x0348,0x0aa0,
	0x02a8,0x0258,0x0208,0x01e0,0x0168,0x0118,0x00a0,0x0050,
	0x0000,0x0ac8,0x0af0,0x0b18,0x0b40,0x0b68,0x0b90,0x0bb8,
	0x0be0,0x0c08,0x0c30,0x0c58,0x0c80,0x0ca8,0x0cd0,0x0cf8,
	0x0d20,0x0d48,0x0d70,0x0d98,0x0dc0,0x0de8,0x0e10,0x0e38,
	0x0e60,0x0e88,0x0eb0,0x0ed8,0x0f00,0x0f28,0x0f50,0x0f78,
	0x0fa0,0x0fc8,0x0ff0,0x1018,0x1040,0x1068,0x1090,0x10b8,
	0x10e0,0x1108,0x1130,0x1158,0x1180,0x11a8,0x11d0,0x11f8,
	0x1220,0x1248,0x1270,0x1298,0x12c0,0x12c0,
};

const unsigned char bars_digits[33*20]={
	0x40,0x41,0x42,0x43,0x44,0x42,0x45,0x46,0x42,0x47,0x46,0x42,0x48,0x49,0x42,0x4a,0x4b,0x42,0x4c,0x4d,0x42,0x4e,0x4f,0x42,0x50,0x46,0x42,0x50,0x51,0x42,0x40,0x52,0x53,
	0x54,0x55,0x56,0x57,0x58,0x56,0x59,0x5a,0x56,0x5b,0x5c,0x56,0x5d,0x5e,0x56,0x5f,0x55,0x56,0x60,0x5c,0x56,0x61,0x62,0x56,0x63,0x5c,0x56,0x64,0x65,0x56,0x54,0x66,0x53,
	0x40,0x52,0x67,0x43,0x53,0x67,0x45,0x68,0x67,0x47,0x68,0x67,0x48,0x69,0x67,0x4a,0x6a,0x67,0x4c,0x6b,0x67,0x4e,0x6c,0x67,0x50,0x68,0x67,0x50,0x6d,0x67,0x43,0x53,0x53,
	0x54,0x66,0x6e,0x57,0x6f,0x6e,0x59,0x70,0x6e,0x5b,0x71,0x6e,0x5d,0x72,0x6e,0x5f,0x66,0x6e,0x60,0x71,0x6e,0x61,0x73,0x6e,0x63,0x71,0x6e,0x64,0x74,0x6e,0x57,0x6f,0x53,
	0x40,0x75,0x76,0x43,0x77,0x76,0x45,0x78,0x76,0x47,0x78,0x76,0x48,0x79,0x76,0x4a,0x7a,0x76,0x4c,0x7b,0x76,0x4e,0x7c,0x76,0x50,0x78,0x76,0x50,0x7d,0x76,0x45,0x68,0x53,
	0x54,0x7e,0x7f,0x57,0x80,0x7f,0x59,0x81,0x7f,0x5b,0x82,0x7f,0x5d,0x83,0x7f,0x5f,0x7e,0x7f,0x60,0x82,0x7f,0x61,0x84,0x7f,0x63,0x82,0x7f,0x64,0x85,0x7f,0x59,0x70,0x53,
	0x40,0x75,0x86,0x43,0x77,0x86,0x45,0x78,0x86,0x47,0x78,0x86,0x48,0x79,0x86,0x4a,0x7a,0x86,0x4c,0x7b,0x86,0x4e,0x7c,0x86,0x50,0x78,0x86,0x50,0x7d,0x86,0x47,0x68,0x53,
	0x54,0x87,0x88,0x57,0x89,0x88,0x59,0x8a,0x88,0x5b,0x8b,0x88,0x5d,0x8c,0x88,0x5f,0x87,0x88,0x60,0x8b,0x88,0x61,0x8d,0x88,0x63,0x8b,0x88,0x64,0x8e,0x88,0x5b,0x71,0x53,
	0x40,0x8f,0x90,0x43,0x91,0x90,0x45,0x92,0x90,0x47,0x92,0x90,0x48,0x93,0x90,0x4a,0x94,0x90,0x4c,0x95,0x90,0x4e,0x96,0x90,0x50,0x92,0x90,0x50,0x97,0x90,0x48,0x69,0x53,
	0x54,0x98,0x99,0x57,0x9a,0x99,0x59,0x9b,0x99,0x5b,0x9c,0x99,0x5d,0x9d,0x99,0x5f,0x98,0x99,0x60,0x9c,0x99,0x61,0x9e,0x99,0x63,0x9c,0x99,0x64,0x9f,0x99,0x5d,0x72,0x53,
	0x40,0xa0,0xa1,0x43,0xa2,0xa1,0x45,0xa3,0xa1,0x47,0xa3,0xa1,0x48,0xa4,0xa1,0x4a,0xa5,0xa1,0x4c,0xa6,0xa1,0x4e,0xa7,0xa1,0x50,0xa3,0xa1,0x50,0xa8,0xa1,0x4a,0x6a,0x53,
	0x54,0x87,0xa9,0x57,0x89,0xa9,0x59,0x8a,0xa9,0x5b,0x8b,0xa9,0x5d,0x8c,0xa9,0x5f,0x87,0xa9,0x60,0x8b,0xa9,0x61,0x8d,0xa9,0x63,0x8b,0xa9,0x64,0x8e,0xa9,0x5f,0x66,0x53,
	0x40,0x41,0xaa,0x43,0x44,0xaa,0x45,0x46,0xaa,0x47,0x46,0xaa,0x48,0x49,0xaa,0x4a,0x4b,0xaa,0x4c,0x4d,0xaa,0x4e,0x4f,0xaa,0x50,0x46,0xaa,0x50,0x51,0xaa,0x4c,0x6b,0x53,
	0x54,0x55,0xab,0x57,0x58,0xab,0x59,0x5a,0xab,0x5b,0x5c,0xab,0x5d,0x5e,0xab,0x5f,0x55,0xab,0x60,0x5c,0xab,0x61,0x62,0xab,0x63,0x5c,0xab,0x64,0x65,0xab,0x60,0x71,0x53,
	0x40,0xac,0xad,0x43,0xae,0xad,0x45,0xaf,0xad,0x47,0xaf,0xad,0x48,0xb0,0xad,0x4a,0xb1,0xad,0x4c,0xb2,0xad,0x4e,0xb3,0xad,0x50,0xaf,0xad,0x50,0xb4,0xad,0x4e,0x6c,0x53,
	0x54,0x66,0xb5,0x57,0x6f,0xb5,0x59,0x70,0xb5,0x5b,0x71,0xb5,0x5d,0x72,0xb5,0x5f,0x66,0xb5,0x60,0x71,0xb5,0x61,0x73,0xb5,0x63,0x71,0xb5,0x64,0x74,0xb5,0x61,0x73,0x53,
	0x40,0xb6,0xb7,0x43,0xb8,0xb7,0x45,0xb9,0xb7,0x47,0xb9,0xb7,0x48,0xba,0xb7,0x4a,0xbb,0xb7,0x4c,0xbc,0xb7,0x4e,0xbd,0xb7,0x50,0xb9,0xb7,0x50,0xbe,0xb7,0x50,0x68,0x53,
	0x54,0xbf,0xc0,0x57,0xc1,0xc0,0x59,0xc2,0xc0,0x5b,0xc3,0xc0,0x5d,0xc4,0xc0,0x5f,0xbf,0xc0,0x60,0xc3,0xc0,0x61,0xc5,0xc0,0x63,0xc3,0xc0,0x64,0xc6,0xc0,0x63,0x71,0x53,
	0x40,0xb6,0xc7,0x43,0xb8,0xc7,0x45,0xb9,0xc7,0x47,0xb9,0xc7,0x48,0xba,0xc7,0x4a,0xbb,0xc7,0x4c,0xbc,0xc7,0x4e,0xbd,0xc7,0x50,0xb9,0xc7,0x50,0xbe,0xc7,0x50,0x6d,0x53,
	0x54,0x87,0xc8,0x57,0x89,0xc8,0x59,0x8a,0xc8,0x5b,0x8b,0xc8,0x5d,0x8c,0xc8,0x5f,0x87,0xc8,0x60,0x8b,0xc8,0x61,0x8d,0xc8,0x63,0x8b,0xc8,0x64,0x8e,0xc8,0x64,0x74,0x53
};



void e_bars_put_digit(unsigned char off,unsigned char n,unsigned char single)
{
	unsigned int ps;

	if(!single)
	{
		ps=(n/10)*3+(n%10)*33*2;
	}
	else
	{
		ps=10*3+(n%10)*33*2;
	}
	
	update_list[off+3+0]=bars_digits[ps+0];
	update_list[off+3+1]=bars_digits[ps+1];
	update_list[off+3+2]=bars_digits[ps+2];
	update_list[off+30+0]=bars_digits[ps+33+0];
	update_list[off+30+1]=bars_digits[ps+33+1];
	update_list[off+30+2]=bars_digits[ps+33+2];
}



void e_bars_put_semicolon(unsigned char off,unsigned char tile)
{
	update_list[ 3+off]=tile+0;
	update_list[30+off]=tile+1;
}



void e_bars_set_time(unsigned int frame)
{
	unsigned int adr;
	unsigned char tile;

	adr=NTADR_A(4,21);
	
	update_list[0]=MSB(adr)|NT_UPD_HORZ;
	update_list[1]=LSB(adr);
	update_list[2]=24;

	adr+=32;
	
	update_list[27]=MSB(adr)|NT_UPD_HORZ;
	update_list[28]=LSB(adr);
	update_list[29]=24;
	
	update_list[54]=NT_UPD_EOF;
	
	e_bars_put_digit(1,0,0);
	e_bars_put_digit(6,frame/60/60%100,0);
	e_bars_put_digit(11,frame/60%60,0);
	e_bars_put_digit(16,frame/2%30,0);
	e_bars_put_digit(21,frame%10,1);
	
	tile=frame%60<30?0xd0:0xd2;
	
	e_bars_put_semicolon( 5,tile);
	e_bars_put_semicolon(10,tile);
	e_bars_put_semicolon(15,tile);
	e_bars_put_semicolon(20,tile);
}



void e_bars_set_line(unsigned int adr,unsigned char step)
{
	unsigned int ptr;

	update_list[0]=MSB(adr)|NT_UPD_HORZ;
	update_list[1]=LSB(adr);
	update_list[2]=32;
	
	adr=(adr&~1023)+960+(((adr&1023)>>7)<<3);	//corresponding attribute offset

	update_list[35]=MSB(adr)|NT_UPD_HORZ;
	update_list[36]=LSB(adr);
	update_list[37]=8;
	
	update_list[46]=NT_UPD_EOF;
	
	ptr=bars_offset[step];
	
	memcpy(&update_list[ 3],&bars_data[ptr+ 0],32);
	memcpy(&update_list[38],&bars_data[ptr+32],8);
}



void e_bars(void)
{
	unsigned char i,chr,bar_step,bright,cnt;
	unsigned int adr,frame,time_code;
	signed int sy;
	signed char dy;
	
	chr=CHR_BARS;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);

	mmc3_set_mirroring(M_HORIZONTAL);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	pal_bg(bars_palette);

	time_code=(3*60+37)*60;
	frame=0;
	bar_step=0;
	sy=0;
	dy=-2<<5;
	cnt=0;
	
	memfill(update_list,NT_UPD_EOF,sizeof(update_list));
	
	//fill both nametables with bars
	
	adr=NAMETABLE_A;
	
	for(i=0;i<30;++i)
	{
		e_bars_set_line(adr,bar_step);
		flush_vram_update();
		
		adr+=32;
	}
	
	adr=NAMETABLE_C;
	
	for(i=0;i<30;++i)
	{
		e_bars_set_line(adr,bar_step);
		flush_vram_update();
		
		adr+=32;
	}
	
	//set attributes of the time code area
	
	adr=NTADR_A(0,20);
	
	e_bars_set_line(adr,bar_step);
	
	for(i=0;i<6;++i) update_list[39+i]=0xff;

	flush_vram_update();
	
	//clear rectangle of the time code area
	
	memfill(update_list,NT_UPD_EOF,sizeof(update_list));
	
	for(i=0;i<4;++i)
	{
		vram_adr(NTADR_A(4,20+i));
		vram_fill(0,24);
	}
	
	//prerare row list
	
	memfill(split_list,0,sizeof(split_list));
	
	for(i=0;i<30*2;i+=2)
	{
		split_list[i+0]=0x20;
		split_list[i+1]=0x00;
	}
	
	pal_bright(4);
	scroll(0,0);
	
	ppu_on_bg();
	
	while(1)
	{
		e_bars_set_time(time_code);
		
		scroll(0,(sy>>5));
		
		set_vram_update();
		
		ppu_wait_nmi();
		
		if(frame>60*3)
		{
			sy-=dy;
			
			if(sy<0) sy+=(480<<5);
			if(dy<(7<<4)) dy+=4;
			
			++cnt;
			
			if(cnt>=57) break;
		}
		
		++frame;
		--time_code;
	}
	
	set_irq_handler(IRQ_ROW_ADR);
	mmc3_irq_enable(7);
	
	while(bar_step<BAR_STEPS_ALL)
	{
		e_bars_set_line(NAMETABLE_A,bar_step);
		
		set_vram_update();
		
		scroll(0,0);
		
		ppu_wait_nmi();
		
		++bar_step;

		++frame;
	}
	
	bright=5;
	
	while(bright<8)
	{
		pal_bright(bright++);
		delay(4);
	}
	
	for(i=0;i<16;++i) if(i&3) pal_col(i,0x31);
	
	do
	{
		pal_bright(bright--);
		delay(6);
	} while(bright>0);
	
	ppu_off();
	
	mmc3_irq_enable(0);
}