const unsigned char based_palette[32]={
	0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,
	0x0f,0x18,0x28,0x38,0x0f,0x08,0x18,0x28,0x0f,0x0f,0x08,0x18,0x0f,0x0f,0x0f,0x08
};

const char based_text[]="BASED ON TRUE EFFECTS";

#define	EBA_X		5
#define EBA_Y		14
#define EBA_XOFF	4

void e_based(void)
{
	unsigned char x,y,sx,sy,c,ptr,pal,chr;
	signed char cnt,anim,len,frame;
	unsigned int adr;

	oam_clear_fast();
	oam_size(0);
	oam_update();

	chr=CHR_FONT;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);

	mmc3_set_mirroring(M_HORIZONTAL);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	pal_all(based_palette);
	pal_bright(4);
	
	vram_adr(NAMETABLE_A);
	vram_fill(0,1024);

	scroll(-EBA_XOFF,0);
	
	memfill(update_list,NT_UPD_EOF,sizeof(update_list));
	
	frame=0;
	anim=-8;
	len=sizeof(based_text);
				
	ppu_on_all();
	
	while(1)
	{
		oam_clear_fast();
		
		oam_off=0;
		upd_off=0;
		
		ptr=0;
		cnt=0;
		x=EBA_X;
		y=EBA_Y;
		sx=(x<<3)+EBA_XOFF;
		sy=(y<<3)-1;

		while(1)
		{
			c=based_text[ptr++];

			if(!c) break;

			c=c-0x20+0x60;

			if(cnt>=anim&&cnt<anim+8)
			{
				pal=(cnt-anim)>>1;

				oam_spr(sx,sy,c,pal,oam_off);

				oam_off+=4;
			}

			if(cnt==anim-1)
			{
				adr=NTADR_A(x,y);

				update_list[upd_off++]=MSB(adr);
				update_list[upd_off++]=LSB(adr);
				update_list[upd_off++]=c;
			}

			sx+=8;

			++x;
			++cnt;
		}

		update_list[upd_off]=NT_UPD_EOF;
		
		set_vram_update();
		
		oam_update();

		ppu_wait_nmi();
		
		if(frame&1) if(anim<len) ++anim; else break;
		
		++frame;
	}

	delay(60*3);
	
	anim=-8;
	len=sizeof(based_text);
	
	while(1)
	{
		oam_clear_fast();
		
		oam_off=0;
		upd_off=0;
		
		ptr=0;
		cnt=0;
		x=EBA_X;
		y=EBA_Y;
		sx=(x<<3)+EBA_XOFF;
		sy=(y<<3)-1;

		while(1)
		{
			c=based_text[ptr++];

			if(!c) break;

			c=c-0x20+0x60;

			if(cnt>=anim&&cnt<anim+8)
			{
				pal=((cnt-anim)>>1)^3;

				oam_spr(sx,sy,c,pal,oam_off);

				oam_off+=4;
			}

			if(cnt==anim-1)
			{
				adr=NTADR_A(x,y);

				update_list[upd_off++]=MSB(adr);
				update_list[upd_off++]=LSB(adr);
				update_list[upd_off++]=0;
			}

			sx+=8;

			++x;
			++cnt;
		}

		update_list[upd_off]=NT_UPD_EOF;
		
		set_vram_update();
		
		oam_update();

		ppu_wait_nmi();
		
		if(frame&1) if(anim<len) ++anim; else break;
		
		++frame;
	}
	
	ppu_off();
}