//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Runtime.InteropServices;
using Framefield.Core.Rendering;
using SharpDX.D3DCompiler;
using SharpDX.Direct3D;
using SharpDX.DXGI;
using Buffer = SharpDX.Direct3D11.Buffer;
using System.CodeDom.Compiler;

namespace Framefield.Core.ID3901e8c8_1a8e_4f1f_94ee_1b25153520b5
{
    public class Class_CSMeshDuplicate : FXSourceCodeFunction, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Mesh = 1
        }
        //<<< _inputids

        public override void Dispose()
        {
            _inputMesh = null;
            Utilities.DisposeObj(ref _outputMesh);
            Utilities.DisposeObj(ref _outputUAV);
            Utilities.DisposeObj(ref _vertexSRV);
            Utilities.DisposeObj(ref _csDuplicateMesh);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Mesh = inputs[(int)InputId.Mesh].Eval(context).Mesh;
            //<<< _params

            if (_csDuplicateMesh == null)
            {
                Utilities.DisposeObj(ref _csDuplicateMesh);
                var errors = new CompilerErrorCollection();
                try
                {
                    using (var bytecode = ShaderBytecode.Compile(GetCode(0), "CS_DuplicateVertices", "cs_5_0", ShaderFlags.Debug))
                        _csDuplicateMesh = new ComputeShader(D3DDevice.Device, bytecode);
                }
                catch (SharpDX.CompilationException ex)
                {
                    errors = ErrorsFromString(ex.Message);
                    Logger.Error(this,"Fx compile error: {0}", ex.Message);
                }
            }

            var numVerticesInMesh = Mesh.Vertices.Description.SizeInBytes/Mesh.AttributesSize;
            //Logger.Info("num vertices: {0}, inputLayoutSize: {1}, num tringles: {2}", numVerticesInMesh, Mesh.AttributesSize, Mesh.NumTriangles);

            if (_inputMesh != Mesh)
            {
                Utilities.DisposeObj(ref _vertexSRV);
                var bufferResource = new ShaderResourceViewDescription.ExtendedBufferResource()
                                         {
                                             ElementCount = Mesh.Vertices.Description.SizeInBytes/4,
                                             FirstElement = 0,
                                             Flags = ShaderResourceViewExtendedBufferFlags.Raw
                                         };
                var srvDesc = new ShaderResourceViewDescription()
                                  {
                                      Format = Format.R32_Typeless,
                                      Dimension = ShaderResourceViewDimension.ExtendedBuffer,
                                      BufferEx = bufferResource
                                  };
                _vertexSRV = new ShaderResourceView(context.D3DDevice, Mesh.Vertices, srvDesc);
                _inputMesh = Mesh;
            }

            if (_outputMesh == null || _outputMesh.NumTriangles != _inputMesh.NumTriangles)
            {
//                Logger.Info(this, "create output mesh");
                Utilities.DisposeObj(ref _outputMesh);
                Utilities.DisposeObj(ref _outputUAV);
               
                var vertices = new Buffer(context.D3DDevice, new BufferDescription
                                                                 {
                                                                     BindFlags = BindFlags.VertexBuffer | BindFlags.UnorderedAccess,
                                                                     CpuAccessFlags = CpuAccessFlags.None,
                                                                     OptionFlags = ResourceOptionFlags.BufferAllowRawViews,
                                                                     SizeInBytes = _inputMesh.NumTriangles*3*_inputMesh.AttributesSize,
                                                                     Usage = ResourceUsage.Default
                                                                 });
                _outputMesh = new Mesh
                                  {
                                      InputElements = _inputMesh.InputElements,
                                      Vertices = vertices,
                                      NumTriangles = _inputMesh.NumTriangles,
                                      AttributesSize = _inputMesh.AttributesSize
                                  };    
                                  
                var bufferResource = new UnorderedAccessViewDescription.BufferResource()
                                         {
                                             ElementCount = Mesh.Vertices.Description.SizeInBytes/4,
                                             FirstElement = 0,
                                             Flags = UnorderedAccessViewBufferFlags.Raw
                                         };
                var srvDesc = new UnorderedAccessViewDescription()   
                                  {
                                      Format = Format.R32_Typeless,
                                      Dimension = UnorderedAccessViewDimension.Buffer,
                                      Buffer = bufferResource
                                  };
                _outputUAV = new UnorderedAccessView(context.D3DDevice, _outputMesh.Vertices, srvDesc);                                  
            }

            var deviceContext = context.D3DDevice.ImmediateContext;

            deviceContext.ComputeShader.Set(_csDuplicateMesh);
            deviceContext.ComputeShader.SetUnorderedAccessView(0, _outputUAV);
            deviceContext.ComputeShader.SetShaderResource(0, _vertexSRV);
            deviceContext.Dispatch(1, 1, 1);

            deviceContext.ComputeShader.SetUnorderedAccessView(0, null);
            deviceContext.ComputeShader.SetShaderResource(0, null);

            context.Mesh = _outputMesh;

            return context;
        }

        private Mesh _inputMesh;
        private ShaderResourceView _vertexSRV;
        private Mesh _outputMesh;
        private UnorderedAccessView _outputUAV;
        private ComputeShader _csDuplicateMesh;
    }
}

