//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;

namespace Framefield.Core.IDa3bdc85e_d0c8_4931_97b6_229d4bf46232
{
    public class Class_CacheImages : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            StringList = 0
        }
        //<<< _inputids

        public override void Dispose()
        {
            foreach (var i in _imageResources)
                i.Dispose();
            _imageResources.Clear();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> params
            dynamic StringList = inputs[(int)InputId.StringList].Eval(context).Dynamic;
            //<<< params

            if (StringList == null)
            {
                Changed = true;
                Logger.Info(this, "Can't convert incoming structure to Dynamic");
                return context;
            }
            
            if (Changed)
            {
                Changed = false;
                Dispose();
                for (int i = 0; i < StringList.Count; ++i)
                {
                    try
                    {
                        if (File.Exists(StringList[i]))
                        {
                            var r = ResourceManager.ReadImage(StringList[i]);
                            if (r != null)
                                _imageResources.Add(r);
                        }
                    }
                    catch
                    {
                        continue;
                    }
                }
            }

            return context;
        }

        List<ImageResource> _imageResources = new List<ImageResource>();
    }
}

