//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID1afa7cf9_bd39_4171_8653_5a83b328edfe
{
    public class Class_ColorizeFixedPlatte : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            AmpDist = 2,
            Gamma = 3,
            Bright = 4,
            ResolutionWidth = 5,
            ResolutionHeight = 6,
            Contrast = 7
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var AmpDist = inputs[(int)InputId.AmpDist].Eval(context).Value;
            var Gamma = inputs[(int)InputId.Gamma].Eval(context).Value;
            var Bright = inputs[(int)InputId.Bright].Eval(context).Value;
            var ResolutionWidth = inputs[(int)InputId.ResolutionWidth].Eval(context).Value;
            var ResolutionHeight = inputs[(int)InputId.ResolutionHeight].Eval(context).Value;
            var Resolution = new Vector2(ResolutionWidth, ResolutionHeight);
            var Contrast = inputs[(int)InputId.Contrast].Eval(context).Value;
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("AmpDist").AsScalar().Set(AmpDist);
                    _effect.GetVariableByName("Gamma").AsScalar().Set(Gamma);
                    _effect.GetVariableByName("Bright").AsScalar().Set(Bright);
                    _effect.GetVariableByName("Resolution").AsVector().Set(new Vector2(ResolutionWidth, ResolutionHeight));
                    _effect.GetVariableByName("Contrast").AsScalar().Set(Contrast);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

