//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID4fa4950f_2dd9_4acb_bc0f_8cd688b84805
{
    public class Class_CrosshatchEdges : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Density = 2,
            width = 3,
            rgbContrastX = 4,
            rgbContrastY = 5,
            rgbContrastZ = 6
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Density = inputs[(int)InputId.Density].Eval(context).Value;
            var width = inputs[(int)InputId.width].Eval(context).Value;
            var rgbContrastX = inputs[(int)InputId.rgbContrastX].Eval(context).Value;
            var rgbContrastY = inputs[(int)InputId.rgbContrastY].Eval(context).Value;
            var rgbContrastZ = inputs[(int)InputId.rgbContrastZ].Eval(context).Value;
            var rgbContrast = new Vector3(rgbContrastX, rgbContrastY, rgbContrastZ);
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Density").AsScalar().Set(Density);
                    _effect.GetVariableByName("width").AsScalar().Set(width);
                    _effect.GetVariableByName("rgbContrast").AsVector().Set(new Vector3(rgbContrastX, rgbContrastY, rgbContrastZ));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

