//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;


namespace Framefield.Core.IDc533f1ca_660b_4210_8c89_cf926f498e8e
{

    public class Class_FlatImageShader : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            Background = 2,
            ColorR = 3,
            ColorG = 4,
            ColorB = 5,
            ColorA = 6
        }
        //<<< _inputids
        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context) {
                base.SetupEffect(context);

                try {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e) {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc {get;set;}            
        }
        #endregion

        public Class_FlatImageShader() {
            _renderer = new Renderer(){ParentFunc = this};
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            // >>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var Background = inputs[(int)InputId.Background].Eval(context).Image; // Needs to be checked for null!
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            // <<< _params
            
            if(Background == null)
                return context;
            
            if (_firstEval) {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer")) 
            
            using (var BackgroundView = new ShaderResourceView(context.D3DDevice, Background))
            {
                _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(context.Viewport.Width, context.Viewport.Height));
                _effect.GetVariableByName("Background").AsShaderResource().SetResource(BackgroundView);
                _effect.GetVariableByName("Color").AsVector().Set( Color);
       
                context.Effect = _effect;
                context.Renderer = _renderer;
                Scene.Eval(context);
            }                       
            return context;
        }

        Renderer _renderer;
    }
}


