//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.Direct3D;
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID076eed96_398d_4ad4_88e6_089af155920c
{
    public class Class_GroupMesh : FXSourceCodeFunction, IFXSceneSourceCode
    {
        //>>> _inputids
        private enum InputId
        {
            InputMeshes = 0
        }
        //<<< _inputids

        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _bakedMesh);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);
                context.Mesh = _bakedMesh;
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Failed: {0}", exception.Message);
            }
            return context;
        }

        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (!Changed && _bakedMesh.Vertices != null)
            {
                return;
            }

            var InputMeshes = inputs[(int)InputId.InputMeshes];
            if (InputMeshes.Connections.Count == 0)
            {
                return;            
            }
                        
            _bakedMesh.NumTriangles = 0;
            Mesh mesh = null;
            
            var evaluatedMeshes = new List<Mesh>();
            foreach( var input in InputMeshes.Connections) 
            {
                mesh = input.Eval(context).Mesh;
                evaluatedMeshes.Add(mesh);
                _bakedMesh.NumTriangles += mesh.NumTriangles;
            }
            
            _bakedMesh.AttributesSize = mesh.AttributesSize;
            _bakedMesh.InputElements = mesh.InputElements;

            int neededBufferSizeInBytes = _bakedMesh.NumTriangles * _bakedMesh.AttributesSize * 3;
            if (_bakedMesh.Vertices == null || _bakedMesh.Vertices.Description.SizeInBytes != neededBufferSizeInBytes)
            {
                Utilities.DisposeObj(ref _bakedMesh.Vertices);
                _bakedMesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                  {
                                                                      BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                      CpuAccessFlags = CpuAccessFlags.None,
                                                                      OptionFlags = ResourceOptionFlags.None,
                                                                      SizeInBytes = neededBufferSizeInBytes,
                                                                      Usage = ResourceUsage.Default
                                                                  });
            }
            
            var byteOffset = 0;
            foreach (var evaluatedMesh in evaluatedMeshes) 
            {
                //CopySubresourceRegion(Resource source, int sourceSubresource, ResourceRegion? sourceRegion, Resource destination, int destinationSubResource, int dstX = 0, int dstY = 0, int dstZ = 0);
                context.D3DDevice.ImmediateContext.CopySubresourceRegion(evaluatedMesh.Vertices, 0, null,  _bakedMesh.Vertices, 0, byteOffset);
                byteOffset += evaluatedMesh.NumTriangles * evaluatedMesh.AttributesSize * 3;
            }

            Changed = false;
        }

        private Mesh _bakedMesh = new Mesh();
    }
}


