//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Windows.Forms;
using Framefield.Core.Inputs;


namespace Framefield.Core.ID30208404_fe00_4501_ab13_dd00dfeb0fd3
{
    public class Class_KeyPressed : OperatorPart.Function, Framefield.Core.OperatorPartTraits.IAsyncDependend
    {
        public bool AsyncChanged { get { return _asyncChanged; } }

        //>>> _inputids
        private enum InputId
        {
            Key = 0
        }
        //<<< _inputids 

        public Class_KeyPressed()
        {
            Input.Keyboard.KeyPressedEvent += HandleKeyboardKeyPressedEvent;
            Input.Keyboard.KeyReleasedEvent += HandleKeyboardKeyReleasedEvent;
        }

        public override void Dispose()
        {
            Input.Keyboard.KeyPressedEvent -= HandleKeyboardKeyPressedEvent;
            Input.Keyboard.KeyReleasedEvent -= HandleKeyboardKeyReleasedEvent;
        }

        void HandleKeyboardKeyPressedEvent(object o, KeyboardInput.KeyEventArgs e)
        {
            if (e.Keys == _key)
            {
                _asyncChanged = true;
            }
        }
        void HandleKeyboardKeyReleasedEvent(object o, KeyboardInput.KeyEventArgs e)
        {
            if (e.Keys == _key)
            {
                _asyncChanged = true;
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Key = inputs[(int)InputId.Key].Eval(context).Text;
            //<<< _params

            try
            {
                _key = (Keys)_keysConverter.ConvertFromString(Key);
            }
            catch (Exception) {
            }

            context.Value = Input.Keyboard.IsKeyDown(_key) ? 1 : 0;
            _asyncChanged = false;
            return context;
        }

        bool _asyncChanged = false;
        KeysConverter _keysConverter = new KeysConverter();
        Keys _key;
    }

}

