//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
//using System.Math;

namespace Framefield.Core.ID5c94132e_6dd5_4f39_874c_26b1f8577288
{
    public class Class_LFO : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            RangeMin = 0,
            RangeMax = 1,
            Frequency = 2,
            Phase = 3
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            
            //>>> _params
            var RangeMin = inputs[(int)InputId.RangeMin].Eval(context).Value;
            var RangeMax = inputs[(int)InputId.RangeMax].Eval(context).Value;
            var Range = new Vector2(RangeMin, RangeMax);
            var Frequency = inputs[(int)InputId.Frequency].Eval(context).Value;
            var Phase = inputs[(int)InputId.Phase].Eval(context).Value;
            //<<< _params
            

            context.Value = Utilities.Lerp(
                                        RangeMin, 
                                        RangeMax,
                                        (float) (
                                        Math.Sin(context.Time * Frequency * Math.PI 
                                               + (Phase * Math.PI/ 180) *1 ) / 2f + 0.5f));
            return context;
        }
    }
}


