//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID628e82c2_9e51_454b_8ad6_7876510b0a6c
{
    public class Class_LinearFunc : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            x = 0,
            k = 1,
            b = 2
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var x = inputs[(int)InputId.x].Eval(context).Value;
            var k = inputs[(int)InputId.k].Eval(context).Value;
            var b = inputs[(int)InputId.b].Eval(context).Value;
            //<<< _params
            
            
            context.Value = (float)(k * x + b);
            
            return context;
        }
    }
}

