//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.Direct3D;
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;
using System.Dynamic;

namespace Framefield.Core.ID62735d7a_fb00_414c_8da5_12fee49efdbe
{
    public class Class_MeshSurfaceCenters : FXSourceCodeFunction, IFXSceneSourceCode
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            SkipSize = 1,
            Mesh = 2,
            SpinRandomX = 3,
            SpinRandomY = 4,
            SpinRandomZ = 5
        }
        //<<< _inputids


        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _mesh);
            base.Dispose();
        }


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        bool _firstEval = true;
        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (_firstEval) 
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }
            
            if (!Changed && _mesh.Vertices != null)
            {
                dynamic obj = new ExpandoObject();
                obj.PosBuffer = _mesh.Vertices;
                context.Dynamic = obj;
                return;
            }

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var SkipSize = inputs[(int)InputId.SkipSize].Eval(context).Value;
            var Mesh = inputs[(int)InputId.Mesh].Eval(context).Mesh;
            var SpinRandomX = inputs[(int)InputId.SpinRandomX].Eval(context).Value;
            var SpinRandomY = inputs[(int)InputId.SpinRandomY].Eval(context).Value;
            var SpinRandomZ = inputs[(int)InputId.SpinRandomZ].Eval(context).Value;
            var SpinRandom = new Vector3(SpinRandomX, SpinRandomY, SpinRandomZ);
            //<<< _params

            if (Mesh == null)
                return;

            _mesh.AttributesSize = Mesh.AttributesSize;
            _mesh.NumTriangles = Mesh.NumTriangles;
            _mesh.InputElements = Mesh.InputElements;
            int stride = (int)SkipSize;
            int targetSize = Mesh.NumTriangles / Math.Max(stride, 1);
            if (_mesh.Vertices == null || _mesh.Vertices.Description.SizeInBytes != targetSize)
            {
                Utilities.DisposeObj(ref _mesh.Vertices);
                _mesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                  {
                                                                      BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                      CpuAccessFlags = CpuAccessFlags.None,
                                                                      OptionFlags = ResourceOptionFlags.None,
                                                                      SizeInBytes = targetSize*16*4,
                                                                      Usage = ResourceUsage.Default,                                                                      
                                                                  }) 
                                     {
                                         DebugName = "SurfaceCenterBuffer"
                                     };
//Logger.Info(this, "target size: {0}", targetSize);
            }
            SetScalar("SkipSize", SkipSize);
            SetVector("SpinRandom", SpinRandom);

            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(_mesh.Vertices, 0) });
            var prevDSS = context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState;
            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = new DepthStencilState(context.D3DDevice,
                                                                                                      new DepthStencilStateDescription()
                                                                                                          {
                                                                                                              IsDepthEnabled = false,
                                                                                                              IsStencilEnabled = false
                                                                                                          });
            context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
            context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;
            context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(Mesh.Vertices, Mesh.AttributesSize, 0));
            var technique = _effect.GetTechniqueByIndex(0);
            technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
            context.D3DDevice.ImmediateContext.Draw((Mesh.NumTriangles)*3, 0);
//Logger.Info(this, "input mesh num vertices: {0}", Mesh.NumTriangles*3);
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(null, 0) });
            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = prevDSS;

            //context.Mesh = _mesh;
            
            dynamic obj2 = new ExpandoObject();
            obj2.PosBuffer = _mesh.Vertices;
            context.Dynamic = obj2;

//Logger.Info(this, "update surface positions");
            Changed = false;
        }

        private Mesh _mesh = new Mesh();
    }
}


