using System.Collections.Generic;
using SharpDX;
using Framefield.Core.OperatorPartTraits;

namespace Framefield.Core.ID7fcf1367_411d_4735_bbcb_d6eff2663c8f
{
    public class Class_Move2d : OperatorPart.Function, ISceneTransform
    {
        // ISceneTransform
        public Matrix Transform
        {
            get
            {
                UpdateTransform(new OperatorPartContext(), OperatorPart.Connections);
                return _transform;
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var SceneInput = inputs[0];
            
            UpdateTransform(context, inputs);
            var prevTransform = context.ObjectTWorld;

            context.ObjectTWorld = _transform * prevTransform;
            SceneInput.Eval(context);
            context.ObjectTWorld = prevTransform;

            return context;
        }
        
        // >>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            MoveX = 1,
            MoveY = 2,
            Z = 3,
            Direction = 4
        }
        // <<< _inputids

        private void UpdateTransform(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (!Changed)
                return;
                
            // >>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var MoveX = inputs[(int)InputId.MoveX].Eval(context).Value;
            var MoveY = inputs[(int)InputId.MoveY].Eval(context).Value;
            var Move = new Vector2(MoveX, MoveY);
            var Z = inputs[(int)InputId.Z].Eval(context).Value;
            var Direction = inputs[(int)InputId.Direction].Eval(context).Value;
            // <<< _params

            var translation = new Vector3(MoveX, MoveY, Z);
            var rotation = Quaternion.RotationYawPitchRoll(0, 0, MathUtil.DegreesToRadians(Direction));
            var scale = new Vector3(1, 1, 1);
            

            _transform = Matrix.Transformation(Vector3.Zero, Quaternion.Zero, scale, Vector3.Zero, rotation, translation);
            
            var rotationMatrix = Matrix.Identity;
            var axis = new Vector3(0,0,1);
            Matrix.RotationAxis(ref axis , MathUtil.DegreesToRadians(-Direction), out rotationMatrix);
            _transform*= rotationMatrix;
            
        }

        private Matrix _transform;
    }
}
