//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Collections;
using OSC;


namespace Framefield.Core.IDb08adeb1_e276_479c_9e60_1c564f5c4e80
{
    public class Class_OSCMessageVector2 : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            OSCPath = 0,
            FrameMessages = 1
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            ValueX = 0,
            ValueY = 1
        }
        //<<< _outputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            if (Changed)
            {
                //>>> _params
                var OSCPath = inputs[(int)InputId.OSCPath].Eval(context).Text;
                var FrameMessages = inputs[(int)InputId.FrameMessages].Eval(context).Dynamic;  // Needs to be checked for null!
                //<<< _params
                
                if (FrameMessages != null)
                {
                    var dict = (IDictionary<string, OSCMessage>)FrameMessages;
                    OSCMessage msg;
                    
                    if (dict.TryGetValue(OSCPath, out msg))
                    {
                        if (msg.Values.Count != _numComponents)
                        {
                            Logger.Error(this, "Expected {0} params, got {1}",
                                              _numComponents, msg.Values.Count);
                            return context;
                        }
                       
                       for (int i = 0; i < _numComponents; ++i)
                       {
                           var val = msg.Values[i];
                           
                           try
                           {
                               _lastValue[i] = Convert.ToSingle(val);
                           }
                           catch (FormatException)
                           {
                              Logger.Error(this, "The {0} value {1} is not recognized as a valid Single value.",
                                                val.GetType().Name, val);
                           }                     
                           catch (OverflowException)
                           {
                              Logger.Error(this, "The {0} value {1} is outside the range of the Single type.",
                                                val.GetType().Name, val);
                           }
                           catch (InvalidCastException)
                           {
                              Logger.Error(this, "Conversion of the {0} value {1} to a Single is not supported.",
                                                val.GetType().Name, val);
                           }          
                       }
                    }
                }
            
                Changed = false;
            }

            switch (outputIdx)
            {
                case (int)OutputId.ValueX:
                    context.Value = _lastValue.Y;
                    break;
                case (int)OutputId.ValueY:
                    context.Value = _lastValue.X;
                    break;
            }
            
            return context;
        }

        const int _numComponents = 2;
		private string _path;
		private Vector2 _lastValue; 
    }
}

