//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Curve;

namespace Framefield.Core.ID17e0f404_b8b5_47a4_89f9_f4cac13b8b15
{
    public class Class_ParameterCurve : Curve.Curve
    {
        //>>> _inputids
        private enum InputId
        {
            U = 0
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            V = 0,
            This = 1
        }
        //<<< _outputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var U = inputs[(int)InputId.U].Eval(context).Value;
            //<<< _params

            switch((OutputId)outputIdx) {
                case OutputId.V:
                    context.Value = (float)GetSampledValue(U);
                    break;
                case OutputId.This:
                    context.Dynamic = this;
                    break;
            }
            
            return context;
        }

        public Class_ParameterCurve() {
            ChangedEventEnabled = true;
        }

        private CurveState State
        {
            get
            {
                try
                {
                    return OperatorPart.Parent.GetOperatorPartState(OperatorPart.ID) as CurveState;
                }
                catch (Exception ex)
                {
                    Logger.Error(this,"could not get the CurveState for this Curve op: {0}", ex.Message);
                }
                return null;
            }
        }
    }

    //only here so that an operatorpartstate can be found
    //and created
    public class CurveState : Curve.CurveState
    {
    }
} 
