//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.ID0574156e_8742_48fb_9273_27f44ef3b3bf
{
    public class Class_PhongCubeMapping : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            CubeMap = 2,
            Base = 3,
            Reflection = 4
        }
        //<<< _inputids

        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            
            public OperatorPart.Function ParentFunc {get;set;}
        }
        #endregion

        public Class_PhongCubeMapping()
        {
            _renderer = new Renderer(){ParentFunc = this};
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var CubeMap = inputs[(int)InputId.CubeMap].Eval(context).Image; // Needs to be checked for null!
            var Base = inputs[(int)InputId.Base].Eval(context).Value;
            var Reflection = inputs[(int)InputId.Reflection].Eval(context).Value;
            //<<< _params

            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            //>>> __setup
            using (var CubeMapView = new ShaderResourceView(context.D3DDevice, CubeMap))
            {
                _effect.GetVariableByName("CubeMap").AsShaderResource().SetResource(CubeMapView);
            //<<< __setup
    
                using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer"))
                {
                    _effect.GetVariableByName("Base").AsScalar().Set(Base);
                    _effect.GetVariableByName("Reflection").AsScalar().Set(Reflection);
                    context.Effect = _effect;
                    context.Renderer = _renderer;
    
                    Scene.Eval(context);
                }
            }

            return context;
        }

        Renderer _renderer;
    }
}


