//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDcda72e3e_2cf8_4456_80cf_e9832260de7e
{
    public class Class_ProcedurePaletteColorize : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            nPallete = 2,
            outGamma = 3,
            inBright = 4,
            ColorsLimit = 5,
            outBright = 6,
            outContrast = 7,
            IsDither = 8,
            DitherResWidth = 9,
            DitherResHeight = 10,
            inContrast = 11,
            inMulColorR = 12,
            inMulColorG = 13,
            inMulColorB = 14,
            inMulColorA = 15
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var nPallete = (int) inputs[(int)InputId.nPallete].Eval(context).Value;
            var outGamma = inputs[(int)InputId.outGamma].Eval(context).Value;
            var inBright = inputs[(int)InputId.inBright].Eval(context).Value;
            var ColorsLimit = inputs[(int)InputId.ColorsLimit].Eval(context).Value;
            var outBright = inputs[(int)InputId.outBright].Eval(context).Value;
            var outContrast = inputs[(int)InputId.outContrast].Eval(context).Value;
            var IsDither = (int) inputs[(int)InputId.IsDither].Eval(context).Value;
            var DitherResWidth = inputs[(int)InputId.DitherResWidth].Eval(context).Value;
            var DitherResHeight = inputs[(int)InputId.DitherResHeight].Eval(context).Value;
            var DitherRes = new Vector2(DitherResWidth, DitherResHeight);
            var inContrast = inputs[(int)InputId.inContrast].Eval(context).Value;
            var inMulColorR = inputs[(int)InputId.inMulColorR].Eval(context).Value;
            var inMulColorG = inputs[(int)InputId.inMulColorG].Eval(context).Value;
            var inMulColorB = inputs[(int)InputId.inMulColorB].Eval(context).Value;
            var inMulColorA = inputs[(int)InputId.inMulColorA].Eval(context).Value;
            var inMulColor = new Color4(inMulColorR, inMulColorG, inMulColorB, inMulColorA);
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("nPallete").AsScalar().Set(nPallete);
                    _effect.GetVariableByName("outGamma").AsScalar().Set(outGamma);
                    _effect.GetVariableByName("inBright").AsScalar().Set(inBright);
                    _effect.GetVariableByName("ColorsLimit").AsScalar().Set(ColorsLimit);
                    _effect.GetVariableByName("outBright").AsScalar().Set(outBright);
                    _effect.GetVariableByName("outContrast").AsScalar().Set(outContrast);
                    _effect.GetVariableByName("IsDither").AsScalar().Set(IsDither);
                    _effect.GetVariableByName("DitherRes").AsVector().Set(new Vector2(DitherResWidth, DitherResHeight));
                    _effect.GetVariableByName("inContrast").AsScalar().Set(inContrast);
                    _effect.GetVariableByName("inMulColor").AsVector().Set(new Vector4(inMulColorR, inMulColorG, inMulColorB, inMulColorA));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

