//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDdb566d97_faf0_42d2_87a9_8cfff1a338d5
{
    public class Class_RaymarchVoronoi : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            OriginX = 1,
            OriginY = 2,
            OriginZ = 3,
            Gamma = 4,
            Fog0R = 5,
            Fog0G = 6,
            Fog0B = 7,
            Fog0A = 8,
            Fog1R = 9,
            Fog1G = 10,
            Fog1B = 11,
            Fog1A = 12,
            Angle = 13,
            Dist = 14,
            MaxDist = 15
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var OriginX = inputs[(int)InputId.OriginX].Eval(context).Value;
            var OriginY = inputs[(int)InputId.OriginY].Eval(context).Value;
            var OriginZ = inputs[(int)InputId.OriginZ].Eval(context).Value;
            var Origin = new Vector3(OriginX, OriginY, OriginZ);
            var Gamma = inputs[(int)InputId.Gamma].Eval(context).Value;
            var Fog0R = inputs[(int)InputId.Fog0R].Eval(context).Value;
            var Fog0G = inputs[(int)InputId.Fog0G].Eval(context).Value;
            var Fog0B = inputs[(int)InputId.Fog0B].Eval(context).Value;
            var Fog0A = inputs[(int)InputId.Fog0A].Eval(context).Value;
            var Fog0 = new Color4(Fog0R, Fog0G, Fog0B, Fog0A);
            var Fog1R = inputs[(int)InputId.Fog1R].Eval(context).Value;
            var Fog1G = inputs[(int)InputId.Fog1G].Eval(context).Value;
            var Fog1B = inputs[(int)InputId.Fog1B].Eval(context).Value;
            var Fog1A = inputs[(int)InputId.Fog1A].Eval(context).Value;
            var Fog1 = new Color4(Fog1R, Fog1G, Fog1B, Fog1A);
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Dist = inputs[(int)InputId.Dist].Eval(context).Value;
            var MaxDist = inputs[(int)InputId.MaxDist].Eval(context).Value;
            //<<< _params
            
//            if(Image == null)
//                return context;

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Origin").AsVector().Set(new Vector3(OriginX, OriginY, OriginZ));
                    _effect.GetVariableByName("Gamma").AsScalar().Set(Gamma);
                    _effect.GetVariableByName("Fog0").AsVector().Set(new Vector4(Fog0R, Fog0G, Fog0B, Fog0A));
                    _effect.GetVariableByName("Fog1").AsVector().Set(new Vector4(Fog1R, Fog1G, Fog1B, Fog1A));
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Dist").AsScalar().Set(Dist);
                    _effect.GetVariableByName("MaxDist").AsScalar().Set(MaxDist);
                //<<< _setup

                 //_effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

