//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf3365080_ed24_457b_9022_491a9e46fafe
{
    public class Class_SmoothValue : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            SetHardTrigger = 1,
            Acceleration = 2,
            Precision = 3
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var SetHardTrigger = inputs[(int)InputId.SetHardTrigger].Eval(context).Value;
            var Acceleration = inputs[(int)InputId.Acceleration].Eval(context).Value;
            var Precision = inputs[(int)InputId.Precision].Eval(context).Value;
            //<<< _params
            
            if (SetHardTrigger > 0.5f)
            {
                _targetValue = Value;
                _smoothInterpolator.SetValue(Value);
            }
            _smoothInterpolator.Acceleration = Acceleration;
            _smoothInterpolator.Precision = Precision;

            if (_targetValue != Value)
            {
                _smoothInterpolator.AnimateTo(Value);
                _targetValue = Value;
            }

            context.Value = (float)_smoothInterpolator.GetValue(context.GlobalTime);

            return context;
        }

        private float _targetValue = 0;
        private SmoothInterpolator _smoothInterpolator = new SmoothInterpolator(defaultValue:0, acceleration:0.4, delta:0.001);
    }
}

