//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;
using Framefield.Core.Testing;

namespace Framefield.Core.ID6c708656_5376_47fa_9d85_a96bac186e17
{
    public class Class_StringTester : TesterFunction
    {
        public override void SetupTestCase(OperatorPart subtree)
        {
            _subTree = subtree;
        }

        public override bool GenerateData(OperatorPartContext context)
        {
            _currentString = _subTree.Eval(context).Text;
            return true;
        }

        public override void StoreAsReferenceData(int index, int count)
        {
            SetReferenceString(index, count, _currentString);
        }

        public override bool CompareData(int index, int count, float threshold, out string compareResultString)
        {
            compareResultString = String.Empty;
            bool result = false;
            string referenceString = String.Empty;
            try
            {
                referenceString = GetReferenceString(index, count);
            }
            catch (IOException ex)
            {
                compareResultString = String.Format("reference not loaded: {0}", ex.Message);
                return false;
            }

            int deviation = Math.Abs(String.CompareOrdinal(_currentString, referenceString));
            if (deviation <= threshold)
            {
                result = true;
            }
            else
            {
                result = false;
                compareResultString = String.Format("\"{0}\" != \"{1}\", ", _currentString, referenceString);
            }
            compareResultString += String.Format("{0}", deviation);
            return result;
        }

        string GetReferenceFilename(int index, int count)
        {
            return GetReferenceFilename(index, count, ".String");
        }

        string GetReferenceString(int index, int count)
        {
            return File.ReadAllText(GetReferenceFilename(index, count));
        }

        void SetReferenceString(int index, int count, string data)
        {
            FileInfo fi = new FileInfo(GetReferenceFilename(index, count));
            if (!Directory.Exists(fi.DirectoryName))
                Directory.CreateDirectory(fi.DirectoryName);
            using (StreamWriter outfile = new StreamWriter(fi.FullName))
            {
                outfile.Write(data);
            }
        }

        OperatorPart _subTree;
        string _currentString;
    }
}

