using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Xml;
using SharpDX;

namespace Framefield.Core.ID3733bbeb_c4fe_41a6_9ec5_404861a84c0a
{
    public class Class_StringsFromXmlFile : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            FilePath = 0,
            Reset = 1
        }
        //<<< _inputids

        bool _firstEval = true;
        List<string> _outList;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var FilePath = inputs[(int)InputId.FilePath].Eval(context).Text;
            var Reset = inputs[(int)InputId.Reset].Eval(context).Value;
            //<<< _params

            try {
            // DART FIXED:
            if (_firstEval || Reset != 0.0) {
                    _firstEval = false;
                    dynamic obj = new ExpandoObject();
        
                    XmlDocument doc = new XmlDocument();
                    doc.Load(FilePath);
                    XmlElement root = doc.DocumentElement;
        
                    _outList = new List<string>();
                    foreach (XmlNode item in root.GetElementsByTagName("item")) {
                        var value = item["title"].InnerText;
                        _outList.Add(value);
                    }
                }
                context.Dynamic = _outList;
                return context;
            } catch (Exception e) {
                Logger.Error(this, "error xml parse: {0} ", e.Message);
                return context;
            }
        }
    }
}

