//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID56f95fee_3956_475a_b5bc_a0d173a1a70e
{
    public class Class_StripeDisplace : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Angle = 2,
            Width = 3,
            CenterX = 4,
            CenterY = 5,
            ShiftAmount = 6,
            ShiftRandom = 7,
            OffsetAmount = 8,
            OffsetRandom = 9,
            FillColorR = 10,
            FillColorG = 11,
            FillColorB = 12,
            FillColorA = 13,
            NoiseScale = 14,
            NoiseOffset = 15,
            SampleCount = 16,
            ChromaticAberation = 17,
            MotionBlur = 18
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Width = inputs[(int)InputId.Width].Eval(context).Value;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var ShiftAmount = inputs[(int)InputId.ShiftAmount].Eval(context).Value;
            var ShiftRandom = inputs[(int)InputId.ShiftRandom].Eval(context).Value;
            var Shift = new Vector2(ShiftAmount, ShiftRandom);
            var OffsetAmount = inputs[(int)InputId.OffsetAmount].Eval(context).Value;
            var OffsetRandom = inputs[(int)InputId.OffsetRandom].Eval(context).Value;
            var Offset = new Vector2(OffsetAmount, OffsetRandom);
            var FillColorR = inputs[(int)InputId.FillColorR].Eval(context).Value;
            var FillColorG = inputs[(int)InputId.FillColorG].Eval(context).Value;
            var FillColorB = inputs[(int)InputId.FillColorB].Eval(context).Value;
            var FillColorA = inputs[(int)InputId.FillColorA].Eval(context).Value;
            var FillColor = new Color4(FillColorR, FillColorG, FillColorB, FillColorA);
            var NoiseScale = inputs[(int)InputId.NoiseScale].Eval(context).Value;
            var NoiseOffset = inputs[(int)InputId.NoiseOffset].Eval(context).Value;
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            var ChromaticAberation = inputs[(int)InputId.ChromaticAberation].Eval(context).Value;
            var MotionBlur = inputs[(int)InputId.MotionBlur].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
                
                //context.BlendState = Renderer.DisabledBlendState;
                
                if(Image == null)
                    return;

                //SampleCount = (float)Math.Floor(SampleCount);
                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Width").AsScalar().Set(Width);
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Shift").AsVector().Set(new Vector2(ShiftAmount, ShiftRandom));
                    _effect.GetVariableByName("Offset").AsVector().Set(new Vector2(OffsetAmount, OffsetRandom));
                    _effect.GetVariableByName("FillColor").AsVector().Set(new Vector4(FillColorR, FillColorG, FillColorB, FillColorA));
                    _effect.GetVariableByName("NoiseScale").AsScalar().Set(NoiseScale);
                    _effect.GetVariableByName("NoiseOffset").AsScalar().Set(NoiseOffset);
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                    _effect.GetVariableByName("ChromaticAberation").AsScalar().Set(ChromaticAberation);
                    _effect.GetVariableByName("MotionBlur").AsScalar().Set(MotionBlur);
                //<<< _setup

                    var prevBlendState = context.BlendState;
                    //context.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;

/*
                    var blendStateDescription = new BlendStateDescription();
                    blendStateDescription.RenderTarget[0].IsBlendEnabled = true;
                    blendStateDescription.RenderTarget[0].SourceBlend = BlendOption.SourceAlpha;
                    blendStateDescription.RenderTarget[0].DestinationBlend = BlendOption.InverseSourceAlpha;
                    blendStateDescription.RenderTarget[0].BlendOperation = BlendOperation.Add;
                    blendStateDescription.RenderTarget[0].SourceAlphaBlend = BlendOption.One;
                    blendStateDescription.RenderTarget[0].DestinationAlphaBlend = BlendOption.InverseSourceAlpha;
                    blendStateDescription.RenderTarget[0].AlphaBlendOperation = BlendOperation.Add;
                    blendStateDescription.RenderTarget[0].RenderTargetWriteMask = ColorWriteMaskFlags.All;
                    blendStateDescription.AlphaToCoverageEnable = false;
                    var newBlendState = new BlendState(D3DDevice.Device, blendStateDescription);
                    context.BlendState = newBlendState;
                    */
                    
                    Render(context);
    
                    //context.BlendState = prevBlendState;

                //Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

