//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID82fa0adc_4f9b_4546_8086_c1753f068ff3
{
    public class Class_Swell : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            InputTrigger = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var InputTrigger = inputs[(int)InputId.InputTrigger].Eval(context).Value;
            //<<< _params

            if (context.Time < _triggerUpTime || context.Time < _triggerDownTime)
            {
                //reset values to be on 'falling' ramp
                _triggerUpTime = context.Time - 2;
                _lastUpMappedTime = 0;
                _triggerDownTime = context.Time - 1;
                _lastDownMappedTime = 0;
                _oldInputTrigger = 0;
            }

            bool inputTriggerUp = _oldInputTrigger < 0.5f && InputTrigger > 0.5f;
            bool inputTriggerDown = _oldInputTrigger > 0.5f && InputTrigger < 0.5f;
            _oldInputTrigger = InputTrigger;
            if (inputTriggerUp)
            {
                _triggerUpTime = context.Time;
                _lastUpMappedTime = 0;
            }
            if (inputTriggerDown)
            {
                _triggerDownTime = context.Time;
                _lastDownMappedTime = 0;
            }

            float mappedTime = 0;
            if (_triggerDownTime <= _triggerUpTime)
            {
                //raising
                mappedTime = _lastDownMappedTime + context.Time - _triggerUpTime;
                _lastUpMappedTime = Utilities.Clamp(mappedTime, 0.0f, 1.0f);
            }
            else
            {
                //falling
                mappedTime = _lastUpMappedTime - (context.Time - _triggerDownTime);
                _lastDownMappedTime = Utilities.Clamp(mappedTime, 0.0f, 1.0f);
            }
            
            context.Value = TimeToValueFunction(mappedTime);
            return context;
        }
        
        float TimeToValueFunction(float time)
        {
            return Utilities.Clamp(time, 0.0f, 1.0f);
        }

        float _oldInputTrigger;
        float _triggerUpTime = 99999;
        float _lastUpMappedTime = 0;
        float _triggerDownTime = 99999;
        float _lastDownMappedTime = 0;
    }
}

