//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID66b7c9b7_4fdf_4193_96d0_6c9640debe1a
{

    public class Class_Multiply : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Text = 0,
            Multiply = 1
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Text = inputs[(int)InputId.Text].Eval(context).Text;
            var Multiply = inputs[(int)InputId.Multiply].Eval(context).Value;
            //<<< _params
            
            try {
                context.Value = (float)( Double.Parse(Text) * Multiply);
            }
            catch(FormatException) {
                //Logger.Warn(this,"Can't convert '{0}' to number", Text);
                context.Value=0;
            }
            
            return context;
        }
    }
}

