//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDce48a182_1763_4bbc_b16b_edffd73c4b15
{
    public class Class_Tunnel2DStripes : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ColorAR = 1,
            ColorAG = 2,
            ColorAB = 3,
            ColorAA = 4,
            ColorBR = 5,
            ColorBG = 6,
            ColorBB = 7,
            ColorBA = 8,
            CenterX = 9,
            CenterY = 10,
            Offset = 11,
            TileFreq = 12,
            iTime = 13,
            Stripe1X = 14,
            Stripe1Y = 15,
            Stripe2X = 16,
            Stripe2Y = 17,
            ShiftX = 18,
            ShiftY = 19
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var ColorAR = inputs[(int)InputId.ColorAR].Eval(context).Value;
            var ColorAG = inputs[(int)InputId.ColorAG].Eval(context).Value;
            var ColorAB = inputs[(int)InputId.ColorAB].Eval(context).Value;
            var ColorAA = inputs[(int)InputId.ColorAA].Eval(context).Value;
            var ColorA = new Color4(ColorAR, ColorAG, ColorAB, ColorAA);
            var ColorBR = inputs[(int)InputId.ColorBR].Eval(context).Value;
            var ColorBG = inputs[(int)InputId.ColorBG].Eval(context).Value;
            var ColorBB = inputs[(int)InputId.ColorBB].Eval(context).Value;
            var ColorBA = inputs[(int)InputId.ColorBA].Eval(context).Value;
            var ColorB = new Color4(ColorBR, ColorBG, ColorBB, ColorBA);
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            var TileFreq = inputs[(int)InputId.TileFreq].Eval(context).Value;
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var Stripe1X = inputs[(int)InputId.Stripe1X].Eval(context).Value;
            var Stripe1Y = inputs[(int)InputId.Stripe1Y].Eval(context).Value;
            var Stripe1 = new Vector2(Stripe1X, Stripe1Y);
            var Stripe2X = inputs[(int)InputId.Stripe2X].Eval(context).Value;
            var Stripe2Y = inputs[(int)InputId.Stripe2Y].Eval(context).Value;
            var Stripe2 = new Vector2(Stripe2X, Stripe2Y);
            var ShiftX = inputs[(int)InputId.ShiftX].Eval(context).Value;
            var ShiftY = inputs[(int)InputId.ShiftY].Eval(context).Value;
            var Shift = new Vector2(ShiftX, ShiftY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("ColorA").AsVector().Set(new Vector4(ColorAR, ColorAG, ColorAB, ColorAA));
                    _effect.GetVariableByName("ColorB").AsVector().Set(new Vector4(ColorBR, ColorBG, ColorBB, ColorBA));
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Offset").AsScalar().Set(Offset);
                    _effect.GetVariableByName("TileFreq").AsScalar().Set(TileFreq);
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("Stripe1").AsVector().Set(new Vector2(Stripe1X, Stripe1Y));
                    _effect.GetVariableByName("Stripe2").AsVector().Set(new Vector2(Stripe2X, Stripe2Y));
                    _effect.GetVariableByName("Shift").AsVector().Set(new Vector2(ShiftX, ShiftY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



